/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.tasks;

import com.gamingmesh.jobs.Jobs;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;

public class DatabaseSaveThread
extends Thread {
    private volatile boolean running = true;
    private int sleep;

    public DatabaseSaveThread(int duration) {
        super("Jobs-DatabaseSaveTask");
        this.sleep = duration * 60000;
    }

    @Override
    public void run() {
        String message = ChatColor.YELLOW + "[Jobs] Started database save task.";
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        console.sendMessage(message);
        while (this.running) {
            try {
                DatabaseSaveThread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                this.running = false;
                continue;
            }
            try {
                Jobs.getPlayerManager().saveAll();
            }
            catch (Throwable t) {
                t.printStackTrace();
                message = ChatColor.RED + "[Jobs] Exception in DatabaseSaveTask, stopping auto save!";
                console.sendMessage(message);
                this.running = false;
            }
        }
        message = ChatColor.YELLOW + "[Jobs] Database save task shutdown!";
        console.sendMessage(message);
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
    }
}

