/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.listeners;

import com.gamingmesh.jobs.Jobs;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class PistonProtectionListener
implements Listener {
    private Jobs plugin;

    public PistonProtectionListener(Jobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void OnBlockMove(BlockPistonExtendEvent event) {
        if (event.getBlock() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getBlock().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!Jobs.getGCManager().useBlockProtection) {
            return;
        }
        BlockFace dir = event.getDirection();
        int x = dir.getModX();
        int y = dir.getModY();
        int z = dir.getModZ();
        for (Block one : event.getBlocks()) {
            Location oldLoc = one.getLocation();
            Location newLoc = oldLoc.clone().add((double)x, (double)y, (double)z);
            Long bp2 = Jobs.getBpManager().getTime(oldLoc);
            if (bp2 != null) {
                Jobs.getBpManager().add(newLoc, bp2);
                continue;
            }
            Integer cd = Jobs.getBpManager().getBlockDelayTime(one);
            if (cd != null) {
                Jobs.getBpManager().add(newLoc, (Long)(System.currentTimeMillis() + (long)(cd * 1000)));
                continue;
            }
            if (!Jobs.getGCManager().useGlobalTimer) continue;
            Jobs.getBpManager().add(newLoc, (Long)(System.currentTimeMillis() + (long)(Jobs.getGCManager().globalblocktimer * 1000)));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void OnBlockRetractMove(BlockPistonRetractEvent event) {
        if (event.getBlock() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getBlock().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!Jobs.getGCManager().useBlockProtection) {
            return;
        }
        BlockFace dir = event.getDirection();
        int x = dir.getModX();
        int y = dir.getModY();
        int z = dir.getModZ();
        for (Block one : Jobs.getNms().getPistonRetractBlocks(event)) {
            Location oldLoc = one.getLocation();
            Location newLoc = oldLoc.clone().add((double)x, (double)y, (double)z);
            Long bp2 = Jobs.getBpManager().getTime(oldLoc);
            if (bp2 != null) {
                Jobs.getBpManager().add(newLoc, bp2);
                continue;
            }
            Integer cd = Jobs.getBpManager().getBlockDelayTime(one);
            if (cd != null) {
                Jobs.getBpManager().add(newLoc, (Long)(System.currentTimeMillis() + (long)(cd * 1000)));
                continue;
            }
            if (!Jobs.getGCManager().useGlobalTimer) continue;
            Jobs.getBpManager().add(newLoc, (Long)(System.currentTimeMillis() + (long)(Jobs.getGCManager().globalblocktimer * 1000)));
        }
    }
}

