/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.listeners;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.actions.ItemActionInfo;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.events.skills.abilities.McMMOPlayerAbilityActivateEvent;
import com.gmail.nossr50.events.skills.abilities.McMMOPlayerAbilityDeactivateEvent;
import com.gmail.nossr50.events.skills.repair.McMMOPlayerRepairCheckEvent;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class McMMOlistener
implements Listener {
    private Jobs plugin;
    public boolean mcMMOPresent = false;
    HashMap<String, HashMap<AbilityType, Long>> map = new HashMap();

    public McMMOlistener(Jobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void OnItemrepair(McMMOPlayerRepairCheckEvent event) {
        if (event.getPlayer() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack resultStack = event.getRepairedObject();
        if (resultStack == null) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.REPAIR));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void OnAbilityOn(McMMOPlayerAbilityActivateEvent event) {
        HashMap<AbilityType, Long> InfoMap = new HashMap<AbilityType, Long>();
        if (this.map.containsKey(event.getPlayer().getName())) {
            InfoMap = this.map.get(event.getPlayer().getName());
        }
        InfoMap.put(event.getAbility(), System.currentTimeMillis() + (long)(event.getAbility().getMaxLength() * 1000));
        this.map.put(event.getPlayer().getName(), InfoMap);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void OnAbilityOff(McMMOPlayerAbilityDeactivateEvent event) {
        if (this.map.containsKey(event.getPlayer().getName())) {
            HashMap<AbilityType, Long> InfoMap = this.map.get(event.getPlayer().getName());
            InfoMap.remove(event.getAbility());
            if (InfoMap.isEmpty()) {
                this.map.remove(event.getPlayer().getName());
            }
        }
    }

    public double getMultiplier(Player player) {
        if (player == null) {
            return 0.0;
        }
        HashMap<AbilityType, Long> InfoMap = this.map.get(player.getName());
        if (InfoMap == null) {
            return 0.0;
        }
        Long t = InfoMap.get(AbilityType.TREE_FELLER);
        if (t != null) {
            if (t < System.currentTimeMillis()) {
                return -(1.0 - Jobs.getGCManager().TreeFellerMultiplier);
            }
            this.map.remove(AbilityType.TREE_FELLER);
        }
        if ((t = InfoMap.get(AbilityType.GIGA_DRILL_BREAKER)) != null) {
            if (t < System.currentTimeMillis()) {
                return -(1.0 - Jobs.getGCManager().gigaDrillMultiplier);
            }
            this.map.remove(AbilityType.GIGA_DRILL_BREAKER);
        }
        if ((t = InfoMap.get(AbilityType.SUPER_BREAKER)) != null) {
            if (t < System.currentTimeMillis()) {
                return -(1.0 - Jobs.getGCManager().superBreakerMultiplier);
            }
            this.map.remove(AbilityType.SUPER_BREAKER);
        }
        return 0.0;
    }

    public boolean CheckmcMMO() {
        Plugin McMMO = Bukkit.getPluginManager().getPlugin("mcMMO");
        if (McMMO != null) {
            try {
                Class.forName("com.gmail.nossr50.api.AbilityAPI");
            }
            catch (ClassNotFoundException e) {
                this.mcMMOPresent = false;
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e[Jobs] &6mcMMO was found - &cBut your McMMO version is outdated, please update for full support."));
                return true;
            }
            this.mcMMOPresent = true;
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e[Jobs] &6mcMMO was found - Enabling capabilities."));
            return true;
        }
        return false;
    }
}

