/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.listeners;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.actions.BlockActionInfo;
import com.gamingmesh.jobs.actions.CustomKillInfo;
import com.gamingmesh.jobs.actions.EnchantActionInfo;
import com.gamingmesh.jobs.actions.EntityActionInfo;
import com.gamingmesh.jobs.actions.ExploreActionInfo;
import com.gamingmesh.jobs.actions.ItemActionInfo;
import com.gamingmesh.jobs.api.JobsChunkChangeEvent;
import com.gamingmesh.jobs.container.ActionInfo;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.BlockProtection;
import com.gamingmesh.jobs.container.DBAction;
import com.gamingmesh.jobs.container.ExploreRespond;
import com.gamingmesh.jobs.container.FastPayment;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.stuff.ChatColor;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class JobsPaymentListener
implements Listener {
    private Jobs plugin;
    private final String furnaceOwnerMetadata = "jobsFurnaceOwner";
    private final String brewingOwnerMetadata = "jobsBrewingOwner";
    private final String BlockMetadata = "BlockOwner";
    public static final String VegyMetadata = "VegyTimer";
    private final String CowMetadata = "CowTimer";
    private final String entityDamageByPlayer = "JobsEntityDamagePlayer";

    public JobsPaymentListener(Jobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCowMilking(PlayerInteractEntityEvent event) {
        ItemStack itemInHand;
        if (event.getPlayer() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!(event.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        Entity cow = event.getRightClicked();
        if (cow.getType() != EntityType.COW && cow.getType() != EntityType.MUSHROOM_COW) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (Jobs.getGCManager().CowMilkingTimer > 0 && cow.hasMetadata("CowTimer")) {
            long time = ((MetadataValue)cow.getMetadata("CowTimer").get(0)).asLong();
            if (System.currentTimeMillis() < time + (long)Jobs.getGCManager().CowMilkingTimer) {
                long timer = ((long)Jobs.getGCManager().CowMilkingTimer - (System.currentTimeMillis() - time)) / 1000L;
                player.sendMessage(Jobs.getLanguage().getMessage("message.cowtimer", "%time%", timer));
                if (Jobs.getGCManager().CancelCowMilking) {
                    event.setCancelled(true);
                }
                return;
            }
        }
        if ((itemInHand = Jobs.getNms().getItemInMainHand(player)) == null) {
            return;
        }
        if (itemInHand.getType() != Material.BUCKET) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        Jobs.action(jPlayer, new EntityActionInfo(cow, ActionType.MILK));
        Long Timer = System.currentTimeMillis();
        cow.setMetadata("CowTimer", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)Timer));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityShear(PlayerShearEntityEvent event) {
        if (event.getPlayer() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (!(event.getEntity() instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)event.getEntity();
        if (sheep.hasMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata())) {
            sheep.removeMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata(), (Plugin)this.plugin);
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jDamager = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jDamager == null) {
            return;
        }
        Jobs.action(jDamager, new CustomKillInfo(sheep.getColor().name(), ActionType.SHEAR));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBrewEvent(BrewEvent event) {
        if (event.getBlock() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!block.hasMetadata("jobsBrewingOwner")) {
            return;
        }
        List data = block.getMetadata("jobsBrewingOwner");
        if (data.isEmpty()) {
            return;
        }
        MetadataValue value = (MetadataValue)data.get(0);
        String playerName = value.asString();
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(playerName);
        if (jPlayer == null || !jPlayer.isOnline()) {
            return;
        }
        Player player = jPlayer.getPlayer();
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        ItemStack contents = event.getContents().getIngredient();
        if (contents == null) {
            return;
        }
        Jobs.action(jPlayer, new ItemActionInfo(contents, ActionType.BREW));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        JobsPlayer jPlayer;
        if (event.getBlock() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getBlock().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (block.getType() == Material.FURNACE && block.hasMetadata("jobsFurnaceOwner")) {
            block.removeMetadata("jobsFurnaceOwner", (Plugin)this.plugin);
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        BlockActionInfo bInfo = new BlockActionInfo(block, ActionType.BREAK);
        FastPayment fp = Jobs.FastPayment.get(player.getName());
        if (fp != null) {
            if (fp.getTime() > System.currentTimeMillis() && (fp.getInfo().getName().equalsIgnoreCase(bInfo.getName()) || fp.getInfo().getNameWithSub().equalsIgnoreCase(bInfo.getNameWithSub()))) {
                Jobs.perform(fp.getPlayer(), fp.getInfo(), fp.getPayment(), fp.getJob());
                return;
            }
            Jobs.FastPayment.remove(player.getName());
        }
        ItemStack item = Jobs.getNms().getItemInMainHand(player);
        if (Jobs.getGCManager().useSilkTouchProtection && item != null) {
            for (Map.Entry one : item.getEnchantments().entrySet()) {
                if (!((Enchantment)one.getKey()).getName().equalsIgnoreCase("SILK_TOUCH")) continue;
                return;
            }
        }
        if ((jPlayer = Jobs.getPlayerManager().getJobsPlayer(player)) == null) {
            return;
        }
        Jobs.action(jPlayer, (ActionInfo)bInfo, block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        JobsPlayer jPlayer;
        BlockProtection bp2;
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!Jobs.getGCManager().canPerformActionInWorld(block.getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!event.canBuild()) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            return;
        }
        if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        if (Jobs.getGCManager().useBlockProtection && ((bp2 = Jobs.getBpManager().getBp(block.getLocation())) == null || bp2.getAction() == DBAction.DELETE)) {
            Jobs.getBpManager().add(block, Jobs.getBpManager().getBlockDelayTime(block), false);
        }
        if ((jPlayer = Jobs.getPlayerManager().getJobsPlayer(player)) == null) {
            return;
        }
        Jobs.action(jPlayer, (ActionInfo)new BlockActionInfo(block, ActionType.PLACE), block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getPlayer() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        if (event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_FISH) && event.getCaught() instanceof Item) {
            JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
            if (jPlayer == null) {
                return;
            }
            ItemStack items = ((Item)event.getCaught()).getItemStack();
            Jobs.action(jPlayer, new ItemActionInfo(items, ActionType.FISH));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAnimalTame(EntityTameEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        LivingEntity animal = event.getEntity();
        if (animal.hasMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata())) {
            animal.removeMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata(), (Plugin)this.plugin);
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Player player = (Player)event.getOwner();
        if (player == null) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jDamager = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jDamager == null) {
            return;
        }
        Jobs.action(jDamager, new EntityActionInfo((Entity)animal, ActionType.TAME));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryCraft(CraftItemEvent event) {
        if (event.getWhoClicked() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getWhoClicked().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        switch (event.getAction()) {
            case NOTHING: 
            case PLACE_ALL: 
            case PLACE_SOME: 
            case PLACE_ONE: {
                return;
            }
        }
        if (!event.getSlotType().equals((Object)InventoryType.SlotType.RESULT)) {
            return;
        }
        ItemStack resultStack = event.getRecipe().getResult();
        if (resultStack == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (player.getInventory().firstEmpty() == -1 && event.isShiftClick()) {
            player.sendMessage((Object)((Object)ChatColor.RED) + Jobs.getLanguage().getMessage("message.crafting.fullinventory"));
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        if (!event.isLeftClick() && !event.isRightClick()) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        ItemStack[] sourceItems = event.getInventory().getContents();
        ArrayList<ItemStack> DyeStack = new ArrayList<ItemStack>();
        int y = -1;
        int first = 0;
        int second = 0;
        int third = 0;
        boolean leather = false;
        int i = 0;
        while (i < sourceItems.length) {
            if (sourceItems[i] != null) {
                if (sourceItems[i].getTypeId() > 0) {
                    if (sourceItems[i].getTypeId() == 351) {
                        DyeStack.add(sourceItems[i]);
                    }
                    if (++y == 0) {
                        first = sourceItems[i].getTypeId();
                    }
                    if (y == 1) {
                        second = sourceItems[i].getTypeId();
                    }
                    if (y == 2) {
                        third = sourceItems[i].getTypeId();
                    }
                }
                if (sourceItems[i].getTypeId() == 299) {
                    leather = true;
                }
            }
            ++i;
        }
        if (jPlayer == null) {
            return;
        }
        if (y == 2 && first == second && third == second) {
            Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.REPAIR));
            return;
        }
        if (y >= 2 && (third == 351 || second == 351) && leather) {
            Jobs.action(jPlayer, new ItemActionInfo(sourceItems[0], ActionType.DYE));
            for (ItemStack OneDye : DyeStack) {
                Jobs.action(jPlayer, new ItemActionInfo(OneDye, ActionType.DYE));
            }
            return;
        }
        if (!Jobs.getGCManager().PayForEachCraft) {
            Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.CRAFT));
            return;
        }
        ItemStack toCraft = event.getCurrentItem();
        ItemStack toStore = event.getCursor();
        if (JobsPaymentListener.hasItems(toCraft)) {
            if (event.isShiftClick()) {
                this.schedulePostDetection((HumanEntity)player, toCraft.clone(), jPlayer, resultStack.clone());
            } else if (JobsPaymentListener.isStackSumLegal(toCraft, toStore)) {
                int newItemsCount = toCraft.getAmount();
                while (newItemsCount >= 0) {
                    --newItemsCount;
                    Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.CRAFT));
                }
            }
        }
    }

    private Integer schedulePostDetection(final HumanEntity player, final ItemStack compareItem, final JobsPlayer jPlayer, final ItemStack resultStack) {
        final ItemStack[] preInv = player.getInventory().getContents();
        int i = 0;
        while (i < preInv.length) {
            preInv[i] = preInv[i] != null ? preInv[i].clone() : null;
            ++i;
        }
        return Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ItemStack[] postInv = player.getInventory().getContents();
                int newItemsCount = 0;
                int i = 0;
                while (i < preInv.length) {
                    ItemStack pre = preInv[i];
                    ItemStack post = postInv[i];
                    if (JobsPaymentListener.hasSameItem(compareItem, post) && (JobsPaymentListener.hasSameItem(compareItem, pre) || pre == null)) {
                        newItemsCount += post.getAmount() - (pre != null ? pre.getAmount() : 0);
                    }
                    ++i;
                }
                if (newItemsCount > 0) {
                    while (newItemsCount >= 0) {
                        --newItemsCount;
                        Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.CRAFT));
                    }
                }
            }
        }, 1L);
    }

    private static boolean hasItems(ItemStack stack) {
        return stack != null && stack.getAmount() > 0;
    }

    private static boolean hasSameItem(ItemStack a, ItemStack b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.getTypeId() == b.getTypeId() && a.getDurability() == b.getDurability() && Objects.equal((Object)a.getData(), (Object)b.getData()) && Objects.equal((Object)a.getEnchantments(), (Object)b.getEnchantments());
    }

    private static boolean isStackSumLegal(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.getAmount() + b.getAmount() <= a.getType().getMaxStackSize();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryRepair(InventoryClickEvent event) {
        if (event.getWhoClicked() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getWhoClicked().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Inventory inv = event.getInventory();
        switch (event.getAction()) {
            case NOTHING: 
            case PLACE_ALL: 
            case PLACE_SOME: 
            case PLACE_ONE: {
                return;
            }
        }
        if (!(inv instanceof AnvilInventory)) {
            return;
        }
        if (!event.getSlotType().equals((Object)InventoryType.SlotType.RESULT) || event.getSlot() != 2) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack resultStack = event.getCurrentItem();
        if (resultStack == null) {
            return;
        }
        ItemStack FirstSlot = null;
        try {
            FirstSlot = event.getInventory().getItem(0);
        }
        catch (NullPointerException e) {
            return;
        }
        if (FirstSlot == null) {
            return;
        }
        String OriginalName = null;
        String NewName = null;
        if (FirstSlot.hasItemMeta() && FirstSlot.getItemMeta().getDisplayName() != null) {
            OriginalName = FirstSlot.getItemMeta().getDisplayName();
        }
        if (resultStack.hasItemMeta() && resultStack.getItemMeta().getDisplayName() != null) {
            NewName = resultStack.getItemMeta().getDisplayName();
        }
        if (OriginalName != NewName && event.getInventory().getItem(1) == null && !Jobs.getGCManager().PayForRenaming) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.REPAIR));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEnchantItem(EnchantItemEvent event) {
        if (event.getEnchanter() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEnchanter().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Inventory inv = event.getInventory();
        if (!(inv instanceof EnchantingInventory)) {
            return;
        }
        Player player = event.getEnchanter();
        ItemStack resultStack = ((EnchantingInventory)inv).getItem();
        if (resultStack == null) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        Map enchants = event.getEnchantsToAdd();
        for (Map.Entry oneEnchant : enchants.entrySet()) {
            Integer level;
            String enchantName;
            Enchantment enchant = (Enchantment)oneEnchant.getKey();
            if (enchant == null || (enchantName = enchant.getName()) == null || (level = (Integer)oneEnchant.getValue()) == null) continue;
            Jobs.action(jPlayer, new EnchantActionInfo(enchantName, level, ActionType.ENCHANT));
        }
        Jobs.action(jPlayer, new ItemActionInfo(resultStack, ActionType.ENCHANT));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFurnaceSmelt(FurnaceSmeltEvent event) {
        if (event.getBlock() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!block.hasMetadata("jobsFurnaceOwner")) {
            return;
        }
        List data = block.getMetadata("jobsFurnaceOwner");
        if (data.isEmpty()) {
            return;
        }
        MetadataValue value = (MetadataValue)data.get(0);
        String playerName = value.asString();
        Player player = Bukkit.getServer().getPlayerExact(playerName);
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        Jobs.action(jPlayer, new ItemActionInfo(event.getResult(), ActionType.SMELT));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByPlayer(EntityDamageEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!Jobs.getGCManager().MonsterDamageUse) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent instanceof Player) {
            return;
        }
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent attackevent = (EntityDamageByEntityEvent)event;
        Entity damager = attackevent.getDamager();
        if (!(damager instanceof Player)) {
            return;
        }
        double damage = event.getFinalDamage();
        if (!(ent instanceof Damageable)) {
            return;
        }
        double s = ((Damageable)ent).getHealth();
        if (damage > s) {
            damage = s;
        }
        if (ent.hasMetadata("JobsEntityDamagePlayer")) {
            damage += ((MetadataValue)ent.getMetadata("JobsEntityDamagePlayer").get(0)).asDouble();
        }
        ent.setMetadata("JobsEntityDamagePlayer", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)damage));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByProjectile(EntityDamageByEntityEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        Entity ent = event.getEntity();
        Entity damager = event.getDamager();
        if (!(damager instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)damager;
        ProjectileSource shooter = projectile.getShooter();
        double damage = event.getFinalDamage();
        if (!(ent instanceof Damageable)) {
            return;
        }
        double s = ((Damageable)ent).getHealth();
        if (damage > s) {
            damage = s;
        }
        if (shooter instanceof Player) {
            if (ent.hasMetadata("JobsEntityDamagePlayer")) {
                damage += ((MetadataValue)ent.getMetadata("JobsEntityDamagePlayer").get(0)).asDouble();
            }
            ent.setMetadata("JobsEntityDamagePlayer", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)damage));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        double damage;
        double perc;
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent e = (EntityDamageByEntityEvent)event.getEntity().getLastDamageCause();
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity lVictim = (LivingEntity)e.getEntity();
        if (e.getDamager() instanceof Player && e.getDamager().hasMetadata("NPC")) {
            return;
        }
        if (Jobs.getGCManager().MythicMobsEnabled && Jobs.getMythicManager().MMAPI != null && Jobs.getMythicManager().MMAPI.getMobAPI().isMythicMob((Entity)lVictim)) {
            return;
        }
        if (lVictim.hasMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata()) && !Jobs.getGCManager().payNearSpawner()) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Player pDamager = null;
        if (e.getDamager() instanceof Player) {
            pDamager = (Player)e.getDamager();
        } else if (e.getDamager() instanceof Tameable) {
            Tameable t = (Tameable)e.getDamager();
            if (t.isTamed() && t.getOwner() instanceof Player) {
                pDamager = (Player)t.getOwner();
            }
        } else if (e.getDamager() instanceof Projectile) {
            Projectile pr = (Projectile)e.getDamager();
            if (pr.getShooter() instanceof Player) {
                pDamager = (Player)pr.getShooter();
            }
        } else {
            return;
        }
        if (pDamager == null) {
            return;
        }
        if (pDamager.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(pDamager, pDamager.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jDamager = Jobs.getPlayerManager().getJobsPlayer(pDamager);
        if (jDamager == null) {
            return;
        }
        if (lVictim instanceof Player && !lVictim.hasMetadata("NPC")) {
            Player VPlayer = (Player)lVictim;
            if (jDamager.getUserName().equalsIgnoreCase(VPlayer.getName())) {
                return;
            }
        }
        if (Jobs.getGCManager().MonsterDamageUse && lVictim.hasMetadata("JobsEntityDamagePlayer") && (perc = (damage = ((MetadataValue)lVictim.getMetadata("JobsEntityDamagePlayer").get(0)).asDouble()) * 100.0 / lVictim.getMaxHealth()) < Jobs.getGCManager().MonsterDamagePercentage) {
            return;
        }
        Jobs.action(jDamager, new EntityActionInfo((Entity)lVictim, ActionType.KILL), e.getDamager(), lVictim);
        if (lVictim instanceof Player && !lVictim.hasMetadata("NPC")) {
            JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer((Player)lVictim);
            if (jPlayer == null) {
                return;
            }
            List<JobProgression> jobs = jPlayer.getJobProgression();
            if (jobs == null) {
                return;
            }
            for (JobProgression job : jobs) {
                Jobs.action(jDamager, new CustomKillInfo(job.getJob().getName(), ActionType.CUSTOMKILL), e.getDamager(), lVictim);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            LivingEntity creature = event.getEntity();
            creature.setMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata(), (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(SlimeSplitEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!event.getEntity().hasMetadata(Jobs.getPlayerManager().getMobSpawnerMetadata())) {
            return;
        }
        EntityType type = event.getEntityType();
        if (type == EntityType.SLIME && Jobs.getGCManager().PreventSlimeSplit) {
            event.setCancelled(true);
            return;
        }
        if (type == EntityType.MAGMA_CUBE && Jobs.getGCManager().PreventMagmaCubeSplit) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureBreed(CreatureSpawnEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!Jobs.getGCManager().useBreederFinder) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (!reason.toString().equalsIgnoreCase("BREEDING")) {
            return;
        }
        LivingEntity animal = event.getEntity();
        if (!this.plugin.isEnabled()) {
            return;
        }
        double closest = 30.0;
        Player player = null;
        for (Player i : Bukkit.getOnlinePlayers()) {
            double dist;
            if (!i.getWorld().getName().equals(animal.getWorld().getName()) || !(closest > (dist = i.getLocation().distance(animal.getLocation())))) continue;
            closest = dist;
            player = i;
        }
        if (player != null && closest < 30.0) {
            if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
                return;
            }
            if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
                return;
            }
            JobsPlayer jDamager = Jobs.getPlayerManager().getJobsPlayer(player);
            if (jDamager == null) {
                return;
            }
            Jobs.action(jDamager, new EntityActionInfo((Entity)animal, ActionType.BREED));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerEat(FoodLevelChangeEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getEntity().hasMetadata("NPC")) {
            return;
        }
        if (event.getFoodLevel() <= ((Player)event.getEntity()).getFoodLevel()) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.isOnline()) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        ItemStack item = Jobs.getNms().getItemInMainHand(player);
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        Jobs.action(jPlayer, new ItemActionInfo(item, ActionType.EAT));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTntExplode(EntityExplodeEvent event) {
        if (event.getEntity() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!Jobs.getGCManager().isUseTntFinder()) {
            return;
        }
        if (event.getEntityType() != EntityType.PRIMED_TNT && event.getEntityType() != EntityType.MINECART_TNT) {
            return;
        }
        double closest = 60.0;
        Player player = null;
        Location loc = event.getEntity().getLocation();
        for (Player i : Bukkit.getOnlinePlayers()) {
            double dist;
            if (loc.getWorld() != i.getWorld() || !(closest > (dist = i.getLocation().distance(loc)))) continue;
            closest = dist;
            player = i;
        }
        if (player == null || closest == 60.0) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        for (Block block : event.blockList()) {
            if (block == null) continue;
            if (block.getType() == Material.FURNACE && block.hasMetadata("jobsFurnaceOwner")) {
                block.removeMetadata("jobsFurnaceOwner", (Plugin)this.plugin);
            }
            if (Jobs.getGCManager().useBlockProtection && block.getState().hasMetadata("BlockOwner")) {
                return;
            }
            BlockActionInfo bInfo = new BlockActionInfo(block, ActionType.TNTBREAK);
            Jobs.action(jPlayer, bInfo);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getPlayer() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (block.getType() == Material.FURNACE || block.getType() == Material.BURNING_FURNACE) {
            if (block.hasMetadata("jobsFurnaceOwner")) {
                block.removeMetadata("jobsFurnaceOwner", (Plugin)this.plugin);
            }
            block.setMetadata("jobsFurnaceOwner", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getPlayer().getName()));
        } else if (block.getType() == Material.BREWING_STAND) {
            if (block.hasMetadata("jobsBrewingOwner")) {
                block.removeMetadata("jobsBrewingOwner", (Plugin)this.plugin);
            }
            block.setMetadata("jobsBrewingOwner", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)event.getPlayer().getName()));
        }
    }

    @EventHandler
    public void onExplore(JobsChunkChangeEvent event) {
        if (event.getPlayer() != null && !Jobs.getGCManager().canPerformActionInWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (!Jobs.getExplore().isExploreEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (!Jobs.getGCManager().payExploringWhenFlying()) {
            return;
        }
        ExploreRespond respond = Jobs.getExplore().ChunkRespond(event.getPlayer(), event.getNewChunk(), true);
        if (!respond.isNewChunk()) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE) && !Jobs.getGCManager().payInCreative()) {
            return;
        }
        if (!Jobs.getPermissionHandler().hasWorldPermission(player, player.getLocation().getWorld().getName())) {
            return;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return;
        }
        Jobs.action(jPlayer, new ExploreActionInfo(String.valueOf(respond.getCount()), ActionType.EXPLORE));
    }
}

