/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.dao;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.PlayerInfo;
import com.gamingmesh.jobs.dao.JobsConnection;
import com.gamingmesh.jobs.dao.JobsDAO;
import com.gamingmesh.jobs.stuff.UUIDUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;

public class JobsDAOMySQL
extends JobsDAO {
    private String database;

    private JobsDAOMySQL(Jobs plugin, String hostname, String database, String username, String password, String prefix) {
        super(plugin, "com.mysql.jdbc.Driver", "jdbc:mysql://" + hostname + "/" + database, username, password, prefix);
        this.database = database;
    }

    public static JobsDAOMySQL initialize(Jobs plugin, String hostname, String database, String username, String password, String prefix) {
        JobsDAOMySQL dao = new JobsDAOMySQL(plugin, hostname, database, username, password, prefix);
        try {
            dao.setUp();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dao;
    }

    private static void close(ResultSet res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void close(PreparedStatement prest) {
        if (prest != null) {
            try {
                prest.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected synchronized void setupConfig() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        int rows = 0;
        ResultSet res = null;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?;");
            prest.setString(1, this.database);
            prest.setString(2, String.valueOf(this.getPrefix()) + "config");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOMySQL.close(res);
            JobsDAOMySQL.close(prest);
            throw throwable;
        }
        JobsDAOMySQL.close(res);
        JobsDAOMySQL.close(prest);
        if (rows == 0) {
            PreparedStatement insert = null;
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "config` (`key` varchar(50) NOT NULL PRIMARY KEY, `value` varchar(100) NOT NULL);");
                insert = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "config` (`key`, `value`) VALUES (?, ?);");
                insert.setString(1, "version");
                insert.setString(2, "1");
                insert.execute();
            }
            catch (Throwable throwable) {
                JobsDAOMySQL.close(insert);
                throw throwable;
            }
            JobsDAOMySQL.close(insert);
        }
    }

    @Override
    protected synchronized void checkUpdate() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        this.createDefaultJobsBase();
        this.createDefaultLogBase();
        this.createDefaultArchiveBase();
        this.createDefaultPointsBase();
        this.createDefaultExploreBase();
        this.createDefaultUsersBase();
        this.createDefaultBlockProtection();
        this.createDefaultLimitBase();
    }

    @Override
    protected synchronized void checkUpdate2() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM information_schema.columns WHERE table_schema = ? AND table_name = ? AND column_name = ?;");
            prest.setString(1, this.database);
            prest.setString(2, String.valueOf(this.getPrefix()) + "jobs");
            prest.setString(3, "username");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOMySQL.close(res);
            JobsDAOMySQL.close(prest);
            throw throwable;
        }
        JobsDAOMySQL.close(res);
        JobsDAOMySQL.close(prest);
        if (rows == 0) {
            this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs` ADD COLUMN `username` varchar(20);");
        }
    }

    @Override
    protected synchronized void checkUpdate4() throws SQLException {
        int rows;
        block10: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            rows = 0;
            try {
                try {
                    prest = conn.prepareStatement("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?;");
                    prest.setString(1, this.database);
                    prest.setString(2, String.valueOf(this.getPrefix()) + "archive");
                    res = prest.executeQuery();
                    if (res.next()) {
                        rows = res.getInt(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JobsDAOMySQL.close(res);
                    JobsDAOMySQL.close(prest);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                JobsDAOMySQL.close(res);
                JobsDAOMySQL.close(prest);
                throw throwable;
            }
            JobsDAOMySQL.close(res);
            JobsDAOMySQL.close(prest);
        }
        try {
            if (rows == 0) {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` binary(16) NOT NULL, `username` varchar(20), `job` varchar(20), `experience` int, `level` int);");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected synchronized void checkUpdate5() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        PreparedStatement prest = null;
        ResultSet res = null;
        int rows = 0;
        try {
            prest = conn.prepareStatement("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?;");
            prest.setString(1, this.database);
            prest.setString(2, String.valueOf(this.getPrefix()) + "log");
            res = prest.executeQuery();
            if (res.next()) {
                rows = res.getInt(1);
            }
        }
        catch (Throwable throwable) {
            JobsDAOMySQL.close(res);
            JobsDAOMySQL.close(prest);
            throw throwable;
        }
        JobsDAOMySQL.close(res);
        JobsDAOMySQL.close(prest);
        if (rows == 0) {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` binary(16) NOT NULL, `username` varchar(20), `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
        }
    }

    @Override
    protected synchronized void checkUpdate6() throws SQLException {
        JobsConnection conn = this.getConnection();
        if (conn == null) {
            Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
            return;
        }
        try {
            this.executeSQL("ALTER TABLE `" + this.getPrefix() + "log` MODIFY `itemname` VARCHAR(60);");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected synchronized void checkUpdate7() throws SQLException {
        boolean nodata;
        boolean convertLog;
        JobsConnection conn;
        block46: {
            boolean noArchivedata;
            boolean convertArchive;
            block44: {
                boolean noJobsdata;
                boolean convertJobs;
                block42: {
                    conn = this.getConnection();
                    if (conn == null) {
                        Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
                        return;
                    }
                    convertJobs = true;
                    PreparedStatement tempPst = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "jobs`;");
                    ResultSet tempRes = tempPst.executeQuery();
                    noJobsdata = true;
                    try {
                        try {
                            if (tempRes.next()) {
                                noJobsdata = false;
                                tempRes.getByte("player_uuid");
                            }
                        }
                        catch (Exception e) {
                            convertJobs = false;
                            tempRes.close();
                            tempPst.close();
                            break block42;
                        }
                    }
                    catch (Throwable throwable) {
                        tempRes.close();
                        tempPst.close();
                        throw throwable;
                    }
                    tempRes.close();
                    tempPst.close();
                }
                if (noJobsdata) {
                    this.dropDataBase("jobs");
                    this.createDefaultJobsBase();
                    convertJobs = false;
                }
                if (convertJobs) {
                    Jobs.getPluginLogger().info("Converting byte uuids to string.  This could take a long time!!!");
                    try {
                        this.executeSQL("CREATE TABLE `" + this.getPrefix() + "jobs_temp` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` varchar(36) NOT NULL,`username` varchar(20), `job` varchar(20), `experience` int, `level` int);");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    PreparedStatement pst1 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "jobs`;");
                    ResultSet rs = pst1.executeQuery();
                    Statement insert = null;
                    conn.setAutoCommit(false);
                    while (rs.next()) {
                        String uuid;
                        byte[] uuidBytes = rs.getBytes("player_uuid");
                        if (uuidBytes == null || (uuid = UUIDUtil.fromBytes(uuidBytes).toString()) == null) continue;
                        insert = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "jobs_temp` (`player_uuid`, `username`, `job`, `experience`, `level`) VALUES (?, ?, ?, ?, ?);");
                        insert.setString(1, uuid);
                        insert.setString(2, rs.getString("username"));
                        insert.setString(3, rs.getString("job"));
                        insert.setInt(4, rs.getInt("experience"));
                        insert.setInt(5, rs.getInt("level"));
                        insert.addBatch();
                    }
                    if (insert != null) {
                        insert.executeBatch();
                    }
                    conn.commit();
                    conn.setAutoCommit(true);
                    if (insert != null) {
                        insert.close();
                    }
                    rs.close();
                    pst1.close();
                    this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "jobs`;");
                    this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs_temp` RENAME TO `" + this.getPrefix() + "jobs`;");
                }
                convertArchive = true;
                PreparedStatement tempArchivePst = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "archive`;");
                ResultSet tempArchiveRes = tempArchivePst.executeQuery();
                noArchivedata = true;
                try {
                    try {
                        if (tempArchiveRes.next()) {
                            noArchivedata = false;
                            tempArchiveRes.getByte("player_uuid");
                        }
                    }
                    catch (Exception e) {
                        convertArchive = false;
                        tempArchiveRes.close();
                        tempArchivePst.close();
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    tempArchiveRes.close();
                    tempArchivePst.close();
                    throw throwable;
                }
                tempArchiveRes.close();
                tempArchivePst.close();
            }
            if (noArchivedata) {
                this.dropDataBase("archive");
                this.createDefaultArchiveBase();
                convertArchive = false;
            }
            if (convertArchive) {
                try {
                    this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive_temp` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` varchar(36) NOT NULL, `username` varchar(20), `job` varchar(20), `experience` int, `level` int);");
                }
                catch (Exception e) {
                    // empty catch block
                }
                PreparedStatement pst11 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "archive`;");
                ResultSet rs1 = pst11.executeQuery();
                Statement insert1 = null;
                conn.setAutoCommit(false);
                while (rs1.next()) {
                    String uuid = UUIDUtil.fromBytes(rs1.getBytes("player_uuid")).toString();
                    if (uuid == null) continue;
                    insert1 = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "archive_temp` (`player_uuid`, `username`, `job`, `experience`, `level`) VALUES (?, ?, ?, ?, ?);");
                    insert1.setString(1, uuid);
                    insert1.setString(2, rs1.getString("username"));
                    insert1.setString(3, rs1.getString("job"));
                    insert1.setInt(4, rs1.getInt("experience"));
                    insert1.setInt(5, rs1.getInt("level"));
                    insert1.addBatch();
                }
                if (insert1 != null) {
                    insert1.executeBatch();
                }
                conn.commit();
                conn.setAutoCommit(true);
                rs1.close();
                pst11.close();
                if (insert1 != null) {
                    insert1.close();
                }
                this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "archive`;");
                try {
                    this.executeSQL("ALTER TABLE `" + this.getPrefix() + "archive_temp` RENAME TO `" + this.getPrefix() + "archive`;");
                }
                catch (Exception uuid) {
                    // empty catch block
                }
            }
            convertLog = true;
            PreparedStatement tempLogPst = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "log`;");
            ResultSet tempLogRes = tempLogPst.executeQuery();
            nodata = true;
            try {
                try {
                    if (tempLogRes.next()) {
                        nodata = false;
                        tempLogRes.getByte("player_uuid");
                    }
                }
                catch (Exception e) {
                    convertLog = false;
                    tempLogRes.close();
                    tempLogPst.close();
                    break block46;
                }
            }
            catch (Throwable throwable) {
                tempLogRes.close();
                tempLogPst.close();
                throw throwable;
            }
            tempLogRes.close();
            tempLogPst.close();
        }
        if (nodata) {
            this.dropDataBase("log");
            this.createDefaultLogBase();
            convertLog = false;
        }
        if (convertLog) {
            Bukkit.getConsoleSender().sendMessage("Converting log database");
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log_temp` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` varchar(36) NOT NULL, `username` varchar(20), `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
            }
            catch (Exception e) {
                // empty catch block
            }
            PreparedStatement pst111 = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "log`;");
            ResultSet rs11 = pst111.executeQuery();
            Statement insert11 = null;
            conn.setAutoCommit(false);
            while (rs11.next()) {
                String uuid = UUIDUtil.fromBytes(rs11.getBytes("player_uuid")).toString();
                if (uuid == null) continue;
                insert11 = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "log_temp` (`player_uuid`, `username`, `time`, `action`, `itemname`, `count`, `money`, `exp`) VALUES (?, ?, ?, ?, ?, ?, ?, ?);");
                insert11.setString(1, uuid);
                insert11.setString(2, rs11.getString("username"));
                insert11.setLong(3, rs11.getLong("time"));
                insert11.setString(4, rs11.getString("action"));
                insert11.setString(5, rs11.getString("itemname"));
                insert11.setInt(6, rs11.getInt("count"));
                insert11.setDouble(7, rs11.getDouble("money"));
                insert11.setDouble(8, rs11.getDouble("exp"));
                insert11.addBatch();
            }
            if (insert11 != null) {
                insert11.executeBatch();
            }
            conn.commit();
            conn.setAutoCommit(true);
            pst111.close();
            rs11.close();
            if (insert11 != null) {
                insert11.close();
            }
            this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + "log`;");
            try {
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "log_temp` RENAME TO `" + this.getPrefix() + "log`;");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected synchronized void checkUpdate8() throws SQLException {
        int rows;
        block12: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            rows = 0;
            try {
                try {
                    prest = conn.prepareStatement("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?;");
                    prest.setString(1, this.database);
                    prest.setString(2, String.valueOf(this.getPrefix()) + "explore");
                    res = prest.executeQuery();
                    if (res.next()) {
                        rows = res.getInt(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JobsDAOMySQL.close(res);
                    JobsDAOMySQL.close(prest);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                JobsDAOMySQL.close(res);
                JobsDAOMySQL.close(prest);
                throw throwable;
            }
            JobsDAOMySQL.close(res);
            JobsDAOMySQL.close(prest);
        }
        try {
            if (rows == 0) {
                try {
                    this.executeSQL("CREATE TABLE `" + this.getPrefix() + "explore` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `worldname` varchar(64), `chunkX` int, `chunkZ` int, `playerName` varchar(32));");
                }
                catch (SQLException e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected synchronized void checkUpdate9() throws SQLException {
        boolean next;
        int rows;
        JobsConnection conn;
        block65: {
            block63: {
                conn = this.getConnection();
                if (conn == null) {
                    Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
                    return;
                }
                PreparedStatement tempPrest = null;
                ResultSet res = null;
                rows = 0;
                try {
                    try {
                        tempPrest = conn.prepareStatement("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = ? AND table_name = ?;");
                        tempPrest.setString(1, this.database);
                        tempPrest.setString(2, String.valueOf(this.getPrefix()) + "users");
                        res = tempPrest.executeQuery();
                        if (res.next()) {
                            rows = res.getInt(1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JobsDAOMySQL.close(res);
                        JobsDAOMySQL.close(tempPrest);
                        break block63;
                    }
                }
                catch (Throwable throwable) {
                    JobsDAOMySQL.close(res);
                    JobsDAOMySQL.close(tempPrest);
                    throw throwable;
                }
                JobsDAOMySQL.close(res);
                JobsDAOMySQL.close(tempPrest);
            }
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "points` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `totalpoints` double, `currentpoints` double);");
            }
            catch (SQLException e) {
                // empty catch block
            }
            PreparedStatement prestLogTemp = null;
            ResultSet rsLogTemp = null;
            next = false;
            try {
                try {
                    prestLogTemp = conn.prepareStatement("SELECT * FROM `" + this.getPrefix() + "log`;");
                    rsLogTemp = prestLogTemp.executeQuery();
                    if (rsLogTemp.next()) {
                        next = true;
                        rsLogTemp.getInt("userid");
                        rsLogTemp.getLong("time");
                        rsLogTemp.getString("action");
                        rsLogTemp.getString("itemname");
                        rsLogTemp.getInt("count");
                        rsLogTemp.getDouble("money");
                        rsLogTemp.getDouble("exp");
                    }
                }
                catch (Exception exception) {
                    JobsDAOMySQL.close(rsLogTemp);
                    JobsDAOMySQL.close(prestLogTemp);
                    break block65;
                }
            }
            catch (Throwable throwable) {
                JobsDAOMySQL.close(rsLogTemp);
                JobsDAOMySQL.close(prestLogTemp);
                throw throwable;
            }
            JobsDAOMySQL.close(rsLogTemp);
            JobsDAOMySQL.close(prestLogTemp);
        }
        if (!next) {
            this.dropDataBase("log");
            try {
                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `username` varchar(20), `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rows == 0) {
            block79: {
                HashMap<String, PlayerInfo> tempPlayerMap;
                block77: {
                    block75: {
                        block73: {
                            HashMap<String, String> tempMap;
                            block71: {
                                block69: {
                                    block67: {
                                        tempMap = new HashMap<String, String>();
                                        PreparedStatement prestJobs = null;
                                        ResultSet res1 = null;
                                        try {
                                            try {
                                                prestJobs = conn.prepareStatement("SELECT DISTINCT(player_uuid),username FROM " + this.getPrefix() + "jobs;");
                                                res1 = prestJobs.executeQuery();
                                                while (res1.next()) {
                                                    tempMap.put(res1.getString("player_uuid"), res1.getString("username"));
                                                }
                                            }
                                            catch (Exception exception) {
                                                JobsDAOMySQL.close(res1);
                                                JobsDAOMySQL.close(prestJobs);
                                                break block67;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            JobsDAOMySQL.close(res1);
                                            JobsDAOMySQL.close(prestJobs);
                                            throw throwable;
                                        }
                                        JobsDAOMySQL.close(res1);
                                        JobsDAOMySQL.close(prestJobs);
                                    }
                                    PreparedStatement prestArchive = null;
                                    ResultSet res2 = null;
                                    try {
                                        try {
                                            prestArchive = conn.prepareStatement("SELECT DISTINCT(player_uuid),username FROM " + this.getPrefix() + "archive;");
                                            res2 = prestArchive.executeQuery();
                                            while (res2.next()) {
                                                tempMap.put(res2.getString("player_uuid"), res2.getString("username"));
                                            }
                                        }
                                        catch (Exception exception) {
                                            JobsDAOMySQL.close(res2);
                                            JobsDAOMySQL.close(prestArchive);
                                            break block69;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        JobsDAOMySQL.close(res2);
                                        JobsDAOMySQL.close(prestArchive);
                                        throw throwable;
                                    }
                                    JobsDAOMySQL.close(res2);
                                    JobsDAOMySQL.close(prestArchive);
                                }
                                PreparedStatement prestLog = null;
                                ResultSet res3 = null;
                                try {
                                    try {
                                        prestLog = conn.prepareStatement("SELECT DISTINCT(player_uuid),username FROM " + this.getPrefix() + "log;");
                                        res3 = prestLog.executeQuery();
                                        while (res3.next()) {
                                            tempMap.put(res3.getString("player_uuid"), res3.getString("username"));
                                        }
                                    }
                                    catch (Exception exception) {
                                        JobsDAOMySQL.close(res3);
                                        JobsDAOMySQL.close(prestLog);
                                        break block71;
                                    }
                                }
                                catch (Throwable throwable) {
                                    JobsDAOMySQL.close(res3);
                                    JobsDAOMySQL.close(prestLog);
                                    throw throwable;
                                }
                                JobsDAOMySQL.close(res3);
                                JobsDAOMySQL.close(prestLog);
                            }
                            try {
                                this.executeSQL("CREATE TABLE `" + this.getPrefix() + "users` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` varchar(36) NOT NULL, `username` varchar(20));");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            PreparedStatement prestUsers = null;
                            try {
                                try {
                                    prestUsers = conn.prepareStatement("INSERT INTO `" + this.getPrefix() + "users` (`player_uuid`, `username`) VALUES (?, ?);");
                                    conn.setAutoCommit(false);
                                    for (Map.Entry users : tempMap.entrySet()) {
                                        prestUsers.setString(1, (String)users.getKey());
                                        prestUsers.setString(2, (String)users.getValue());
                                        prestUsers.addBatch();
                                    }
                                    prestUsers.executeBatch();
                                    conn.commit();
                                    conn.setAutoCommit(true);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    JobsDAOMySQL.close(prestUsers);
                                    break block73;
                                }
                            }
                            catch (Throwable throwable) {
                                JobsDAOMySQL.close(prestUsers);
                                throw throwable;
                            }
                            JobsDAOMySQL.close(prestUsers);
                        }
                        tempPlayerMap = new HashMap<String, PlayerInfo>();
                        PreparedStatement prestUsersT = null;
                        ResultSet res4 = null;
                        try {
                            try {
                                prestUsersT = conn.prepareStatement("SELECT * FROM " + this.getPrefix() + "users;");
                                res4 = prestUsersT.executeQuery();
                                while (res4.next()) {
                                    tempPlayerMap.put(res4.getString("player_uuid"), new PlayerInfo(res4.getString("username"), res4.getInt("id"), UUID.fromString(res4.getString("player_uuid")), System.currentTimeMillis()));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JobsDAOMySQL.close(res4);
                                JobsDAOMySQL.close(prestUsersT);
                                break block75;
                            }
                        }
                        catch (Throwable throwable) {
                            JobsDAOMySQL.close(res4);
                            JobsDAOMySQL.close(prestUsersT);
                            throw throwable;
                        }
                        JobsDAOMySQL.close(res4);
                        JobsDAOMySQL.close(prestUsersT);
                    }
                    try {
                        this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs` ADD COLUMN `userid` int;");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    PreparedStatement prestJobsT = null;
                    try {
                        try {
                            prestJobsT = conn.prepareStatement("UPDATE `" + this.getPrefix() + "jobs` SET `userid` = ? WHERE `player_uuid` = ?;");
                            conn.setAutoCommit(false);
                            for (Map.Entry users : tempPlayerMap.entrySet()) {
                                prestJobsT.setInt(1, ((PlayerInfo)users.getValue()).getID());
                                prestJobsT.setString(2, (String)users.getKey());
                                prestJobsT.addBatch();
                            }
                            prestJobsT.executeBatch();
                            conn.commit();
                            conn.setAutoCommit(true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JobsDAOMySQL.close(prestJobsT);
                            break block77;
                        }
                    }
                    catch (Throwable throwable) {
                        JobsDAOMySQL.close(prestJobsT);
                        throw throwable;
                    }
                    JobsDAOMySQL.close(prestJobsT);
                }
                try {
                    this.executeSQL("ALTER TABLE `" + this.getPrefix() + "jobs` DROP COLUMN `player_uuid`, DROP COLUMN `username`;");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.executeSQL("ALTER TABLE `" + this.getPrefix() + "archive` ADD COLUMN `userid` int;");
                }
                catch (Exception e) {
                    // empty catch block
                }
                PreparedStatement prestArchiveT = null;
                try {
                    try {
                        prestArchiveT = conn.prepareStatement("UPDATE `" + this.getPrefix() + "archive` SET `userid` = ? WHERE `player_uuid` = ?;");
                        conn.setAutoCommit(false);
                        for (Map.Entry users : tempPlayerMap.entrySet()) {
                            prestArchiveT.setInt(1, ((PlayerInfo)users.getValue()).getID());
                            prestArchiveT.setString(2, (String)users.getKey());
                            prestArchiveT.addBatch();
                        }
                        prestArchiveT.executeBatch();
                        conn.commit();
                        conn.setAutoCommit(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JobsDAOMySQL.close(prestArchiveT);
                        break block79;
                    }
                }
                catch (Throwable throwable) {
                    JobsDAOMySQL.close(prestArchiveT);
                    throw throwable;
                }
                JobsDAOMySQL.close(prestArchiveT);
            }
            try {
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "archive` DROP COLUMN `player_uuid`, DROP COLUMN `username`;");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected synchronized void checkUpdate10() {
        this.createDefaultBlockProtection();
    }

    @Override
    protected synchronized void checkUpdate11() {
        block8: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                Jobs.getPluginLogger().severe("Could not run database updates!  Could not connect to MySQL!");
                return;
            }
            try {
                this.executeSQL("ALTER TABLE `" + this.getPrefix() + "users` ADD COLUMN `seen` bigint;");
            }
            catch (Exception e) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("UPDATE `" + this.getPrefix() + "users` SET `seen` = ?;");
                    prest.setLong(1, System.currentTimeMillis());
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAOMySQL.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAOMySQL.close(prest);
                throw throwable;
            }
            JobsDAOMySQL.close(prest);
        }
    }

    private boolean createDefaultExploreBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "explore` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `worldname` varchar(64), `chunkX` int, `chunkZ` int, `playerName` varchar(32));");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultPointsBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "points` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `totalpoints` double, `currentpoints` double);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean createDefaultLogBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "log` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `time` bigint, `action` varchar(20), `itemname` varchar(60), `count` int, `money` double, `exp` double);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean createDefaultArchiveBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "archive` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `job` varchar(20), `experience` int, `level` int);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultJobsBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "jobs` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `job` varchar(20), `experience` int, `level` int);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultUsersBase() {
        try {
            this.executeSQL("CREATE TABLE `" + this.getPrefix() + "users` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `player_uuid` varchar(36) NOT NULL, `username` varchar(20), `seen` bigint);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultBlockProtection() {
        try {
            this.executeSQL("CREATE TABLE IF NOT EXISTS `" + this.getPrefix() + "blocks` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `world` varchar(36) NOT NULL, `x` int, `y` int, `z` int, `recorded` bigint, `resets` bigint);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private boolean createDefaultLimitBase() {
        try {
            this.executeSQL("CREATE TABLE IF NOT EXISTS `" + this.getPrefix() + "limits` (`id` int NOT NULL AUTO_INCREMENT PRIMARY KEY, `userid` int, `type` varchar(36), `collected` double, `started` bigint);");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean dropDataBase(String name) {
        try {
            this.executeSQL("DROP TABLE IF EXISTS `" + this.getPrefix() + name + "`;");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }
}

