/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.dao;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.BlockProtection;
import com.gamingmesh.jobs.container.Convert;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.DBAction;
import com.gamingmesh.jobs.container.ExploreChunk;
import com.gamingmesh.jobs.container.ExploreRegion;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.container.Log;
import com.gamingmesh.jobs.container.LogAmounts;
import com.gamingmesh.jobs.container.PlayerInfo;
import com.gamingmesh.jobs.container.PlayerPoints;
import com.gamingmesh.jobs.container.TopList;
import com.gamingmesh.jobs.dao.JobsConnection;
import com.gamingmesh.jobs.dao.JobsConnectionPool;
import com.gamingmesh.jobs.dao.JobsDAOData;
import com.gamingmesh.jobs.economy.PaymentData;
import com.gamingmesh.jobs.stuff.TimeManage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class JobsDAO {
    private JobsConnectionPool pool;
    private String prefix;
    private HashMap<Integer, ArrayList<JobsDAOData>> map = new HashMap();
    private Jobs plugin;

    protected JobsDAO(Jobs plugin, String driverName, String url, String username, String password, String prefix) {
        this.plugin = plugin;
        this.prefix = prefix;
        try {
            this.pool = new JobsConnectionPool(driverName, url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final synchronized void setUp() throws SQLException {
        this.setupConfig();
        int version = this.getSchemaVersion();
        if (version == 0) {
            Jobs.getPluginLogger().severe("Could not initialize database!  Could not determine schema version!");
            return;
        }
        this.checkUpdate();
        if (version > 1) {
            if (version <= 2) {
                this.checkUpdate2();
            }
            this.checkUpdate4();
            this.checkUpdate5();
            if (version <= 6) {
                this.checkUpdate6();
            }
            if (version <= 7) {
                this.checkUpdate7();
            }
            this.checkUpdate8();
            this.checkUpdate9();
            this.checkUpdate10();
            this.checkUpdate11();
        }
        version = 11;
        this.updateSchemaVersion(version);
        this.loadAllSavedJobs();
    }

    protected abstract void setupConfig() throws SQLException;

    protected abstract void checkUpdate() throws SQLException;

    protected abstract void checkUpdate2() throws SQLException;

    protected abstract void checkUpdate4() throws SQLException;

    protected abstract void checkUpdate5() throws SQLException;

    protected abstract void checkUpdate6() throws SQLException;

    protected abstract void checkUpdate7() throws SQLException;

    protected abstract void checkUpdate8() throws SQLException;

    protected abstract void checkUpdate9() throws SQLException;

    protected abstract void checkUpdate10() throws SQLException;

    protected abstract void checkUpdate11() throws SQLException;

    protected abstract boolean createDefaultLogBase();

    protected abstract boolean createDefaultArchiveBase();

    protected abstract boolean dropDataBase(String var1);

    protected String getPrefix() {
        return this.prefix;
    }

    public List<JobsDAOData> getAllJobs(OfflinePlayer player) {
        return this.getAllJobs(player.getName(), player.getUniqueId());
    }

    public List<JobsDAOData> getAllJobs(String playerName, UUID uuid) {
        ArrayList<JobsDAOData> jobs;
        block8: {
            int id = -1;
            PlayerInfo userData = null;
            userData = Jobs.getGCManager().MultiServerCompatability() ? this.loadPlayerData(uuid) : Jobs.getPlayerManager().getPlayerInfo(uuid);
            jobs = new ArrayList<JobsDAOData>();
            if (userData == null) {
                this.recordNewPlayer(playerName, uuid);
                return jobs;
            }
            id = userData.getID();
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return jobs;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `job`, `level`, `experience` FROM `" + this.prefix + "jobs` WHERE `userid` = ?;");
                    prest.setInt(1, id);
                    res = prest.executeQuery();
                    while (res.next()) {
                        jobs.add(new JobsDAOData(res.getString(1), res.getInt(2), res.getInt(3)));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return jobs;
    }

    public List<JobsDAOData> getAllJobs(PlayerInfo pInfo) {
        List list = this.map.get(pInfo.getID());
        if (list != null) {
            return list;
        }
        return new ArrayList<JobsDAOData>();
    }

    public void cleanUsers() {
        block7: {
            if (!Jobs.getGCManager().DBCleaningUsersUse) {
                return;
            }
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            long mark = System.currentTimeMillis() - (long)(Jobs.getGCManager().DBCleaningUsersDays * 24 * 60 * 60 * 1000);
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("DELETE FROM `" + this.prefix + "users` WHERE `seen` < ?;");
                    prest.setLong(1, mark);
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public void cleanJobs() {
        block7: {
            if (!Jobs.getGCManager().DBCleaningJobsUse) {
                return;
            }
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("DELETE FROM `" + this.prefix + "jobs` WHERE `level` <= ?;");
                    prest.setInt(1, Jobs.getGCManager().DBCleaningJobsLvl);
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    private void loadAllSavedJobs() {
        block8: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT * FROM `" + this.prefix + "jobs`;");
                    res = prest.executeQuery();
                    while (res.next()) {
                        int id = res.getInt("userid");
                        ArrayList<JobsDAOData> list = this.map.get(id);
                        if (list == null) {
                            list = new ArrayList();
                            list.add(new JobsDAOData(res.getString("job"), res.getInt("level"), res.getInt("experience")));
                            this.map.put(id, list);
                            continue;
                        }
                        list.add(new JobsDAOData(res.getString("job"), res.getInt("level"), res.getInt("experience")));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public void recordNewPlayer(Player player) {
        this.recordNewPlayer((OfflinePlayer)player);
    }

    public void recordNewPlayer(OfflinePlayer player) {
        this.recordNewPlayer(player.getName(), player.getUniqueId());
    }

    public void recordNewPlayer(String playerName, UUID uuid) {
        block12: {
            JobsConnection conn;
            block10: {
                conn = this.getConnection();
                if (conn == null) {
                    return;
                }
                PreparedStatement prestt = null;
                try {
                    try {
                        prestt = conn.prepareStatement("INSERT INTO `" + this.prefix + "users` (`player_uuid`, `username`, `seen`) VALUES (?, ?, ?);");
                        prestt.setString(1, uuid.toString());
                        prestt.setString(2, playerName);
                        prestt.setLong(3, System.currentTimeMillis());
                        prestt.executeUpdate();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        JobsDAO.close(prestt);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    JobsDAO.close(prestt);
                    throw throwable;
                }
                JobsDAO.close(prestt);
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `id` FROM `" + this.prefix + "users` WHERE `player_uuid` = ?;");
                    prest.setString(1, uuid.toString());
                    res = prest.executeQuery();
                    res.next();
                    int id = res.getInt("id");
                    Jobs.getPlayerManager().addPlayerToMap(new PlayerInfo(playerName, id, uuid, System.currentTimeMillis()));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public synchronized int getTotalPlayerAmountByJobName(String JobName) {
        int count;
        block7: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return 0;
            }
            count = 0;
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT COUNT(*) FROM `" + this.prefix + "jobs` WHERE `job` = ?;");
                    prest.setString(1, JobName);
                    res = prest.executeQuery();
                    while (res.next()) {
                        count = res.getInt(1);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return count;
    }

    public synchronized int getTotalPlayers() {
        int total = 0;
        for (Job one : Jobs.getJobs()) {
            total += one.getTotalPlayers();
        }
        return total;
    }

    public synchronized List<JobsDAOData> getAllJobsOffline(String userName) {
        ArrayList<JobsDAOData> jobs;
        block8: {
            jobs = new ArrayList<JobsDAOData>();
            PlayerInfo info2 = Jobs.getPlayerManager().getPlayerInfo(userName);
            if (info2 == null) {
                return jobs;
            }
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return jobs;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `job`, `level`, `experience` FROM `" + this.prefix + "jobs` WHERE `userid` = ?;");
                    prest.setInt(1, info2.getID());
                    res = prest.executeQuery();
                    while (res.next()) {
                        jobs.add(new JobsDAOData(res.getString(2), res.getInt(3), res.getInt(4)));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return jobs;
    }

    public synchronized void recordPlayersLimits(JobsPlayer jPlayer) {
        block14: {
            JobsConnection conn;
            block12: {
                conn = this.getConnection();
                if (conn == null) {
                    return;
                }
                PreparedStatement prest2 = null;
                try {
                    try {
                        prest2 = conn.prepareStatement("DELETE FROM `" + this.prefix + "limits` WHERE `userid` = ?;");
                        prest2.setInt(1, jPlayer.getUserId());
                        prest2.execute();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        JobsDAO.close(prest2);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    JobsDAO.close(prest2);
                    throw throwable;
                }
                JobsDAO.close(prest2);
            }
            PreparedStatement prest = null;
            try {
                try {
                    PaymentData limit2 = jPlayer.getPaymentLimit();
                    prest = conn.prepareStatement("INSERT INTO `" + this.prefix + "limits` (`userid`, `type`, `collected`, `started`) VALUES (?, ?, ?, ?);");
                    conn.setAutoCommit(false);
                    CurrencyType[] currencyTypeArray = CurrencyType.values();
                    int n = currencyTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CurrencyType type = currencyTypeArray[n2];
                        if (limit2 != null && limit2.GetAmount(type) != 0.0 && limit2.GetLeftTime(type) >= 0L) {
                            prest.setInt(1, jPlayer.getUserId());
                            prest.setString(2, type.getName());
                            prest.setDouble(3, limit2.GetAmount(type));
                            prest.setLong(4, limit2.GetTime(type));
                            prest.addBatch();
                        }
                        ++n2;
                    }
                    prest.executeBatch();
                    conn.commit();
                    conn.setAutoCommit(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public synchronized PaymentData getPlayersLimits(JobsPlayer jPlayer) {
        PaymentData data;
        block7: {
            data = new PaymentData();
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return data;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `type`, `collected`, `started` FROM `" + this.prefix + "limits` WHERE `userid` = ?;");
                    prest.setInt(1, jPlayer.getUserId());
                    res = prest.executeQuery();
                    while (res.next()) {
                        CurrencyType type = CurrencyType.getByName(res.getString("type"));
                        if (type == null) continue;
                        data.AddNewAmount(type, res.getDouble("collected"), res.getLong("started"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return data;
    }

    public synchronized void joinJob(JobsPlayer jPlayer, Job job) {
        block7: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    int level = 1;
                    int exp = 0;
                    if (this.checkArchive(jPlayer, job).size() > 0) {
                        List<Integer> info2 = this.checkArchive(jPlayer, job);
                        level = info2.get(0);
                        this.deleteArchive(jPlayer, job);
                    }
                    prest = conn.prepareStatement("INSERT INTO `" + this.prefix + "jobs` (`userid`, `job`, `level`, `experience`) VALUES (?, ?, ?, ?);");
                    prest.setInt(1, jPlayer.getUserId());
                    prest.setString(2, job.getName());
                    prest.setInt(3, level);
                    prest.setInt(4, exp);
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public List<Convert> convertDatabase(String table) throws SQLException {
        ArrayList<Convert> list;
        JobsConnection conn;
        block9: {
            conn = this.getConnection();
            if (conn == null) {
                return null;
            }
            list = new ArrayList<Convert>();
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT * FROM `" + this.prefix + table + "`");
                    res = prest.executeQuery();
                    while (res.next()) {
                        list.add(new Convert(res.getInt("id"), res.getInt("userid"), res.getString("job"), res.getInt("level"), res.getInt("experience")));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        try {
            conn.closeConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void continueConvertions(List<Convert> list, String table) throws SQLException {
        JobsConnection conns = this.getConnection();
        if (conns == null) {
            return;
        }
        PreparedStatement insert = null;
        Statement statement = null;
        int i = list.size();
        try {
            statement = conns.createStatement();
            if (Jobs.getGCManager().storageMethod.equalsIgnoreCase("sqlite")) {
                statement.executeUpdate("TRUNCATE `" + this.getPrefix() + table + "`");
            } else {
                statement.executeUpdate("DELETE from `" + this.getPrefix() + table + "`");
            }
            insert = conns.prepareStatement("INSERT INTO `" + this.getPrefix() + table + "` (`userid`, `job`, `level`, `experience`) VALUES (?, ?, ?, ?);");
            conns.setAutoCommit(false);
            while (i > 0) {
                Convert convertData = list.get(--i);
                insert.setInt(1, convertData.GetId());
                insert.setString(2, convertData.GetJobName());
                insert.setInt(3, convertData.GetLevel());
                insert.setInt(4, convertData.GetExp());
                insert.addBatch();
            }
            insert.executeBatch();
            conns.commit();
            conns.setAutoCommit(true);
        }
        catch (Throwable throwable) {
            JobsDAO.close(statement);
            JobsDAO.close(insert);
            throw throwable;
        }
        JobsDAO.close(statement);
        JobsDAO.close(insert);
    }

    public void transferUsers() throws SQLException {
        JobsConnection conns = this.getConnection();
        if (conns == null) {
            return;
        }
        PreparedStatement insert = null;
        Statement statement = null;
        try {
            statement = conns.createStatement();
            if (Jobs.getGCManager().storageMethod.equalsIgnoreCase("sqlite")) {
                statement.executeUpdate("TRUNCATE `" + this.getPrefix() + "users`");
            } else {
                statement.executeUpdate("DELETE from `" + this.getPrefix() + "users`");
            }
            insert = conns.prepareStatement("INSERT INTO `" + this.getPrefix() + "users` (`id`, `player_uuid`, `username`, `seen`) VALUES (?, ?, ?, ?);");
            conns.setAutoCommit(false);
            for (Map.Entry<UUID, JobsPlayer> oneUser : Jobs.getPlayerManager().getPlayersCache().entrySet()) {
                insert.setInt(1, oneUser.getValue().getUserId());
                insert.setString(2, oneUser.getValue().getPlayerUUID().toString());
                insert.setString(3, oneUser.getValue().getUserName());
                insert.setLong(4, oneUser.getValue().getSeen() == null ? System.currentTimeMillis() : oneUser.getValue().getSeen());
                insert.addBatch();
            }
            insert.executeBatch();
            conns.commit();
            conns.setAutoCommit(true);
        }
        catch (Throwable throwable) {
            JobsDAO.close(statement);
            JobsDAO.close(insert);
            throw throwable;
        }
        JobsDAO.close(statement);
        JobsDAO.close(insert);
    }

    public synchronized boolean quitJob(JobsPlayer jPlayer, Job job) {
        boolean ok;
        block6: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return false;
            }
            PreparedStatement prest = null;
            ok = true;
            try {
                try {
                    prest = conn.prepareStatement("DELETE FROM `" + this.prefix + "jobs` WHERE `userid` = ? AND `job` = ?;");
                    prest.setInt(1, jPlayer.getUserId());
                    prest.setString(2, job.getName());
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    ok = false;
                    JobsDAO.close(prest);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
        return ok;
    }

    public void recordToArchive(JobsPlayer jPlayer, Job job) {
        block7: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    int level = 1;
                    int exp = 0;
                    for (JobProgression progression : jPlayer.getJobProgression()) {
                        if (!progression.getJob().getName().equalsIgnoreCase(job.getName())) continue;
                        level = progression.getLevel();
                        exp = (int)progression.getExperience();
                    }
                    prest = conn.prepareStatement("INSERT INTO `" + this.prefix + "archive` (`userid`, `job`, `level`, `experience`) VALUES (?, ?, ?, ?);");
                    prest.setInt(1, jPlayer.getUserId());
                    prest.setString(2, job.getName());
                    prest.setInt(3, level);
                    prest.setInt(4, exp);
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public synchronized List<Integer> checkArchive(JobsPlayer jPlayer, Job job) {
        ArrayList<Integer> info2;
        block9: {
            JobsConnection conn = this.getConnection();
            info2 = new ArrayList<Integer>();
            if (conn == null) {
                return info2;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `level`, `experience` FROM `" + this.prefix + "archive` WHERE `userid` = ? AND `job` = ?;");
                    prest.setInt(1, jPlayer.getUserId());
                    prest.setString(2, job.getName());
                    res = prest.executeQuery();
                    if (res.next()) {
                        int level = (int)((double)res.getInt(1) - (double)res.getInt(1) * ((double)Jobs.getGCManager().levelLossPercentage.intValue() / 100.0));
                        if (level < 1) {
                            level = 1;
                        }
                        int maxLevel = 0;
                        maxLevel = jPlayer.havePermission("jobs." + job.getName() + ".vipmaxlevel") && job.getVipMaxLevel() != 0 ? job.getVipMaxLevel() : job.getMaxLevel();
                        if (Jobs.getGCManager().fixAtMaxLevel && res.getInt(1) == maxLevel) {
                            level = res.getInt(1);
                        }
                        info2.add(level);
                        info2.add(res.getInt(2));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return info2;
    }

    public List<TopList> getGlobalTopList() {
        return this.getGlobalTopList(0);
    }

    public List<TopList> getGlobalTopList(int start) {
        ArrayList<TopList> names;
        block7: {
            JobsConnection conn = this.getConnection();
            names = new ArrayList<TopList>();
            if (conn == null) {
                return names;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT userid, COUNT(*) AS amount,  sum(level) AS totallvl FROM `" + this.prefix + "jobs` GROUP BY userid ORDER BY totallvl DESC LIMIT " + start + ",20;");
                    res = prest.executeQuery();
                    while (res.next()) {
                        PlayerInfo info2 = Jobs.getPlayerManager().getPlayerInfo(res.getInt("userid"));
                        if (info2 == null || info2.getName() == null) continue;
                        TopList top2 = new TopList(info2, res.getInt("totallvl"), 0);
                        names.add(top2);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return names;
    }

    public synchronized List<String> getJobsFromArchive(JobsPlayer jPlayer) {
        ArrayList<String> info2;
        block9: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return null;
            }
            info2 = new ArrayList<String>();
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `job`, `level`, `experience`  FROM `" + this.prefix + "archive` WHERE `userid` = ?;");
                    prest.setInt(1, jPlayer.getUserId());
                    res = prest.executeQuery();
                    while (res.next()) {
                        int level = (int)((double)res.getInt(2) - (double)res.getInt(2) * ((double)Jobs.getGCManager().levelLossPercentage.intValue() / 100.0));
                        if (level < 1) {
                            level = 1;
                        }
                        int maxLevel = 0;
                        Job job = Jobs.getJob(res.getString(1));
                        if (job == null) continue;
                        maxLevel = jPlayer.havePermission("jobs." + job.getName() + ".vipmaxlevel") ? job.getVipMaxLevel() : job.getMaxLevel();
                        if (Jobs.getGCManager().fixAtMaxLevel && res.getInt(2) == maxLevel) {
                            level = res.getInt(2);
                        }
                        info2.add(String.valueOf(res.getString(1)) + ":" + res.getInt(2) + ":" + level + ":" + res.getInt(3));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return info2;
    }

    public PlayerInfo loadPlayerData(UUID uuid) {
        PlayerInfo pInfo;
        block7: {
            pInfo = null;
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return pInfo;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT * FROM `" + this.prefix + "users` WHERE `player_uuid` = ?;");
                    prest.setString(1, uuid.toString());
                    res = prest.executeQuery();
                    while (res.next()) {
                        pInfo = new PlayerInfo(res.getString("username"), res.getInt("id"), uuid, res.getLong("seen"));
                        Jobs.getPlayerManager().addPlayerToMap(pInfo);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return pInfo;
    }

    public void loadPlayerData() {
        block9: {
            Jobs.getPlayerManager().clearMaps();
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT *  FROM `" + this.prefix + "users`;");
                    res = prest.executeQuery();
                    while (res.next()) {
                        long seen = System.currentTimeMillis();
                        try {
                            seen = res.getLong("seen");
                            Jobs.getPlayerManager().addPlayerToMap(new PlayerInfo(res.getString("username"), res.getInt("id"), UUID.fromString(res.getString("player_uuid")), seen));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public JobsPlayer loadFromDao(OfflinePlayer player) {
        JobsPlayer jPlayer = new JobsPlayer(player.getName(), player);
        jPlayer.playerUUID = player.getUniqueId();
        List<JobsDAOData> list = this.getAllJobs(player);
        jPlayer.progression.clear();
        for (JobsDAOData jobdata : list) {
            if (!this.plugin.isEnabled()) {
                return null;
            }
            Job job = Jobs.getJob(jobdata.getJobName());
            if (job == null) continue;
            JobProgression jobProgression = new JobProgression(job, jPlayer, jobdata.getLevel(), jobdata.getExperience());
            jPlayer.progression.add(jobProgression);
        }
        jPlayer.reloadMaxExperience();
        jPlayer.reloadLimits();
        jPlayer.setUserId(Jobs.getPlayerManager().getPlayerId(player.getUniqueId()));
        Jobs.getJobsDAO().loadPoints(jPlayer);
        return jPlayer;
    }

    public void loadAllData() {
        block9: {
            Jobs.getPlayerManager().clearMaps();
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT *  FROM `" + this.prefix + "users`;");
                    res = prest.executeQuery();
                    while (res.next()) {
                        try {
                            Jobs.getPlayerManager().addPlayerToMap(new PlayerInfo(res.getString("username"), res.getInt("id"), UUID.fromString(res.getString("player_uuid")), res.getLong("seen")));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public synchronized void deleteArchive(JobsPlayer jPlayer, Job job) {
        block6: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("DELETE FROM `" + this.prefix + "archive` WHERE `userid` = ? AND `job` = ?;");
                    prest.setInt(1, jPlayer.getUserId());
                    prest.setString(2, job.getName());
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public void save(JobsPlayer player) {
        block7: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("UPDATE `" + this.prefix + "jobs` SET `level` = ?, `experience` = ? WHERE `userid` = ? AND `job` = ?;");
                    for (JobProgression progression : player.getJobProgression()) {
                        prest.setInt(1, progression.getLevel());
                        prest.setInt(2, (int)progression.getExperience());
                        prest.setInt(3, player.getUserId());
                        prest.setString(4, progression.getJob().getName());
                        prest.execute();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public void updateSeen(JobsPlayer player) {
        block6: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("UPDATE `" + this.prefix + "users` SET `seen` = ?, `username` = ? WHERE `id` = ?;");
                    prest.setLong(1, System.currentTimeMillis());
                    prest.setString(2, player.getUserName());
                    prest.setInt(3, player.getUserId());
                    prest.execute();
                }
                catch (SQLException sQLException) {
                    JobsDAO.close(prest);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public void savePoints(JobsPlayer jPlayer) {
        block12: {
            JobsConnection conn;
            block10: {
                conn = this.getConnection();
                if (conn == null) {
                    return;
                }
                PreparedStatement prest2 = null;
                try {
                    try {
                        prest2 = conn.prepareStatement("DELETE FROM `" + this.prefix + "points` WHERE `userid` = ?;");
                        prest2.setInt(1, jPlayer.getUserId());
                        prest2.execute();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        JobsDAO.close(prest2);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    JobsDAO.close(prest2);
                    throw throwable;
                }
                JobsDAO.close(prest2);
            }
            PreparedStatement prest = null;
            try {
                try {
                    PlayerPoints pointInfo = Jobs.getPlayerManager().getPointsData().getPlayerPointsInfo(jPlayer.getPlayerUUID());
                    prest = conn.prepareStatement("INSERT INTO `" + this.prefix + "points` (`totalpoints`, `currentpoints`, `userid`) VALUES (?, ?, ?);");
                    prest.setDouble(1, pointInfo.getTotalPoints());
                    prest.setDouble(2, pointInfo.getCurrentPoints());
                    prest.setInt(3, jPlayer.getUserId());
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public void loadPoints(JobsPlayer player) {
        block8: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `totalpoints`, `currentpoints` FROM `" + this.prefix + "points` WHERE `userid` = ?;");
                    prest.setInt(1, player.getUserId());
                    res = prest.executeQuery();
                    if (res.next()) {
                        Jobs.getPlayerManager().getPointsData().addPlayer(player.getPlayerUUID(), res.getDouble("currentpoints"), res.getDouble("totalpoints"));
                    } else {
                        Jobs.getPlayerManager().getPointsData().addPlayer(player.getPlayerUUID());
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public void saveLog(JobsPlayer player) {
        block10: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest1 = null;
            PreparedStatement prest2 = null;
            try {
                try {
                    prest1 = conn.prepareStatement("UPDATE `" + this.prefix + "log` SET `count` = ?, `money` = ?, `exp` = ? WHERE `userid` = ? AND `time` = ? AND `action` = ? AND `itemname` = ?;");
                    for (Log log2 : player.getLog()) {
                        for (Map.Entry<String, LogAmounts> one : log2.getAmountList().entrySet()) {
                            if (one.getValue().isNewEntry()) continue;
                            prest1.setInt(1, one.getValue().getCount());
                            prest1.setDouble(2, one.getValue().getMoney());
                            prest1.setDouble(3, one.getValue().getExp());
                            prest1.setInt(4, player.getUserId());
                            prest1.setInt(5, log2.getDate());
                            prest1.setString(6, log2.getActionType());
                            prest1.setString(7, one.getKey());
                            prest1.execute();
                        }
                    }
                    prest2 = conn.prepareStatement("INSERT INTO `" + this.prefix + "log` (`userid`, `time`, `action`, `itemname`, `count`, `money`, `exp`) VALUES (?, ?, ?, ?, ?, ?, ?);");
                    for (Log log2 : player.getLog()) {
                        for (Map.Entry<String, LogAmounts> one : log2.getAmountList().entrySet()) {
                            if (!one.getValue().isNewEntry()) continue;
                            one.getValue().setNewEntry(false);
                            prest2.setInt(1, player.getUserId());
                            prest2.setInt(2, log2.getDate());
                            prest2.setString(3, log2.getActionType());
                            prest2.setString(4, one.getKey());
                            prest2.setInt(5, one.getValue().getCount());
                            prest2.setDouble(6, one.getValue().getMoney());
                            prest2.setDouble(7, one.getValue().getExp());
                            prest2.execute();
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest1);
                    JobsDAO.close(prest2);
                    this.dropDataBase("log");
                    this.createDefaultLogBase();
                    JobsDAO.close(prest1);
                    JobsDAO.close(prest2);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest1);
                JobsDAO.close(prest2);
                throw throwable;
            }
            JobsDAO.close(prest1);
            JobsDAO.close(prest2);
        }
    }

    public void loadLog(JobsPlayer player) {
        block7: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    int time = TimeManage.timeInInt();
                    prest = conn.prepareStatement("SELECT * FROM `" + this.prefix + "log` WHERE `userid` = ?  AND `time` = ? ;");
                    prest.setInt(1, player.getUserId());
                    prest.setInt(2, time);
                    res = prest.executeQuery();
                    while (res.next()) {
                        Jobs.getLoging().loadToLog(player, res.getString("action"), res.getString("itemname"), res.getInt("count"), res.getDouble("money"), res.getDouble("exp"));
                    }
                }
                catch (Exception e) {
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    this.dropDataBase("log");
                    this.createDefaultLogBase();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public void saveBlockProtection() {
        block19: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement insert = null;
            PreparedStatement update = null;
            PreparedStatement delete = null;
            try {
                try {
                    String message;
                    insert = conn.prepareStatement("INSERT INTO `" + this.prefix + "blocks` (`world`, `x`, `y`, `z`, `recorded`, `resets`) VALUES (?, ?, ?, ?, ?, ?);");
                    update = conn.prepareStatement("UPDATE `" + this.prefix + "blocks` SET `recorded` = ?, `resets` = ? WHERE `id` = ?;");
                    delete = conn.prepareStatement("DELETE from `" + this.getPrefix() + "blocks` WHERE `id` = ?;");
                    Jobs.getPluginLogger().info("Saving blocks");
                    conn.setAutoCommit(false);
                    int inserted = 0;
                    int updated = 0;
                    int deleted = 0;
                    Long current = System.currentTimeMillis();
                    Long mark = System.currentTimeMillis() - (long)Jobs.getGCManager().BlockProtectionDays * 24L * 60L * 60L * 1000L;
                    ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                    for (Map.Entry<World, HashMap<String, HashMap<String, HashMap<Vector, BlockProtection>>>> worlds : Jobs.getBpManager().getMap().entrySet()) {
                        for (Map.Entry<String, HashMap<String, HashMap<Vector, BlockProtection>>> regions : worlds.getValue().entrySet()) {
                            for (Map.Entry<String, HashMap<Vector, BlockProtection>> chunks : regions.getValue().entrySet()) {
                                block13: for (Map.Entry<Vector, BlockProtection> block : chunks.getValue().entrySet()) {
                                    switch (block.getValue().getAction()) {
                                        case DELETE: {
                                            delete.setInt(1, block.getValue().getId());
                                            delete.addBatch();
                                            if (++deleted % 10000 != 0) break;
                                            delete.executeBatch();
                                            String message2 = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Removed " + deleted + " old block protection entries."));
                                            console.sendMessage(message2);
                                            break;
                                        }
                                        case INSERT: {
                                            if (block.getValue().getTime() < current && block.getValue().getTime() != -1L) continue block13;
                                            insert.setString(1, worlds.getKey().getName());
                                            insert.setInt(2, block.getKey().getBlockX());
                                            insert.setInt(3, block.getKey().getBlockY());
                                            insert.setInt(4, block.getKey().getBlockZ());
                                            insert.setLong(5, block.getValue().getRecorded());
                                            insert.setLong(6, block.getValue().getTime());
                                            insert.addBatch();
                                            if (++inserted % 10000 != 0) break;
                                            insert.executeBatch();
                                            String message2 = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Added " + inserted + " new block protection entries."));
                                            console.sendMessage(message2);
                                            break;
                                        }
                                        case UPDATE: {
                                            if (block.getValue().getTime() < current && block.getValue().getTime() != -1L) continue block13;
                                            update.setLong(1, block.getValue().getRecorded());
                                            update.setLong(2, block.getValue().getTime());
                                            update.setInt(3, block.getValue().getId());
                                            update.addBatch();
                                            if (++updated % 10000 != 0) break;
                                            update.executeBatch();
                                            String message2 = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Upadated " + updated + " old block protection entries."));
                                            console.sendMessage(message2);
                                            break;
                                        }
                                        case NONE: {
                                            if (block.getValue().getTime() < current && block.getValue().getTime() != -1L || block.getValue().getTime() == -1L && block.getValue().getRecorded() > mark) continue block13;
                                            delete.setInt(1, block.getValue().getId());
                                            delete.addBatch();
                                            if (++deleted % 10000 != 0) break;
                                            delete.executeBatch();
                                            Jobs.getPluginLogger().info("[Jobs] Removed " + deleted + " old block protection entries.");
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    insert.executeBatch();
                    update.executeBatch();
                    delete.executeBatch();
                    conn.commit();
                    conn.setAutoCommit(true);
                    if (inserted > 0) {
                        message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Added " + inserted + " new block protection entries."));
                        console.sendMessage(message);
                    }
                    if (updated > 0) {
                        message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Updated " + updated + " with new block protection entries."));
                        console.sendMessage(message);
                    }
                    if (deleted > 0) {
                        message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Deleted " + deleted + " old block protection entries."));
                        console.sendMessage(message);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(insert);
                    JobsDAO.close(update);
                    JobsDAO.close(delete);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(insert);
                JobsDAO.close(update);
                JobsDAO.close(delete);
                throw throwable;
            }
            JobsDAO.close(insert);
            JobsDAO.close(update);
            JobsDAO.close(delete);
        }
    }

    public void loadBlockProtection() {
        block9: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            Jobs.getBpManager().timer = 0L;
            try {
                try {
                    prest = conn.prepareStatement("SELECT * FROM `" + this.prefix + "blocks`;");
                    res = prest.executeQuery();
                    int i = 0;
                    int ii = 0;
                    while (res.next()) {
                        World world = Bukkit.getWorld((String)res.getString("world"));
                        if (world == null) continue;
                        int id = res.getInt("id");
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        long resets = res.getLong("resets");
                        Location loc = new Location(world, (double)x, (double)y, (double)z);
                        BlockProtection bp2 = Jobs.getBpManager().add(loc, (Long)resets, true);
                        bp2.setId(id);
                        long t = System.currentTimeMillis();
                        bp2.setRecorded(res.getLong("recorded"));
                        bp2.setAction(DBAction.NONE);
                        ++i;
                        if (++ii >= 100000) {
                            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] Loading (" + i + ") BP"));
                            Bukkit.getServer().getConsoleSender().sendMessage(message);
                            ii = 0;
                        }
                        Jobs.getBpManager().timer = Jobs.getBpManager().timer + (System.currentTimeMillis() - t);
                    }
                    if (i > 0) {
                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[Jobs] loaded " + i + " block protection entries. " + Jobs.getBpManager().timer));
                        Bukkit.getServer().getConsoleSender().sendMessage(message);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public void saveExplore() {
        block11: {
            if (!Jobs.getExplore().isExploreEnabled()) {
                return;
            }
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest2 = null;
            try {
                try {
                    prest2 = conn.prepareStatement("INSERT INTO `" + this.prefix + "explore` (`worldname`, `chunkX`, `chunkZ`, `playerName`) VALUES (?, ?, ?, ?);");
                    conn.setAutoCommit(false);
                    int i = 0;
                    HashMap<String, ExploreRegion> temp = new HashMap<String, ExploreRegion>(Jobs.getExplore().getWorlds());
                    for (Map.Entry<String, ExploreRegion> worlds : temp.entrySet()) {
                        for (Map.Entry<String, ExploreChunk> oneChunk : worlds.getValue().getChunks().entrySet()) {
                            if (!oneChunk.getValue().isNew()) continue;
                            for (String oneuser : oneChunk.getValue().getPlayers()) {
                                prest2.setString(1, worlds.getKey());
                                prest2.setInt(2, oneChunk.getValue().getX());
                                prest2.setInt(3, oneChunk.getValue().getZ());
                                prest2.setString(4, oneuser);
                                prest2.addBatch();
                                ++i;
                            }
                        }
                    }
                    prest2.executeBatch();
                    conn.commit();
                    conn.setAutoCommit(true);
                    if (i > 0) {
                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&e[Jobs] Saved " + i + " new explorer entries."));
                        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                        console.sendMessage(message);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest2);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest2);
                throw throwable;
            }
            JobsDAO.close(prest2);
        }
    }

    public void loadExplore() {
        block8: {
            if (!Jobs.getExplore().isExploreEnabled()) {
                return;
            }
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT * FROM `" + this.prefix + "explore`;");
                    res = prest.executeQuery();
                    while (res.next()) {
                        Jobs.getExplore().ChunkRespond(res.getString("playerName"), res.getString("worldname"), res.getInt("chunkX"), res.getInt("chunkZ"), false);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
    }

    public List<Integer> getLognameList(int fromtime, int untiltime) {
        ArrayList<Integer> nameList;
        block7: {
            JobsConnection conn = this.getConnection();
            nameList = new ArrayList<Integer>();
            if (conn == null) {
                return nameList;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `userid` FROM `" + this.prefix + "log` WHERE `time` >= ?  AND `time` <= ? ;");
                    prest.setInt(1, fromtime);
                    prest.setInt(2, untiltime);
                    res = prest.executeQuery();
                    while (res.next()) {
                        if (nameList.contains(res.getInt("userid"))) continue;
                        nameList.add(res.getInt("userid"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return nameList;
    }

    public ArrayList<TopList> toplist(String jobsname, int limit2) {
        ArrayList<TopList> jobs;
        block8: {
            jobs = new ArrayList<TopList>();
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return jobs;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT `userid`, `level`, `experience` FROM `" + this.prefix + "jobs` WHERE `job` LIKE ? ORDER BY `level` DESC, LOWER(experience) DESC LIMIT " + limit2 + ", 15;");
                    prest.setString(1, jobsname);
                    res = prest.executeQuery();
                    while (res.next()) {
                        PlayerInfo info2 = Jobs.getPlayerManager().getPlayerInfo(res.getInt("userid"));
                        if (info2 == null || info2.getName() == null) continue;
                        String name = info2.getName();
                        Player player = Bukkit.getPlayer((String)name);
                        if (player != null) {
                            JobProgression prog;
                            JobsPlayer jobsinfo = Jobs.getPlayerManager().getJobsPlayer(player);
                            Job job = Jobs.getJob(jobsname);
                            if (job == null || jobsinfo == null || (prog = jobsinfo.getJobProgression(job)) == null) continue;
                            jobs.add(new TopList(info2, prog.getLevel(), (int)prog.getExperience()));
                            continue;
                        }
                        jobs.add(new TopList(info2, res.getInt("level"), res.getInt("experience")));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return jobs;
    }

    public synchronized int getSlotsTaken(Job job) {
        int slot;
        block7: {
            slot = 0;
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return slot;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            try {
                try {
                    prest = conn.prepareStatement("SELECT COUNT(*) FROM `" + this.prefix + "jobs` WHERE `job` = ?;");
                    prest.setString(1, job.getName());
                    res = prest.executeQuery();
                    if (res.next()) {
                        slot = res.getInt(1);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(res);
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return slot;
    }

    protected int getSchemaVersion() {
        int schema;
        block9: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return 0;
            }
            PreparedStatement prest = null;
            ResultSet res = null;
            schema = 0;
            try {
                prest = conn.prepareStatement("SELECT `value` FROM `" + this.prefix + "config` WHERE `key` = ?;");
                prest.setString(1, "version");
                res = prest.executeQuery();
                if (res.next()) {
                    schema = Integer.valueOf(res.getString(1));
                }
                res.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                JobsDAO.close(res);
                JobsDAO.close(prest);
                break block9;
            }
            catch (NumberFormatException e) {
                try {
                    e.printStackTrace();
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    JobsDAO.close(res);
                    JobsDAO.close(prest);
                }
            }
            JobsDAO.close(res);
            JobsDAO.close(prest);
        }
        return schema;
    }

    protected void updateSchemaVersion(int version) {
        this.updateSchemaConfig("version", Integer.toString(version));
    }

    private void updateSchemaConfig(String key, String value) {
        block6: {
            JobsConnection conn = this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement prest = null;
            try {
                try {
                    prest = conn.prepareStatement("UPDATE `" + this.prefix + "config` SET `value` = ? WHERE `key` = ?;");
                    prest.setString(1, value);
                    prest.setString(2, key);
                    prest.execute();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    JobsDAO.close(prest);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                JobsDAO.close(prest);
                throw throwable;
            }
            JobsDAO.close(prest);
        }
    }

    public void executeSQL(String sql) throws SQLException {
        JobsConnection conn = this.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        finally {
            JobsDAO.close(stmt);
        }
    }

    protected JobsConnection getConnection() {
        try {
            return this.pool.getConnection();
        }
        catch (SQLException e) {
            Jobs.getPluginLogger().severe("Unable to connect to the database: " + e.getMessage());
            return null;
        }
    }

    public synchronized void closeConnections() {
        this.pool.closeConnection();
    }

    private static void close(ResultSet res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public HashMap<Integer, ArrayList<JobsDAOData>> getMap() {
        return this.map;
    }
}

