/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.container;

import com.gamingmesh.jobs.container.CuboidArea;
import org.bukkit.Location;

public class RestrictedArea {
    private CuboidArea area;
    private double multiplier;
    private String name;

    public RestrictedArea(String name, CuboidArea area2, double multiplier) {
        this.name = name;
        this.area = area2;
        this.multiplier = multiplier;
    }

    public CuboidArea getCuboidArea() {
        return this.area;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean inRestrictedArea(Location loc) {
        if (loc == null) {
            return false;
        }
        if (!loc.getWorld().getName().equals(this.area.getWorld().getName())) {
            return false;
        }
        if (this.area.getLowLoc().getBlockX() > loc.getBlockX()) {
            return false;
        }
        if (this.area.getHighLoc().getBlockX() < loc.getBlockX()) {
            return false;
        }
        if (this.area.getLowLoc().getBlockZ() > loc.getBlockZ()) {
            return false;
        }
        if (this.area.getHighLoc().getBlockZ() < loc.getBlockZ()) {
            return false;
        }
        if (this.area.getLowLoc().getBlockY() > loc.getBlockY()) {
            return false;
        }
        return this.area.getHighLoc().getBlockY() >= loc.getBlockY();
    }

    public String getName() {
        return this.name;
    }
}

