/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.container;

import org.bukkit.Location;
import org.bukkit.World;

public class CuboidArea {
    protected Location highPoints;
    protected Location lowPoints;
    protected String worldName;

    protected CuboidArea() {
    }

    public CuboidArea(Location startLoc, Location endLoc) {
        int lowz;
        int highz;
        int lowy;
        int highy;
        int lowx;
        int highx;
        if (startLoc.getBlockX() > endLoc.getBlockX()) {
            highx = startLoc.getBlockX();
            lowx = endLoc.getBlockX();
        } else {
            highx = endLoc.getBlockX();
            lowx = startLoc.getBlockX();
        }
        if (startLoc.getBlockY() > endLoc.getBlockY()) {
            highy = startLoc.getBlockY();
            lowy = endLoc.getBlockY();
        } else {
            highy = endLoc.getBlockY();
            lowy = startLoc.getBlockY();
        }
        if (startLoc.getBlockZ() > endLoc.getBlockZ()) {
            highz = startLoc.getBlockZ();
            lowz = endLoc.getBlockZ();
        } else {
            highz = endLoc.getBlockZ();
            lowz = startLoc.getBlockZ();
        }
        this.highPoints = new Location(startLoc.getWorld(), (double)highx, (double)highy, (double)highz);
        this.lowPoints = new Location(startLoc.getWorld(), (double)lowx, (double)lowy, (double)lowz);
        this.worldName = startLoc.getWorld().getName();
    }

    public long getSize() {
        int xsize = this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
        int zsize = this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
        int ysize = this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
        return xsize * ysize * zsize;
    }

    public int getXSize() {
        return this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
    }

    public int getYSize() {
        return this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
    }

    public int getZSize() {
        return this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
    }

    public Location getHighLoc() {
        return this.highPoints;
    }

    public Location getLowLoc() {
        return this.lowPoints;
    }

    public World getWorld() {
        return this.highPoints.getWorld();
    }
}

