/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.BoostMultiplier;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.DisplayMethod;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobCommands;
import com.gamingmesh.jobs.container.JobConditions;
import com.gamingmesh.jobs.container.JobInfo;
import com.gamingmesh.jobs.container.JobItems;
import com.gamingmesh.jobs.container.JobLimitedItems;
import com.gamingmesh.jobs.container.JobPermission;
import com.gamingmesh.jobs.resources.jfep.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class ConfigManager {
    private Jobs plugin;

    public ConfigManager(Jobs plugin) {
        this.plugin = plugin;
    }

    public void reload() throws IOException {
        this.loadJobSettings();
    }

    private void loadJobSettings() throws IOException {
        File f = new File(this.plugin.getDataFolder(), "jobConfig.yml");
        InputStreamReader s = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
        ArrayList<Job> jobs = new ArrayList<Job>();
        Jobs.setJobs(jobs);
        Jobs.setNoneJob(null);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Jobs.getPluginLogger().severe("Unable to create jobConfig.yml!  No jobs were loaded!");
                s.close();
                return;
            }
        }
        YamlConfiguration conf = new YamlConfiguration();
        conf.options().pathSeparator('/');
        try {
            try {
                conf.load((Reader)s);
                s.close();
            }
            catch (Exception e) {
                Bukkit.getServer().getLogger().severe("==================== Jobs ====================");
                Bukkit.getServer().getLogger().severe("Unable to load jobConfig.yml!");
                Bukkit.getServer().getLogger().severe("Check your config for formatting issues!");
                Bukkit.getServer().getLogger().severe("No jobs were loaded!");
                Bukkit.getServer().getLogger().severe("Error: " + e.getMessage());
                Bukkit.getServer().getLogger().severe("==============================================");
                s.close();
                return;
            }
        }
        finally {
            s.close();
        }
        ConfigurationSection jobsSection = conf.getConfigurationSection("Jobs");
        for (String jobKey : jobsSection.getKeys(false)) {
            Parser expEquation;
            Parser maxExpEquation;
            DisplayMethod displayMethod;
            String jobShortName;
            Integer maxSlots;
            int vipmaxLevel;
            if (jobKey.equalsIgnoreCase("exampleJob")) continue;
            ConfigurationSection jobSection = jobsSection.getConfigurationSection(jobKey);
            String jobName = jobSection.getString("fullname", null);
            if ((jobName = StringEscapeUtils.unescapeJava((String)jobName)) == null) {
                Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid fullname property. Skipping job!");
                continue;
            }
            int maxLevel = jobSection.getInt("max-level", 0);
            if (maxLevel < 0) {
                maxLevel = 0;
            }
            if ((vipmaxLevel = jobSection.getInt("vip-max-level", 0)) < 0) {
                vipmaxLevel = 0;
            }
            if ((maxSlots = Integer.valueOf(jobSection.getInt("slots", 0))) <= 0) {
                maxSlots = null;
            }
            if ((jobShortName = jobSection.getString("shortname", null)) == null) {
                Jobs.getPluginLogger().warning("Job " + jobKey + " is missing the shortname property.  Skipping job!");
                continue;
            }
            String description = ChatColor.translateAlternateColorCodes((char)'&', (String)jobSection.getString("description", ""));
            com.gamingmesh.jobs.stuff.ChatColor color = com.gamingmesh.jobs.stuff.ChatColor.WHITE;
            if (jobSection.contains("ChatColour") && (color = com.gamingmesh.jobs.stuff.ChatColor.matchColor(jobSection.getString("ChatColour", ""))) == null) {
                color = com.gamingmesh.jobs.stuff.ChatColor.WHITE;
                Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid ChatColour property.  Defaulting to WHITE!");
            }
            String bossbar = null;
            if (jobSection.contains("BossBarColour") && (bossbar = jobSection.getString("BossBarColour", "")) == null) {
                color = com.gamingmesh.jobs.stuff.ChatColor.WHITE;
                Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid BossBarColour property.");
            }
            if ((displayMethod = DisplayMethod.matchMethod(jobSection.getString("chat-display", ""))) == null) {
                Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid chat-display property. Defaulting to None!");
                displayMethod = DisplayMethod.NONE;
            }
            String maxExpEquationInput = jobSection.getString("leveling-progression-equation");
            try {
                maxExpEquation = new Parser(maxExpEquationInput);
                maxExpEquation.setVariable("numjobs", 1.0);
                maxExpEquation.setVariable("joblevel", 1.0);
                maxExpEquation.getValue();
            }
            catch (Exception e) {
                Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid leveling-progression-equation property. Skipping job!");
                continue;
            }
            Parser incomeEquation = new Parser("0");
            if (jobSection.isString("income-progression-equation")) {
                String incomeEquationInput = jobSection.getString("income-progression-equation");
                try {
                    incomeEquation = new Parser(incomeEquationInput);
                    incomeEquation.setVariable("numjobs", 1.0);
                    incomeEquation.setVariable("joblevel", 1.0);
                    incomeEquation.setVariable("baseincome", 1.0);
                    incomeEquation.getValue();
                }
                catch (Exception e) {
                    Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid income-progression-equation property. Skipping job!");
                    continue;
                }
            }
            String expEquationInput = jobSection.getString("experience-progression-equation");
            try {
                expEquation = new Parser(expEquationInput);
                expEquation.setVariable("numjobs", 1.0);
                expEquation.setVariable("joblevel", 1.0);
                expEquation.setVariable("baseexperience", 1.0);
                expEquation.getValue();
            }
            catch (Exception e) {
                Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid experience-progression-equation property. Skipping job!");
                continue;
            }
            Parser pointsEquation = new Parser("0");
            if (jobSection.isString("points-progression-equation")) {
                String pointsEquationInput = jobSection.getString("points-progression-equation");
                try {
                    pointsEquation = new Parser(pointsEquationInput);
                    pointsEquation.setVariable("numjobs", 1.0);
                    pointsEquation.setVariable("joblevel", 1.0);
                    pointsEquation.setVariable("basepoints", 1.0);
                    pointsEquation.getValue();
                }
                catch (Exception e) {
                    Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid points-progression-equation property. Skipping job!");
                    continue;
                }
            }
            ItemStack GUIitem = new ItemStack(Material.getMaterial((int)35), 1, 13);
            if (jobSection.contains("Gui")) {
                ConfigurationSection guiSection = jobSection.getConfigurationSection("Gui");
                if (guiSection.contains("Id") && guiSection.contains("Data") && guiSection.isInt("Id") && guiSection.isInt("Data")) {
                    GUIitem = new ItemStack(Material.getMaterial((int)guiSection.getInt("Id")), 1, (short)((byte)guiSection.getInt("Data")));
                } else {
                    Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid Gui property. Please fix this if you want to use it!");
                }
            }
            ArrayList<JobPermission> jobPermissions = new ArrayList<JobPermission>();
            ConfigurationSection permissionsSection = jobSection.getConfigurationSection("permissions");
            if (permissionsSection != null) {
                for (String permissionKey : permissionsSection.getKeys(false)) {
                    ConfigurationSection permissionSection = permissionsSection.getConfigurationSection(permissionKey);
                    String node = permissionKey.toLowerCase();
                    if (permissionSection == null) {
                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid permission key" + permissionKey + "!");
                        continue;
                    }
                    boolean value = permissionSection.getBoolean("value", true);
                    int levelRequirement = permissionSection.getInt("level", 0);
                    jobPermissions.add(new JobPermission(node, value, levelRequirement));
                }
            }
            ArrayList<JobConditions> jobConditions = new ArrayList<JobConditions>();
            ConfigurationSection conditionsSection = jobSection.getConfigurationSection("conditions");
            if (conditionsSection != null) {
                for (String ConditionKey : conditionsSection.getKeys(false)) {
                    ConfigurationSection permissionSection = conditionsSection.getConfigurationSection(ConditionKey);
                    String node = ConditionKey.toLowerCase();
                    if (permissionSection == null) {
                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid condition key " + ConditionKey + "!");
                        continue;
                    }
                    if (!permissionSection.contains("requires") || !permissionSection.contains("perform")) {
                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid condition requirement " + ConditionKey + "!");
                        continue;
                    }
                    List requires = permissionSection.getStringList("requires");
                    List perform = permissionSection.getStringList("perform");
                    jobConditions.add(new JobConditions(node, requires, perform));
                }
            }
            ArrayList<String> JobsCommandOnLeave = new ArrayList();
            if (jobSection.isList("cmd-on-leave")) {
                JobsCommandOnLeave = jobSection.getStringList("cmd-on-leave");
            }
            ArrayList<String> JobsCommandOnJoin = new ArrayList();
            if (jobSection.isList("cmd-on-join")) {
                JobsCommandOnJoin = jobSection.getStringList("cmd-on-join");
            }
            ArrayList<JobCommands> jobCommand = new ArrayList<JobCommands>();
            ConfigurationSection commandsSection = jobSection.getConfigurationSection("commands");
            if (commandsSection != null) {
                for (String commandKey : commandsSection.getKeys(false)) {
                    ConfigurationSection commandSection = commandsSection.getConfigurationSection(commandKey);
                    String node = commandKey.toLowerCase();
                    if (commandSection == null) {
                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid command key" + commandKey + "!");
                        continue;
                    }
                    String command = commandSection.getString("command");
                    int levelFrom = commandSection.getInt("levelFrom");
                    int levelUntil = commandSection.getInt("levelUntil");
                    jobCommand.add(new JobCommands(node, command, levelFrom, levelUntil));
                }
            }
            ArrayList<JobItems> jobItems = new ArrayList<JobItems>();
            ConfigurationSection itemsSection = jobSection.getConfigurationSection("items");
            if (itemsSection != null) {
                for (String itemKey : itemsSection.getKeys(false)) {
                    ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                    String node = itemKey.toLowerCase();
                    if (itemSection == null) {
                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid item key " + itemKey + "!");
                        continue;
                    }
                    int id = itemSection.getInt("id");
                    String name = null;
                    if (itemSection.isString("name")) {
                        name = itemSection.getString("name");
                    }
                    ArrayList<String> lore = new ArrayList<String>();
                    if (itemSection.getStringList("lore") != null) {
                        for (String eachLine : itemSection.getStringList("lore")) {
                            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)eachLine));
                        }
                    }
                    HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
                    if (itemSection.getStringList("enchants") != null) {
                        for (String eachLine : itemSection.getStringList("enchants")) {
                            if (!eachLine.contains("=")) continue;
                            Enchantment ench = Enchantment.getByName((String)eachLine.split("=")[0]);
                            Object level = -1;
                            try {
                                level = Integer.parseInt(eachLine.split("=")[1]);
                            }
                            catch (NumberFormatException e) {
                                continue;
                            }
                            if (ench == null || (Integer)level == -1) continue;
                            enchants.put(ench, (Integer)level);
                        }
                    }
                    BoostMultiplier b = new BoostMultiplier();
                    if (itemSection.isDouble("moneyBoost")) {
                        b.add(CurrencyType.MONEY, itemSection.getDouble("moneyBoost") - 1.0);
                    }
                    if (itemSection.isDouble("pointBoost")) {
                        b.add(CurrencyType.POINTS, itemSection.getDouble("pointBoost") - 1.0);
                    }
                    if (itemSection.isDouble("expBoost")) {
                        b.add(CurrencyType.EXP, itemSection.getDouble("expBoost") - 1.0);
                    }
                    jobItems.add(new JobItems(node, id, 0, 1, name, lore, enchants, b));
                }
            }
            ArrayList<JobLimitedItems> jobLimitedItems = new ArrayList<JobLimitedItems>();
            ConfigurationSection LimitedItemsSection = jobSection.getConfigurationSection("limitedItems");
            if (LimitedItemsSection != null) {
                for (String itemKey : LimitedItemsSection.getKeys(false)) {
                    ConfigurationSection itemSection = LimitedItemsSection.getConfigurationSection(itemKey);
                    String node = itemKey.toLowerCase();
                    if (itemSection == null) {
                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid item key " + itemKey + "!");
                        continue;
                    }
                    int id = itemSection.getInt("id");
                    String name = null;
                    if (itemSection.isString("name")) {
                        name = itemSection.getString("name");
                    }
                    ArrayList<String> lore = new ArrayList<String>();
                    if (itemSection.getStringList("lore") != null) {
                        for (String eachLine : itemSection.getStringList("lore")) {
                            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)eachLine));
                        }
                    }
                    HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
                    if (itemSection.getStringList("enchants") != null) {
                        for (String eachLine : itemSection.getStringList("enchants")) {
                            if (!eachLine.contains("=")) continue;
                            Enchantment ench = Enchantment.getByName((String)eachLine.split("=")[0]);
                            Integer level = -1;
                            try {
                                level = Integer.parseInt(eachLine.split("=")[1]);
                            }
                            catch (NumberFormatException e) {
                                continue;
                            }
                            if (ench == null || level == -1) continue;
                            enchants.put(ench, level);
                        }
                    }
                    int level = itemSection.getInt("level");
                    jobLimitedItems.add(new JobLimitedItems(node, id, name, lore, enchants, level));
                }
            }
            Job job = new Job(jobName, jobShortName, description, color, maxExpEquation, displayMethod, maxLevel, vipmaxLevel, maxSlots, jobPermissions, jobCommand, jobConditions, jobItems, jobLimitedItems, JobsCommandOnJoin, JobsCommandOnLeave, GUIitem, bossbar);
            ActionType[] actionTypeArray = ActionType.values();
            int n = actionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayList<JobInfo> jobInfo;
                ActionType actionType;
                block122: {
                    actionType = actionTypeArray[n2];
                    ConfigurationSection typeSection = jobSection.getConfigurationSection(actionType.getName());
                    jobInfo = new ArrayList<JobInfo>();
                    if (typeSection == null) break block122;
                    for (String key : typeSection.getKeys(false)) {
                        int id;
                        String meta;
                        String subType;
                        String type;
                        ConfigurationSection section;
                        block124: {
                            String myKey;
                            block125: {
                                block123: {
                                    Material material;
                                    section = typeSection.getConfigurationSection(key);
                                    myKey = key;
                                    type = null;
                                    subType = "";
                                    meta = "";
                                    id = 0;
                                    if (myKey.contains("-")) {
                                        subType = ":" + myKey.split("-")[1];
                                        meta = myKey.split("-")[1];
                                        myKey = myKey.split("-")[0];
                                    }
                                    if ((material = Material.matchMaterial((String)myKey)) == null) {
                                        material = Material.getMaterial((String)myKey.replace(" ", "_").toUpperCase());
                                    }
                                    if (material == null) {
                                        Integer matId = null;
                                        try {
                                            matId = Integer.valueOf(myKey);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        if (matId != null && (material = Material.getMaterial((int)matId)) != null) {
                                            Jobs.getPluginLogger().warning("Job " + jobKey + " " + actionType.getName() + " is using ID: " + key + "!");
                                            Jobs.getPluginLogger().warning("Please use the Material name instead: " + material.toString() + "!");
                                        }
                                    }
                                    if (actionType == ActionType.EXPLORE) {
                                        material = null;
                                    }
                                    if (material == null) break block123;
                                    if (!(actionType != ActionType.BREAK && actionType != ActionType.PLACE || material.isBlock())) {
                                        Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid " + actionType.getName() + " type property: " + key + "! Material must be a block!");
                                        continue;
                                    }
                                    if (material == Material.REDSTONE_ORE && actionType == ActionType.BREAK) {
                                        Jobs.getPluginLogger().warning("Job " + jobKey + " is using REDSTONE_ORE instead of GLOWING_REDSTONE_ORE.");
                                        Jobs.getPluginLogger().warning("Automatically changing block to GLOWING_REDSTONE_ORE.  Please update your configuration.");
                                        Jobs.getPluginLogger().warning("In vanilla minecraft, REDSTONE_ORE changes to GLOWING_REDSTONE_ORE when interacted with.");
                                        Jobs.getPluginLogger().warning("In the future, Jobs using REDSTONE_ORE instead of GLOWING_REDSTONE_ORE may fail to work correctly.");
                                        material = Material.GLOWING_REDSTONE_ORE;
                                    }
                                    type = material.toString();
                                    id = material.getId();
                                    break block124;
                                }
                                if (actionType != ActionType.KILL && actionType != ActionType.TAME && actionType != ActionType.BREED && actionType != ActionType.MILK) break block125;
                                EntityType entity = EntityType.fromName((String)key);
                                if (entity == null) {
                                    try {
                                        entity = EntityType.valueOf((String)key.toUpperCase());
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        // empty catch block
                                    }
                                }
                                if (entity != null && entity.isAlive()) {
                                    type = entity.toString();
                                    id = entity.getTypeId();
                                    if (actionType == ActionType.BREED) {
                                        Jobs.getGCManager().setBreederFinder(true);
                                    }
                                }
                                switch (key.toLowerCase()) {
                                    case "skeletonwither": {
                                        type = "SkeletonWither";
                                        id = 51;
                                        meta = "1";
                                        break;
                                    }
                                    case "skeletonstray": {
                                        type = "SkeletonStray";
                                        id = 51;
                                        meta = "2";
                                        break;
                                    }
                                    case "zombievillager": {
                                        type = "ZombieVillager";
                                        id = 54;
                                        meta = "1";
                                        break;
                                    }
                                    case "zombiehusk": {
                                        type = "ZombieHusk";
                                        id = 54;
                                        meta = "2";
                                        break;
                                    }
                                    case "horseskeleton": {
                                        type = "HorseSkeleton";
                                        id = 100;
                                        meta = "1";
                                        break;
                                    }
                                    case "horsezombie": {
                                        type = "HorseZombie";
                                        id = 100;
                                        meta = "2";
                                        break;
                                    }
                                    case "guardianelder": {
                                        type = "GuardianElder";
                                        id = 68;
                                        meta = "1";
                                    }
                                }
                                break block124;
                            }
                            if (actionType == ActionType.ENCHANT) {
                                Enchantment enchant = Enchantment.getByName((String)myKey);
                                if (enchant != null) {
                                    id = enchant.getId();
                                }
                                type = myKey;
                            } else if (actionType == ActionType.CUSTOMKILL || actionType == ActionType.SHEAR || actionType == ActionType.MMKILL) {
                                type = myKey;
                            } else if (actionType == ActionType.EXPLORE) {
                                type = myKey;
                                int amount = 10;
                                try {
                                    amount = Integer.valueOf(myKey);
                                }
                                catch (NumberFormatException e) {
                                    Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid " + actionType.getName() + " type property: " + key + "!");
                                    continue;
                                }
                                Jobs.getExplore().setExploreEnabled();
                                Jobs.getExplore().setPlayerAmount(amount + 1);
                            }
                        }
                        if (type == null) {
                            Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid " + actionType.getName() + " type property: " + key + "!");
                            continue;
                        }
                        if (actionType == ActionType.TNTBREAK) {
                            Jobs.getGCManager().setTntFinder(true);
                        }
                        double income = section.getDouble("income", 0.0);
                        double points2 = section.getDouble("points", 0.0);
                        double experience = section.getDouble("experience", 0.0);
                        int fromlevel = 1;
                        if (section.isInt("from-level")) {
                            fromlevel = section.getInt("from-level");
                        }
                        int untilLevel = -1;
                        if (section.isInt("until-level") && (untilLevel = section.getInt("until-level")) < fromlevel) {
                            Jobs.getPluginLogger().warning("Job " + jobKey + " has an invalid until-level in " + actionType.getName() + " for type property: " + key + "! It will be not set.");
                            untilLevel = -1;
                        }
                        jobInfo.add(new JobInfo(actionType, id, meta, String.valueOf(type) + subType, income, incomeEquation, experience, expEquation, pointsEquation, points2, fromlevel, untilLevel));
                    }
                }
                job.setJobInfo(actionType, jobInfo);
                ++n2;
            }
            if (jobKey.equalsIgnoreCase("none")) {
                Jobs.setNoneJob(job);
                continue;
            }
            jobs.add(job);
        }
        Bukkit.getConsoleSender().sendMessage((Object)((Object)com.gamingmesh.jobs.stuff.ChatColor.YELLOW) + "[Jobs] Loaded " + Jobs.getJobs().size() + " jobs!");
        if (!Jobs.getExplore().isExploreEnabled()) {
            Bukkit.getConsoleSender().sendMessage((Object)((Object)com.gamingmesh.jobs.stuff.ChatColor.GOLD) + "[Jobs] Explorer jobs manager are not enabled!");
        } else {
            Bukkit.getConsoleSender().sendMessage((Object)((Object)com.gamingmesh.jobs.stuff.ChatColor.YELLOW) + "[Jobs] Explorer job manager registered!");
        }
    }
}

