/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.commands;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.commands.Cmd;
import com.gamingmesh.jobs.commands.JobCommand;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.Boost;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobInfo;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JobsCommands
implements CommandExecutor {
    private static final String label = "jobs";
    private static final String packagePath = "com.gamingmesh.jobs.commands.list";
    private static final List<String> hidenCommands = new ArrayList<String>();
    Map<String, Integer> CommandList = new HashMap<String, Integer>();
    protected Jobs plugin;

    public JobsCommands(Jobs plugin) {
        this.plugin = plugin;
    }

    public Map<String, Integer> getCommands() {
        return this.CommandList;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && !Jobs.getGCManager().canPerformActionInWorld(((Player)sender).getWorld()) && !sender.hasPermission("jobs.disabledworld.commands")) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.worldisdisabled"));
            return true;
        }
        if (args.length == 0) {
            return this.help(sender, 1);
        }
        if ((args.length == 1 || args.length == 2) && (args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("help"))) {
            int page = 1;
            if (args.length == 2) {
                try {
                    page = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(Jobs.getLanguage().getMessage("general.error.notNumber"));
                    return true;
                }
            }
            return this.help(sender, page);
        }
        String cmd = args[0].toLowerCase();
        if (!JobsCommands.hasCommandPermission(sender, cmd)) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.permission"));
            return true;
        }
        String[] myArgs = JobsCommands.reduceArgs(args);
        if (myArgs.length > 0 && myArgs[myArgs.length - 1].equals("?")) {
            this.sendUsage(sender, cmd);
            return true;
        }
        Cmd cmdClass = JobsCommands.getCmdClass(cmd);
        if (cmdClass == null) {
            return this.help(sender, 1);
        }
        boolean back = cmdClass.perform(this.plugin, sender, myArgs);
        if (back) {
            return true;
        }
        if (!(sender instanceof Player)) {
            return this.help(sender, 1);
        }
        return this.help(sender, 1);
    }

    private static String[] reduceArgs(String[] args) {
        return args.length <= 1 ? new String[]{} : Arrays.copyOfRange(args, 1, args.length);
    }

    private static boolean hasCommandPermission(CommandSender sender, String cmd) {
        return sender.hasPermission("jobs.command." + cmd);
    }

    private static String getUsage(String cmd) {
        StringBuilder builder = new StringBuilder();
        builder.append(ChatColor.GREEN.toString());
        builder.append('/').append(label).append(' ');
        builder.append(cmd);
        builder.append(ChatColor.YELLOW);
        String key = "command." + cmd + ".help.args";
        if (Jobs.getLanguage().containsKey(key)) {
            builder.append(' ');
            builder.append(Jobs.getLanguage().getMessage(key));
        }
        return builder.toString();
    }

    public static String getUsageNoCmd(String cmd) {
        StringBuilder builder = new StringBuilder();
        builder.append(ChatColor.GREEN.toString());
        builder.append('/').append(label).append(' ');
        builder.append(ChatColor.YELLOW);
        String key = "command." + cmd + ".help.args";
        if (Jobs.getLanguage().containsKey(key)) {
            builder.append(' ');
            builder.append(Jobs.getLanguage().getMessage(key));
        }
        return builder.toString();
    }

    public void sendUsage(CommandSender sender, String cmd) {
        String message = ChatColor.YELLOW + Jobs.getLanguage().getMessage("command.help.output.usage");
        message = message.replace("%usage%", JobsCommands.getUsage(cmd));
        sender.sendMessage(message);
        sender.sendMessage(ChatColor.YELLOW + "* " + Jobs.getLanguage().getMessage("command." + cmd + ".help.info"));
    }

    protected boolean help(CommandSender sender, int page) {
        Map<String, Integer> commands = this.GetCommands(sender);
        if (commands.size() == 0) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.permission"));
            return true;
        }
        commands = JobsCommands.sort(commands);
        int amountToShow = 7;
        int start = page * amountToShow - amountToShow;
        int end = page * amountToShow;
        int TotalPages = commands.size() / amountToShow;
        if ((double)commands.size() * 1.0 / ((double)amountToShow * 1.0) - (double)TotalPages > 0.0) {
            ++TotalPages;
        }
        if (start >= commands.size()) {
            start = page * amountToShow;
            end = start + amountToShow;
        }
        if (page > TotalPages || page < 1) {
            Jobs.getActionBar().send(sender, Jobs.getLanguage().getMessage("general.error.noHelpPage"));
            return true;
        }
        sender.sendMessage(Jobs.getLanguage().getMessage("command.help.output.title"));
        sender.sendMessage(Jobs.getLanguage().getMessage("command.help.output.page", "[1]", page, "[2]", TotalPages));
        int i = -1;
        for (Map.Entry<String, Integer> one : commands.entrySet()) {
            if (++i < start) continue;
            if (i >= end) break;
            sender.sendMessage(String.valueOf(JobsCommands.getUsage(one.getKey())) + " - " + Jobs.getLanguage().getMessage("command." + one.getKey() + ".help.info"));
        }
        String prevCmd = "/jobs ? " + (page - 1);
        String prev = "[\"\",{\"text\":\"" + Jobs.getLanguage().getMessage("command.help.output.prev") + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + prevCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + "<<<" + "\"}]}}}";
        String nextCmd = "/jobs ? " + (page + 1);
        String next = " {\"text\":\"" + Jobs.getLanguage().getMessage("command.help.output.next") + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + nextCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ">>>" + "\"}]}}}]";
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + sender.getName() + " " + prev + "," + next));
        return true;
    }

    private static List<String> getClassesFromPackage(String pckgname) throws ClassNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL[] uRLArray = ((URLClassLoader)Jobs.class.getClassLoader()).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL jarURL = uRLArray[n2];
                try {
                    result.addAll(JobsCommands.getClassesInSamePackageFromJar(pckgname, jarURL.toURI().getPath()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " does not appear to be a valid package (Null pointer exception)");
        }
        return result;
    }

    private static List<String> getClassesInSamePackageFromJar(String packageName, String jarPath) {
        ArrayList<String> listOfCommands;
        block14: {
            JarFile jarFile = null;
            listOfCommands = new ArrayList<String>();
            try {
                try {
                    jarFile = new JarFile(jarPath);
                    Enumeration<JarEntry> en = jarFile.entries();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String entryName = entry.getName();
                        packageName = packageName.replace(".", "/");
                        if (entryName == null || !entryName.endsWith(".class") || !entryName.startsWith(packageName)) continue;
                        String name = entryName.replace(packageName, "").replace(".class", "").replace("/", "");
                        if (name.contains("$")) {
                            name = name.split("\\$")[0];
                        }
                        listOfCommands.add(name);
                    }
                }
                catch (Exception exception) {
                    if (jarFile == null) break block14;
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return listOfCommands;
    }

    public Map<String, Integer> GetCommands(CommandSender sender) {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> cmd : this.CommandList.entrySet()) {
            if (!JobsCommands.hasCommandPermission(sender, cmd.getKey())) continue;
            temp.put(cmd.getKey(), cmd.getValue());
        }
        return temp;
    }

    public void fillCommands() {
        List<Object> lm = new ArrayList();
        HashMap classes = new HashMap();
        try {
            lm = JobsCommands.getClassesFromPackage(packagePath);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        for (String string : lm) {
            Class<?> newclass = JobsCommands.getClass(string);
            if (newclass == null) continue;
            classes.put(string, newclass);
        }
        block3: for (Map.Entry entry : classes.entrySet()) {
            Method[] methodArray = ((Class)entry.getValue()).getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method met = methodArray[n2];
                if (met.isAnnotationPresent(JobCommand.class)) {
                    String cmd = (String)entry.getKey();
                    if (!hidenCommands.contains(met.getName().toLowerCase())) {
                        this.CommandList.put(cmd, met.getAnnotation(JobCommand.class).value());
                        continue block3;
                    }
                }
                ++n2;
            }
        }
    }

    private static Class<?> getClass(String cmd) {
        Class<?> nmsClass = null;
        try {
            nmsClass = Class.forName("com.gamingmesh.jobs.commands.list." + cmd.toLowerCase());
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            // empty catch block
        }
        return nmsClass;
    }

    private static Cmd getCmdClass(String cmd) {
        Cmd cmdClass = null;
        try {
            Class<?> nmsClass = Class.forName("com.gamingmesh.jobs.commands.list." + cmd.toLowerCase());
            if (Cmd.class.isAssignableFrom(nmsClass)) {
                cmdClass = (Cmd)nmsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return cmdClass;
    }

    private static Map<String, Integer> sort(Map<String, Integer> unsortMap) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public boolean hasJobPermission(Player sender, Job job) {
        return this.hasJobPermission((CommandSender)sender, job);
    }

    public boolean hasJobPermission(CommandSender sender, Job job) {
        if (!sender.hasPermission("jobs.use")) {
            return false;
        }
        return sender.hasPermission("jobs.join." + job.getName().toLowerCase());
    }

    public void sendValidActions(CommandSender sender) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        ActionType[] actionTypeArray = ActionType.values();
        int n = actionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionType action = actionTypeArray[n2];
            if (!first) {
                builder.append(',');
            }
            builder.append(action.getName());
            first = false;
            ++n2;
        }
        sender.sendMessage(Jobs.getLanguage().getMessage("command.info.help.actions", "%actions%", builder.toString()));
    }

    public void jobInfoMessage(CommandSender sender, JobsPlayer player, Job job, String type, int page) {
        String t;
        ActionType actionType;
        if (job == null) {
            sender.sendMessage(ChatColor.RED + Jobs.getLanguage().getMessage("general.error.job"));
            return;
        }
        type = type == null ? "" : type.toLowerCase();
        StringBuilder message = new StringBuilder();
        boolean showAllTypes = true;
        ActionType[] actionTypeArray = ActionType.values();
        int n = actionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            actionType = actionTypeArray[n2];
            if (type.startsWith(actionType.getName().toLowerCase())) {
                showAllTypes = false;
                break;
            }
            ++n2;
        }
        if (job.getBoost().get(CurrencyType.EXP) != 0.0) {
            message.append(ChatColor.GOLD + Jobs.getLanguage().getMessage("command.expboost.output.infostats", "%boost%", job.getBoost().get(CurrencyType.EXP) + 1.0) + "\n");
        }
        if (job.getBoost().get(CurrencyType.MONEY) != 0.0) {
            message.append(ChatColor.GOLD + Jobs.getLanguage().getMessage("command.moneyboost.output.infostats", "%boost%", job.getBoost().get(CurrencyType.MONEY) + 1.0) + "\n");
        }
        if (job.getBoost().get(CurrencyType.POINTS) != 0.0) {
            message.append(ChatColor.GOLD + Jobs.getLanguage().getMessage("command.pointboost.output.infostats", "%boost%", job.getBoost().get(CurrencyType.POINTS) + 1.0) + "\n");
        }
        if (Jobs.getGCManager().useDynamicPayment) {
            if (job.getBonus() < 0.0) {
                message.append(ChatColor.GOLD + Jobs.getLanguage().getMessage("command.info.help.penalty", "[penalty]", (double)((int)(job.getBonus() * 100.0)) / 100.0 * -1.0) + "\n");
            } else {
                message.append(ChatColor.GOLD + Jobs.getLanguage().getMessage("command.info.help.bonus", "[bonus]", (double)((int)(job.getBonus() * 100.0)) / 100.0) + "\n");
            }
        }
        actionTypeArray = ActionType.values();
        n = actionTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            actionType = actionTypeArray[n2];
            if (showAllTypes || type.startsWith(actionType.getName().toLowerCase())) {
                List<JobInfo> info2 = job.getJobInfo(actionType);
                if (info2 != null && !info2.isEmpty()) {
                    message.append(JobsCommands.jobInfoMessage(player, job, actionType));
                } else if (!showAllTypes) {
                    String myMessage = Jobs.getLanguage().getMessage("command.info.output." + actionType.getName().toLowerCase() + ".none");
                    myMessage = myMessage.replace("%jobname%", (Object)((Object)job.getChatColor()) + job.getName() + ChatColor.WHITE);
                    message.append(myMessage);
                }
            }
            ++n2;
        }
        StringBuilder message2 = new StringBuilder();
        int perPage = 20;
        int start = (page - 1) * perPage;
        int end = start + perPage;
        int pagecount = (int)Math.ceil((double)message.toString().split("\n").length / (double)perPage);
        if (pagecount == 0) {
            pagecount = 1;
        }
        if (page > pagecount) {
            player.getPlayer().sendMessage("Invalid page");
            return;
        }
        if (message.toString().split("\n").length > perPage && sender instanceof Player) {
            int i = 0;
            String[] stringArray = message.toString().split("\n");
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String one = stringArray[n4];
                if (++i > start) {
                    if (i > end) break;
                    message2.append(one);
                    message2.append("\n");
                }
                ++n4;
            }
            message = message2;
        }
        sender.sendMessage(message.toString().split("\n"));
        String string = t = type == "" ? "" : " " + type;
        if (sender instanceof Player) {
            if (sender.getName().equalsIgnoreCase(player.getUserName())) {
                JobsCommands.ShowPagination(sender.getName(), pagecount, page, "jobs info " + job.getName() + t);
            } else {
                JobsCommands.ShowPagination(sender.getName(), pagecount, page, "jobs playerinfo " + player.getUserName() + " " + job.getName() + t);
            }
        }
    }

    public static void ShowPagination(String target, int pageCount, int CurrentPage, String cmd) {
        if (target.equalsIgnoreCase("console")) {
            return;
        }
        if (pageCount == 1) {
            return;
        }
        int NextPage = CurrentPage + 1;
        NextPage = CurrentPage < pageCount ? NextPage : CurrentPage;
        int Prevpage = CurrentPage - 1;
        Prevpage = CurrentPage > 1 ? Prevpage : CurrentPage;
        String prevCmd = "/" + cmd + " " + Prevpage;
        String prev = "\"\",{\"text\":\" " + Jobs.getLanguage().getMessage("command.help.output.prev") + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + prevCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + "<<<" + "\"}]}}}";
        String nextCmd = "/" + cmd + " " + NextPage;
        String next = " {\"text\":\"" + Jobs.getLanguage().getMessage("command.help.output.next") + " " + "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + nextCmd + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ">>>" + "\"}]}}}";
        if (CurrentPage >= pageCount) {
            next = "{\"text\":\"" + Jobs.getLanguage().getMessage("command.help.output.next") + " \"}";
        }
        if (CurrentPage <= 1) {
            prev = "{\"text\":\" " + Jobs.getLanguage().getMessage("command.help.output.prev") + "\"}";
        }
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + target + " [" + prev + "," + next + "]"));
    }

    public static String jobInfoMessage(JobsPlayer player, Job job, ActionType type) {
        Boost boost = Jobs.getPlayerManager().getFinalBonus(player, job);
        StringBuilder message = new StringBuilder();
        message.append(Jobs.getLanguage().getMessage("command.info.output." + type.getName().toLowerCase() + ".info"));
        message.append(":\n");
        int level = 1;
        JobProgression prog = player.getJobProgression(job);
        if (prog != null) {
            level = prog.getLevel();
        }
        int numjobs = player.getJobProgression().size();
        List<JobInfo> jobInfo = job.getJobInfo(type);
        for (JobInfo info2 : jobInfo) {
            String pointsColor;
            String materialName = info2.getName().toLowerCase().replace('_', ' ');
            materialName = String.valueOf(Character.toUpperCase(materialName.charAt(0))) + materialName.substring(1);
            materialName = Jobs.getNameTranslatorManager().Translate(materialName, info2);
            materialName = ChatColor.translateAlternateColorCodes((char)'&', (String)materialName);
            double income = info2.getIncome(level, numjobs);
            String incomeColor = (income = boost.getFinalAmount(CurrencyType.MONEY, income)) >= 0.0 ? "" : ChatColor.DARK_RED.toString();
            double xp = info2.getExperience(level, numjobs);
            xp = boost.getFinalAmount(CurrencyType.EXP, xp);
            String xpColor = xp >= 0.0 ? "" : ChatColor.GRAY.toString();
            double points2 = info2.getPoints(level, numjobs);
            points2 = boost.getFinalAmount(CurrencyType.POINTS, points2);
            String string = pointsColor = xp >= 0.0 ? "" : ChatColor.RED.toString();
            if (income == 0.0 && points2 == 0.0 && xp == 0.0) continue;
            message.append("  ");
            message.append(Jobs.getLanguage().getMessage("command.info.help.material", "%material%", materialName));
            if (prog != null && !info2.isInLevelRange(prog.getLevel())) {
                message.append(ChatColor.RED + " -> ");
            } else {
                message.append(" -> ");
            }
            if (income != 0.0) {
                message.append(Jobs.getLanguage().getMessage("command.info.help.money", "%money%", String.valueOf(incomeColor) + String.format("%.2f", income)));
            }
            if (points2 != 0.0) {
                message.append(Jobs.getLanguage().getMessage("command.info.help.points", "%points%", String.valueOf(pointsColor) + String.format("%.2f", points2)));
            }
            if (xp != 0.0) {
                message.append(Jobs.getLanguage().getMessage("command.info.help.exp", "%exp%", String.valueOf(xpColor) + String.format("%.2f", xp)));
            }
            if (info2.getFromLevel() > 1 && info2.getUntilLevel() != -1) {
                message.append(Jobs.getLanguage().getMessage("command.info.help.levelRange", "%levelFrom%", info2.getFromLevel(), "%levelUntil%", info2.getUntilLevel()));
            }
            if (info2.getFromLevel() > 1 && info2.getUntilLevel() == -1) {
                message.append(Jobs.getLanguage().getMessage("command.info.help.levelFrom", "%levelFrom%", info2.getFromLevel()));
            }
            if (info2.getFromLevel() == 1 && info2.getUntilLevel() != -1) {
                message.append(Jobs.getLanguage().getMessage("command.info.help.levelUntil", "%levelUntil%", info2.getUntilLevel()));
            }
            message.append('\n');
        }
        return message.toString();
    }

    public String jobStatsMessage(JobProgression jobProg) {
        String message = Jobs.getLanguage().getMessage("command.stats.output", "%joblevel%", Integer.valueOf(jobProg.getLevel()).toString(), "%jobname%", (Object)((Object)jobProg.getJob().getChatColor()) + jobProg.getJob().getName() + ChatColor.WHITE, "%jobxp%", Double.toString((double)Math.round(jobProg.getExperience() * 100.0) / 100.0), "%jobmaxxp%", Integer.toString(jobProg.getMaxExperience()));
        return " " + this.jobProgressMessage(jobProg.getMaxExperience(), jobProg.getExperience()) + " " + message;
    }

    public String jobProgressMessage(double max, double current) {
        String message = "";
        String pos = ChatColor.DARK_GREEN + "\u258f";
        String pros = ChatColor.YELLOW + "\u258f";
        if (current < 0.0) {
            current = 0.0;
        }
        if (max < current) {
            max = current;
        }
        int percentage = (int)(current * 50.0 / max);
        int i = 0;
        while (i < percentage) {
            message = String.valueOf(message) + pos;
            ++i;
        }
        if (50 - percentage < 0) {
            percentage = 50;
        }
        i = 0;
        while (i < 50 - percentage) {
            message = String.valueOf(message) + pros;
            ++i;
        }
        return message;
    }

    public String jobStatsMessage(String jobInfo) {
        String[] splited = jobInfo.split(":");
        if (Jobs.getJob(splited[0]) == null) {
            return "";
        }
        String message = Jobs.getLanguage().getMessage("command.archive.output", "%joblevel%", Integer.valueOf(splited[1]).toString(), "%getbackjoblevel%", Integer.valueOf(splited[2]).toString(), "%jobname%", (Object)((Object)Jobs.getJob(splited[0]).getChatColor()) + splited[0] + ChatColor.WHITE, "%jobxp%", Double.toString((double)Math.round(Double.valueOf(splited[3]) * 100.0) / 100.0));
        return message;
    }
}

