/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.api;

import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.container.Title;
import org.bukkit.Sound;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public final class JobsLevelUpEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private JobsPlayer player;
    private String JobName;
    private Title OldTitle;
    private Title NewTitle;
    private int level;
    private Sound soundLevelupSound = Sound.values()[0];
    private int soundLevelupVolume = 1;
    private int soundLevelupPitch = 3;
    private Sound soundTitleChangeSound = Sound.values()[0];
    private int soundTitleChangeVolume = 1;
    private int soundTitleChangePitch = 3;
    private boolean cancelled;

    public JobsLevelUpEvent(JobsPlayer jPlayer, String JobName, int level, Title OldTitle, Title NewTitle, String soundLevelupSound, Integer soundLevelupVolume, Integer soundLevelupPitch, String soundTitleChangeSound, Integer soundTitleChangeVolume, Integer soundTitleChangePitch) {
        this.player = jPlayer;
        this.JobName = JobName;
        this.OldTitle = OldTitle;
        this.NewTitle = NewTitle;
        this.level = level;
        this.soundLevelupSound = JobsLevelUpEvent.getSound(soundLevelupSound);
        this.soundLevelupVolume = soundLevelupVolume;
        this.soundLevelupPitch = soundLevelupPitch;
        this.soundTitleChangeSound = JobsLevelUpEvent.getSound(soundTitleChangeSound);
        this.soundTitleChangeVolume = soundTitleChangeVolume;
        this.soundTitleChangePitch = soundTitleChangePitch;
    }

    private static Sound getSound(String soundName) {
        Sound[] soundArray = Sound.values();
        int n = soundArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sound one = soundArray[n2];
            if (one.name().equalsIgnoreCase(soundName)) {
                return one;
            }
            ++n2;
        }
        return null;
    }

    public JobsPlayer getPlayer() {
        return this.player;
    }

    public String getJobName() {
        return this.JobName;
    }

    public Title getOldTitle() {
        return this.OldTitle;
    }

    public String getOldTitleName() {
        return this.OldTitle.getName();
    }

    public String getOldTitleShort() {
        return this.OldTitle.getShortName();
    }

    public String getOldTitleColor() {
        return this.OldTitle.getChatColor().toString();
    }

    public Title getNewTitle() {
        return this.NewTitle;
    }

    public String getNewTitleName() {
        return this.NewTitle.getName();
    }

    public String getNewTitleShort() {
        return this.NewTitle.getShortName();
    }

    public String getNewTitleColor() {
        return this.NewTitle.getChatColor().toString();
    }

    @Deprecated
    public String getSoundName() {
        return this.soundLevelupSound != null ? this.soundLevelupSound.name() : "";
    }

    public Sound getSound() {
        return this.soundLevelupSound == null ? Sound.values()[0] : this.soundLevelupSound;
    }

    public void setSound(Sound sound) {
        this.soundLevelupSound = sound;
    }

    public int getSoundVolume() {
        return this.soundLevelupVolume;
    }

    public void setSoundVolume(int volume) {
        this.soundLevelupVolume = volume;
    }

    public int getSoundPitch() {
        return this.soundLevelupPitch;
    }

    public void setSoundPitch(int pitch) {
        this.soundLevelupPitch = pitch;
    }

    @Deprecated
    public String getTitleChangeSoundName() {
        return this.soundTitleChangeSound != null ? this.soundTitleChangeSound.name() : "";
    }

    public Sound getTitleChangeSound() {
        return this.soundTitleChangeSound == null ? Sound.values()[0] : this.soundTitleChangeSound;
    }

    public void setTitleChangeSound(Sound sound) {
        this.soundTitleChangeSound = sound;
    }

    public int getTitleChangeVolume() {
        return this.soundTitleChangeVolume;
    }

    public void setTitleChangeVolume(int volume) {
        this.soundTitleChangeVolume = volume;
    }

    public int getTitleChangePitch() {
        return this.soundTitleChangePitch;
    }

    public void setTitleChangePitch(int pitch) {
        this.soundTitleChangePitch = pitch;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

