/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class PermissionManager {
    HashMap<String, Integer> permDelay = new HashMap();

    private int getDelay(String perm) {
        Integer delay = this.permDelay.get(perm);
        return delay == null ? 1 : delay;
    }

    public PermissionManager() {
        prm[] prmArray = prm.values();
        int n = prmArray.length;
        int n2 = 0;
        while (n2 < n) {
            prm one = prmArray[n2];
            for (String oneP : one.getPerms()) {
                this.permDelay.put(oneP, one.getDelay());
            }
            ++n2;
        }
    }

    private static HashMap<String, Boolean> getAll(Player player) {
        HashMap<String, Boolean> mine = new HashMap<String, Boolean>();
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            if (!permission.getPermission().startsWith("jobs.")) continue;
            mine.put(permission.getPermission(), permission.getValue());
        }
        return mine;
    }

    public Double getMaxPermission(JobsPlayer jPlayer, String perm) {
        return this.getMaxPermission(jPlayer, perm, false);
    }

    public Double getMaxPermission(JobsPlayer jPlayer, String perm, boolean force) {
        if (!(perm = perm.toLowerCase()).endsWith(".")) {
            perm = String.valueOf(perm) + ".";
        }
        if (jPlayer == null) {
            return 0.0;
        }
        if (jPlayer.getPlayer() == null) {
            return 0.0;
        }
        HashMap<String, Boolean> permissions = jPlayer.getPermissionsCache();
        if (force || permissions == null || (long)this.getDelay(perm) + jPlayer.getLastPermissionUpdate() < System.currentTimeMillis()) {
            permissions = PermissionManager.getAll(jPlayer.getPlayer());
            jPlayer.setPermissionsCache(permissions);
            jPlayer.setLastPermissionUpdate(System.currentTimeMillis());
        }
        Double amount = null;
        for (Map.Entry<String, Boolean> uno : permissions.entrySet()) {
            if (!uno.getKey().startsWith(perm)) continue;
            try {
                double t = Double.parseDouble(uno.getKey().replace(perm, ""));
                if (amount != null && !(t > amount)) continue;
                amount = t;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return amount;
    }

    public boolean hasPermission(JobsPlayer jPlayer, String perm) {
        Boolean resul;
        if (jPlayer == null) {
            return false;
        }
        if (jPlayer.getPlayer() == null) {
            return false;
        }
        HashMap<String, Boolean> permissions = jPlayer.getPermissionsCache();
        if (permissions == null || (long)this.getDelay(perm) + jPlayer.getLastPermissionUpdate() < System.currentTimeMillis()) {
            permissions = PermissionManager.getAll(jPlayer.getPlayer());
            jPlayer.setPermissionsCache(permissions);
            jPlayer.setLastPermissionUpdate(System.currentTimeMillis());
        }
        return (resul = permissions.get(perm)) == null ? false : resul;
    }

    private static enum prm {
        jobs_boost_JOBNAME_money_AMOUNT(prm.remade("jobs.boost.%JOBNAME%.money.%AMOUNT%"), 60000),
        jobs_boost_JOBNAME_exp_AMOUNT(prm.remade("jobs.boost.%JOBNAME%.exp.%AMOUNT%"), 60000),
        jobs_boost_JOBNAME_points_AMOUNT(prm.remade("jobs.boost.%JOBNAME%.points.%AMOUNT%"), 60000),
        jobs_boost_JOBNAME_all_AMOUNT(prm.remade("jobs.boost.%JOBNAME%.all.%AMOUNT%"), 60000),
        jobs_boost_all_money_AMOUNT(prm.remade("jobs.boost.all.money.%AMOUNT%"), 60000),
        jobs_boost_all_exp_AMOUNT(prm.remade("jobs.boost.all.exp.%AMOUNT%"), 60000),
        jobs_boost_all_points_AMOUNT(prm.remade("jobs.boost.all.points.%AMOUNT%"), 60000),
        jobs_boost_all_all_AMOUNT(prm.remade("jobs.boost.all.all.%AMOUNT%"), 60000),
        jobs_spawner_AMOUNT(prm.remade("jobs.nearspawner.%AMOUNT%"), 60000),
        jobs_petpay_AMOUNT(prm.remade("jobs.petpay.%AMOUNT%"), 60000);

        private int reload;
        private List<String> perms;

        private prm(List<String> perms, int reload2) {
            this.perms = perms;
            this.reload = reload2;
        }

        public int getDelay() {
            return this.reload;
        }

        private static List<String> remade(String perm) {
            String t;
            ArrayList<String> perms = new ArrayList<String>();
            for (Job oneJ : Jobs.getJobs()) {
                t = perm;
                if (t.contains("%JOBNAME%")) {
                    t = t.replace("%JOBNAME%", oneJ.getName().toLowerCase());
                }
                if (t.contains("%AMOUNT%")) {
                    t = t.replace("%AMOUNT%", "");
                }
                perms.add(t);
            }
            if (perm.contains("%WORLDNAME%")) {
                for (Job oneJ : Bukkit.getWorlds()) {
                    t = perm;
                    t = t.replace("%WORLDNAME%", oneJ.getName().toLowerCase());
                    perms.add(t);
                }
            }
            return perms;
        }

        public List<String> getPerms() {
            return this.perms;
        }
    }
}

