/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobConditions;
import com.gamingmesh.jobs.container.JobPermission;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class PermissionHandler {
    private Jobs plugin;

    public PermissionHandler(Jobs plugin) {
        this.plugin = plugin;
    }

    public void recalculatePermissions(JobsPlayer jPlayer) {
        if (jPlayer == null) {
            return;
        }
        Player player = jPlayer.getPlayer();
        if (player == null) {
            return;
        }
        boolean changed = false;
        String permName = "jobs.players." + player.getName();
        Permission permission = this.plugin.getServer().getPluginManager().getPermission(permName);
        if (permission != null) {
            this.plugin.getServer().getPluginManager().removePermission(permission);
            changed = true;
        }
        if (this.hasWorldPermission(player, player.getWorld().getName())) {
            List<JobProgression> progression = jPlayer.getJobProgression();
            HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
            if (progression.size() == 0) {
                Job job = Jobs.getNoneJob();
                if (job != null) {
                    for (JobPermission perm : job.getPermissions()) {
                        if (perm.getLevelRequirement() > 0) continue;
                        if (perm.isValue()) {
                            permissions.put(perm.getNode(), true);
                            continue;
                        }
                        if (permissions.containsKey(perm.getNode())) continue;
                        permissions.put(perm.getNode(), false);
                    }
                    for (JobConditions Condition : job.getConditions()) {
                        boolean ok = true;
                        for (String string : Condition.getRequiredPerm()) {
                            if (player.hasPermission(string)) continue;
                            ok = false;
                            break;
                        }
                        for (Map.Entry<String, Integer> entry : Condition.getRequiredJobs().entrySet()) {
                            String jobName = entry.getKey();
                            int jobLevel = entry.getValue();
                            boolean found = false;
                            for (JobProgression oneJob : jPlayer.getJobProgression()) {
                                if (oneJob.getJob().getName().equalsIgnoreCase(jobName)) {
                                    found = true;
                                }
                                if (!oneJob.getJob().getName().equalsIgnoreCase(jobName) || oneJob.getLevel() >= jobLevel) continue;
                                ok = false;
                                break;
                            }
                            if (found) continue;
                            ok = false;
                        }
                        if (!ok) continue;
                        for (Map.Entry<String, Boolean> entry : Condition.getPerformPerm().entrySet()) {
                            String perm = entry.getKey();
                            boolean node = entry.getValue();
                            if (node) {
                                permissions.put(perm, true);
                                continue;
                            }
                            if (permissions.containsKey(perm)) continue;
                            permissions.put(perm, false);
                        }
                    }
                }
            } else {
                for (JobProgression prog : progression) {
                    for (JobPermission perm : prog.getJob().getPermissions()) {
                        if (prog.getLevel() < perm.getLevelRequirement()) continue;
                        if (perm.isValue()) {
                            permissions.put(perm.getNode(), true);
                            continue;
                        }
                        if (permissions.containsKey(perm.getNode())) continue;
                        permissions.put(perm.getNode(), false);
                    }
                    for (JobConditions Condition : prog.getJob().getConditions()) {
                        boolean bl = true;
                        for (String string : Condition.getRequiredPerm()) {
                            if (player.hasPermission(string)) continue;
                            bl = false;
                            break;
                        }
                        for (Map.Entry entry : Condition.getRequiredJobs().entrySet()) {
                            String jobName = (String)entry.getKey();
                            int jobLevel = (Integer)entry.getValue();
                            boolean found = false;
                            for (JobProgression oneJob : jPlayer.getJobProgression()) {
                                if (oneJob.getJob().getName().equalsIgnoreCase(jobName)) {
                                    found = true;
                                }
                                if (!oneJob.getJob().getName().equalsIgnoreCase(jobName) || oneJob.getLevel() >= jobLevel) continue;
                                bl = false;
                                break;
                            }
                            if (found) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        for (Map.Entry entry : Condition.getPerformPerm().entrySet()) {
                            String perm = (String)entry.getKey();
                            boolean node = (Boolean)entry.getValue();
                            if (node) {
                                permissions.put(perm, true);
                                continue;
                            }
                            if (permissions.containsKey(perm)) continue;
                            permissions.put(perm, false);
                        }
                    }
                }
            }
            if (permissions.size() > 0) {
                this.plugin.getServer().getPluginManager().addPermission(new Permission(permName, PermissionDefault.FALSE, permissions));
                changed = true;
            }
        }
        if (!changed) {
            return;
        }
        PermissionAttachment attachment = null;
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getAttachment() == null || !(pai.getAttachment().getPlugin() instanceof Jobs)) continue;
            attachment = pai.getAttachment();
        }
        if (attachment == null) {
            attachment = player.addAttachment((Plugin)this.plugin);
            attachment.setPermission(permName, true);
        }
        player.recalculatePermissions();
    }

    public void registerPermissions() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        for (World world : this.plugin.getServer().getWorlds()) {
            if (pm.getPermission("jobs.world." + world.getName().toLowerCase()) != null) continue;
            pm.addPermission(new Permission("jobs.world." + world.getName().toLowerCase(), PermissionDefault.TRUE));
        }
        for (Job job : Jobs.getJobs()) {
            if (pm.getPermission("jobs.join." + job.getName().toLowerCase()) != null) continue;
            pm.addPermission(new Permission("jobs.join." + job.getName().toLowerCase(), PermissionDefault.TRUE));
        }
    }

    public boolean hasWorldPermission(Player player) {
        return this.hasWorldPermission(player, player.getWorld().getName());
    }

    public boolean hasWorldPermission(Player player, String world) {
        if (!player.hasPermission("jobs.use")) {
            return false;
        }
        return player.hasPermission("jobs.world." + world.toLowerCase());
    }

    public boolean hasWorldPermission(JobsPlayer player, String world) {
        if (!Jobs.getPermissionManager().hasPermission(player, "jobs.use")) {
            return false;
        }
        return Jobs.getPermissionManager().hasPermission(player, "jobs.world." + world.toLowerCase());
    }
}

