/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.economy.BlackholeEconomy;
import com.gamingmesh.jobs.economy.IConomy6Adapter;
import com.gamingmesh.jobs.economy.VaultEconomy;
import com.iCo6.iConomy;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class HookEconomyTask
implements Runnable {
    private Jobs plugin;

    public HookEconomyTask(Jobs plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        if (this.setVault()) {
            return;
        }
        if (this.setIConomy()) {
            return;
        }
        Jobs.setEconomy(this.plugin, new BlackholeEconomy());
        Bukkit.getServer().getLogger().severe("==================== " + this.plugin.getDescription().getName() + " ====================");
        Bukkit.getServer().getLogger().severe("Vault or Iconomy is required by this plugin for economy support!");
        Bukkit.getServer().getLogger().severe("Please install them first!");
        Bukkit.getServer().getLogger().severe("You can find the latest versions here:");
        Bukkit.getServer().getLogger().severe("http://dev.bukkit.org/bukkit-plugins/vault/");
        Bukkit.getServer().getLogger().severe("https://dev.bukkit.org/bukkit-plugins/iconomy-7/");
        Bukkit.getServer().getLogger().severe("==============================================");
    }

    private boolean setVault() {
        Plugin eco = Bukkit.getServer().getPluginManager().getPlugin("Vault");
        if (eco == null) {
            return false;
        }
        RegisteredServiceProvider provider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (provider == null) {
            return false;
        }
        Economy economy = (Economy)provider.getProvider();
        if (economy == null) {
            return false;
        }
        Jobs.setEconomy(this.plugin, new VaultEconomy(economy));
        Jobs.consoleMsg("&e[" + this.plugin.getDescription().getName() + "] Successfully linked with Vault.");
        return true;
    }

    private boolean setIConomy() {
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin("iConomy");
        if (p == null) {
            return false;
        }
        try {
            Jobs.setEconomy(this.plugin, new IConomy6Adapter((iConomy)p));
        }
        catch (Exception e) {
            Jobs.consoleMsg("&e[" + this.plugin.getDescription().getName() + "] UNKNOWN iConomy version.");
            return false;
        }
        Jobs.consoleMsg("&e[" + this.plugin.getDescription().getName() + "] Successfully linked with iConomy! Version: " + p.getDescription().getVersion());
        return true;
    }
}

