/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import net.coreprotect.CoreProtect;
import net.coreprotect.worldedit.CoreProtectLogger;
import org.bukkit.plugin.Plugin;

public class CoreProtectEditSessionEvent {
    private static boolean initialized = false;

    public static boolean isInitialized() {
        return initialized;
    }

    public static void register() {
        try {
            CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

                @Override
                public void run() {
                    try {
                        WorldEdit.getInstance().getEventBus().register((Object)new CoreProtectEditSessionEvent());
                        initialized = true;
                    }
                    catch (Exception e) {
                        System.out.println("[CoreProtect] Unable to initialize WorldEdit logging.");
                    }
                }
            }, 0L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe
    public void wrapForLogging(EditSessionEvent event) {
        Actor actor = event.getActor();
        World world = event.getWorld();
        if (actor != null && event.getStage().equals((Object)EditSession.Stage.BEFORE_CHANGE)) {
            event.setExtent((Extent)new CoreProtectLogger(actor, world, event.getExtent()));
        }
    }
}

