/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.consumer;

import java.util.ArrayList;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Queue {
    protected static void queueAdvancedBreak(String user, BlockState block, Material type, int data, Material break_type, int block_number) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 0, type, data, break_type, 0, block_number});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueArtInsert(int id, String name) {
        Location location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 22, null, 0, null, 0, id});
        Queue.queueStandardData(consumer_id, new String[]{name, null}, location);
    }

    protected static void queueBlockBreak(String user, BlockState block, Material type, int data) {
        Queue.queueBlockBreak(user, block, type, data, null, 0);
    }

    protected static void queueBlockBreak(String user, BlockState block, Material type, int data, Material break_type, int block_number) {
        if (type.equals((Object)Material.MOB_SPAWNER)) {
            CreatureSpawner mobSpawner = (CreatureSpawner)block;
            data = Functions.getSpawnerType(mobSpawner.getSpawnedType());
        } else if (type.equals((Object)Material.DOUBLE_PLANT) && data >= 8 && !user.startsWith("#")) {
            if (block_number == 5) {
                return;
            }
            block = block.getWorld().getBlockAt(block.getX(), block.getY() - 1, block.getZ()).getState();
            data = Functions.getData(block);
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 0, type, data, break_type, 0, block_number});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueBlockPlace(Player player, BlockState final_placed, Block placed, BlockState replaced, Material force_t, int force_d) {
        Queue.queueBlockPlace(player.getName(), final_placed, placed, replaced, force_t, force_d, 0);
    }

    protected static void queueBlockPlace(String player, Block placed) {
        Queue.queueBlockPlace(player, placed.getState(), placed, null, null, -1, 0);
    }

    protected static void queueBlockPlace(String player, Block placed, BlockState replaced, int force) {
        Queue.queueBlockPlace(player, placed.getState(), placed, replaced, null, -1, force);
    }

    protected static void queueBlockPlace(String user, Block placed, BlockState replaced, Material type, int data) {
        Queue.queueBlockPlace(user, placed.getState(), placed, replaced, type, data, 1);
    }

    protected static void queueBlockPlace(String user, BlockState block_location, Block block_type, BlockState block_replaced, Material force_t, int force_d, int force_data) {
        Material type = block_type.getType();
        int data = Functions.getData(block_type);
        Material replace_type = null;
        byte replace_data = 0;
        if (type.equals((Object)Material.MOB_SPAWNER)) {
            CreatureSpawner mobSpawner = (CreatureSpawner)block_location;
            data = Functions.getSpawnerType(mobSpawner.getSpawnedType());
            force_data = 1;
        }
        if (block_replaced != null) {
            replace_type = block_replaced.getType();
            replace_data = Functions.getData(block_replaced);
            if (replace_type.equals((Object)Material.DOUBLE_PLANT) && replace_data >= 8) {
                BlockState block_below = block_replaced.getWorld().getBlockAt(block_replaced.getX(), block_replaced.getY() - 1, block_replaced.getZ()).getState();
                Material below_type = block_below.getType();
                byte below_data = Functions.getData(block_below);
                Queue.queueBlockBreak(user, block_below, below_type, below_data);
            }
        }
        if (force_t != null) {
            type = force_t;
            force_data = 1;
        }
        if (force_d != -1) {
            data = force_d;
            force_data = 1;
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 1, type, data, replace_type, (int)replace_data, force_data});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block_location);
    }

    protected static void queueBlockPlace(String user, BlockState placed, BlockState replaced, Material force_type) {
        Queue.queueBlockPlace(user, placed, placed.getBlock(), replaced, force_type, -1, 0);
    }

    protected static void queueBlockPlace(String player, BlockState placed, BlockState replaced, Material type, int data) {
        Queue.queueBlockPlace(player, placed, placed.getBlock(), replaced, type, data, 1);
    }

    protected static void queueBlockPlace(String player, BlockState placed, Material type, int data) {
        Queue.queueBlockPlace(player, placed, placed.getBlock(), null, type, data, 1);
    }

    protected static void queueBlockPlaceDelayed(final String user, final Block placed, final BlockState replaced, int ticks) {
        CoreProtect.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)CoreProtect.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    Queue.queueBlockPlace(user, placed.getState(), placed, replaced, null, -1, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long)ticks);
    }

    protected static void queueContainerBreak(String user, BlockState block, Material type, ItemStack[] old_inventory) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 3, null, 0, null, 0, 0});
        Consumer.consumer_containers.get(Consumer.current_consumer).put(consumer_id, old_inventory);
        block.setType(type);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueContainerRollbackUpdate(String user, Location location, List<Object[]> list, int action) {
        if (location == null) {
            location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 8, null, 0, null, 0, action});
        Consumer.consumer_object_array_list.get(Consumer.current_consumer).put(consumer_id, list);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, location);
    }

    protected static void queueContainerTransaction(String user, BlockState block, Material type, Object inventory, int chest_id) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 5, null, 0, null, 0, chest_id});
        Consumer.consumer_inventories.get(Consumer.current_consumer).put(consumer_id, inventory);
        block.setType(type);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueEntityInsert(int id, String name) {
        Location location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 23, null, 0, null, 0, id});
        Queue.queueStandardData(consumer_id, new String[]{name, null}, location);
    }

    protected static void queueEntityKill(String user, Location location, List<Object> data, EntityType type) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 16, null, 0, null, 0, 0});
        Consumer.consumer_object_list.get(Consumer.current_consumer).put(consumer_id, data);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, new Object[]{location.getBlock().getState(), type});
    }

    protected static void queueEntitySpawn(String user, BlockState block, EntityType type, int data) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 17, null, 0, null, 0, data});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, new Object[]{block, type});
    }

    protected static void queueHangingRemove(String user, BlockState block, int delay) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 18, null, 0, null, 0, delay});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueHangingSpawn(String user, BlockState block, Material type, int data, int delay) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 19, type, data, null, 0, delay});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueMaterialInsert(int id, String name) {
        Location location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 21, null, 0, null, 0, id});
        Queue.queueStandardData(consumer_id, new String[]{name, null}, location);
    }

    protected static void queueNaturalBlockBreak(String user, BlockState block, Block relative, Material type, int data) {
        ArrayList<BlockState> relative_list = new ArrayList<BlockState>();
        if (relative != null) {
            relative_list.add(relative.getState());
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 20, type, data, null, 0, 0});
        Consumer.consumer_block_list.get(Consumer.current_consumer).put(consumer_id, relative_list);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queuePlayerChat(Player player, String message, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 12, null, 0, null, 0, time});
        Consumer.consumer_strings.get(Consumer.current_consumer).put(consumer_id, message);
        Queue.queueStandardData(consumer_id, new String[]{player.getName(), null}, player.getLocation());
    }

    protected static void queuePlayerCommand(Player player, String message, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 13, null, 0, null, 0, time});
        Consumer.consumer_strings.get(Consumer.current_consumer).put(consumer_id, message);
        Queue.queueStandardData(consumer_id, new String[]{player.getName(), null}, player.getLocation().getBlock().getState());
    }

    protected static void queuePlayerInteraction(String user, BlockState block) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 4, null, 0, null, 0, 0});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queuePlayerKill(String user, Location location, String player) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 24, null, 0, null, 0, 0});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, new Object[]{location.getBlock().getState(), player});
    }

    protected static void queuePlayerLogin(Player player, int time, int configSessions, int configUsernames) {
        int consumer_id = Consumer.getConsumerId();
        String uuid = player.getUniqueId().toString();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 14, null, configSessions, null, configUsernames, time});
        Consumer.consumer_strings.get(Consumer.current_consumer).put(consumer_id, uuid);
        Queue.queueStandardData(consumer_id, new String[]{player.getName(), uuid}, player.getLocation().getBlock().getState());
    }

    protected static void queuePlayerQuit(Player player, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 15, null, 0, null, 0, time});
        Queue.queueStandardData(consumer_id, new String[]{player.getName(), null}, player.getLocation().getBlock().getState());
    }

    protected static void queueRollbackUpdate(String user, Location location, List<Object[]> list, int action) {
        if (location == null) {
            location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        }
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 7, null, 0, null, 0, action});
        Consumer.consumer_object_array_list.get(Consumer.current_consumer).put(consumer_id, list);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, location);
    }

    protected static void queueSignText(String user, BlockState block, String line1, String line2, String line3, String line4, int offset) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 2, null, 0, null, 0, offset});
        Consumer.consumer_signs.get(Consumer.current_consumer).put(consumer_id, new String[]{line1, line2, line3, line4});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueSignUpdate(String user, BlockState block, int action, int time) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 10, null, action, null, 0, time});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueSkullUpdate(String user, BlockState block, int row_id) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 11, null, 0, null, 0, row_id});
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    private static void queueStandardData(int consumer_id, String[] user, Object object) {
        Consumer.consumer_users.get(Consumer.current_consumer).put(consumer_id, user);
        Consumer.consumer_object.get(Consumer.current_consumer).put(consumer_id, object);
        Consumer.consumer_id.put(Consumer.current_consumer, consumer_id + 1);
    }

    protected static void queueStructureGrow(String user, BlockState block, List<BlockState> block_list) {
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 6, null, 0, null, 0, 0});
        Consumer.consumer_block_list.get(Consumer.current_consumer).put(consumer_id, block_list);
        Queue.queueStandardData(consumer_id, new String[]{user, null}, block);
    }

    protected static void queueWorldInsert(int id, String world) {
        Location location = new Location((World)CoreProtect.getInstance().getServer().getWorlds().get(0), 0.0, 0.0, 0.0);
        int consumer_id = Consumer.getConsumerId();
        Consumer.consumer.get(Consumer.current_consumer).add(new Object[]{consumer_id, 9, null, 0, null, 0, id});
        Queue.queueStandardData(consumer_id, new String[]{world, null}, location);
    }
}

