/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.command.LookupCommand;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class RollbackRestoreCommand {
    protected static void runCommand(CommandSender player, boolean permission, String[] args, int force_seconds) {
        Location lo = CommandHandler.parseLocation(player, args);
        ArrayList arg_uuids = new ArrayList();
        List<String> arg_users = CommandHandler.parseUsers(args);
        Integer[] arg_radius = CommandHandler.parseRadius(args, player, lo);
        int arg_noisy = CommandHandler.parseNoisy(args);
        List<Object> arg_exclude = CommandHandler.parseExcluded(player, args);
        List<String> arg_exclude_users = CommandHandler.parseExcludedUsers(player, args);
        List<Object> arg_blocks = CommandHandler.parseRestricted(player, args);
        String ts = CommandHandler.parseTimeString(args);
        int rbseconds = CommandHandler.parseTime(args);
        int arg_wid = CommandHandler.parseWorld(args);
        List<Integer> arg_action = CommandHandler.parseAction(args);
        boolean count = CommandHandler.parseCount(args);
        boolean worldedit = CommandHandler.parseWorldEdit(args);
        boolean forceglobal = CommandHandler.parseForceGlobal(args);
        int preview = CommandHandler.parsePreview(args);
        String corecommand = args[0].toLowerCase();
        if (arg_blocks == null || arg_exclude == null || arg_exclude_users == null) {
            return;
        }
        if (arg_action.size() == 0 && arg_blocks.size() > 0) {
            for (Object arg_block : arg_blocks) {
                if (arg_block instanceof Material) {
                    arg_action.add(0);
                    arg_action.add(1);
                    continue;
                }
                if (!(arg_block instanceof EntityType)) continue;
                arg_action.add(3);
            }
        }
        if (count) {
            LookupCommand.runCommand(player, permission, args);
            return;
        }
        if (Config.converter_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
            return;
        }
        if (Config.purge_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
            return;
        }
        if (arg_wid == -1) {
            String world_name = CommandHandler.parseWorldName(args);
            player.sendMessage("\u00a73CoreProtect \u00a7f- World \"" + world_name + "\" not found.");
            return;
        }
        if (preview > 0 && !(player instanceof Player)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You can only preview rollbacks in-game.");
            return;
        }
        if (arg_action.contains(-1)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- That is not a valid action.");
            return;
        }
        if (worldedit && arg_radius == null) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- WorldEdit selection not found.");
            return;
        }
        if (arg_radius != null && arg_radius[0] == -1) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please enter a valid radius.");
            return;
        }
        if (Config.active_rollbacks.get(player.getName()) != null) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- A rollback/restore is already in progress.");
            return;
        }
        if (preview > 1 && force_seconds <= 0) {
            preview = 1;
        }
        if (permission) {
            int a = 0;
            if (corecommand.equals("restore") || corecommand.equals("rs") || corecommand.equals("re")) {
                a = 1;
            }
            final int final_action = a;
            int default_radius = Config.config.get("default-radius");
            if ((player instanceof Player || player instanceof BlockCommandSender) && arg_radius == null && default_radius > 0 && !forceglobal) {
                Location location = lo;
                int xmin = location.getBlockX() - default_radius;
                int xmax = location.getBlockX() + default_radius;
                int zmin = location.getBlockZ() - default_radius;
                int zmax = location.getBlockZ() + default_radius;
                arg_radius = new Integer[]{default_radius, xmin, xmax, -1, -1, zmin, zmax, 0};
            }
            boolean g = true;
            if (arg_users.contains("#global") && arg_radius == null) {
                g = false;
            }
            if (arg_users.size() == 0 && arg_wid > 0) {
                if (final_action == 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a rollback user.");
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a restore user.");
                }
                return;
            }
            if (g && (arg_users.size() > 0 || arg_users.size() == 0 && arg_radius != null)) {
                int radius_value;
                int max_radius = Config.config.get("max-radius");
                if (arg_radius != null && (radius_value = arg_radius[0].intValue()) > max_radius && max_radius > 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- The maximum " + corecommand.toLowerCase() + " radius is " + max_radius + ".");
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Use \"r:#global\" to do a global " + corecommand.toLowerCase() + ".");
                    return;
                }
                if (arg_action.size() > 0) {
                    if (arg_action.contains(4)) {
                        if (arg_users.contains("#global") || arg_users.size() == 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- To use that action, please specify a user.");
                            return;
                        }
                        if (preview > 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- You can't preview container transactions.");
                            return;
                        }
                    } else if (!(arg_action.contains(0) || arg_action.contains(1) || arg_action.contains(3))) {
                        if (final_action == 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- That action can't be used with a rollback.");
                        } else {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- That action can't be used with a restore.");
                        }
                        return;
                    }
                }
                if (arg_users.size() == 0) {
                    arg_users.add("#global");
                }
                List<String> rollbackusers = arg_users;
                int c = 0;
                for (String ruser : rollbackusers) {
                    List players = CoreProtect.getInstance().getServer().matchPlayer(ruser);
                    for (Player p : players) {
                        if (!p.getName().equalsIgnoreCase(ruser)) continue;
                        rollbackusers.set(c, p.getName());
                    }
                    ++c;
                }
                int wid = 0;
                int x = 0;
                int y = 0;
                int z = 0;
                if (rollbackusers.contains("#container")) {
                    boolean valid = false;
                    if (Config.lookup_type.get(player.getName()) != null) {
                        int lookup_type = Config.lookup_type.get(player.getName());
                        if (lookup_type == 1) {
                            valid = true;
                        } else if (lookup_type == 5 && Config.lookup_ulist.get(player.getName()).contains("#container")) {
                            valid = true;
                        }
                    }
                    if (valid) {
                        if (preview > 0) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- You can't preview container transactions.");
                            return;
                        }
                        String lcommand = Config.lookup_command.get(player.getName());
                        String[] data = lcommand.split("\\.");
                        x = Integer.parseInt(data[0]);
                        y = Integer.parseInt(data[1]);
                        z = Integer.parseInt(data[2]);
                        wid = Integer.parseInt(data[3]);
                        arg_action.add(5);
                        arg_radius = null;
                        arg_wid = 0;
                        lo = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(wid)), (double)x, (double)y, (double)z);
                        Block block = lo.getBlock();
                        if (block.getState() instanceof Chest) {
                            BlockFace[] block_sides;
                            for (BlockFace face : block_sides = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
                                if (!(block.getRelative(face, 1).getState() instanceof Chest)) continue;
                                Block relative = block.getRelative(face, 1);
                                int x2 = relative.getX();
                                int z2 = relative.getZ();
                                double new_x = (double)(x + x2) / 2.0;
                                double new_z = (double)(z + z2) / 2.0;
                                lo.setX(new_x);
                                lo.setZ(new_z);
                                break;
                            }
                        }
                    } else {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- Please inspect a valid container first.");
                        return;
                    }
                }
                final List<String> rollbackusers2 = rollbackusers;
                if (rbseconds > 0) {
                    int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                    int seconds = unixtimestamp - rbseconds;
                    if (force_seconds > 0) {
                        seconds = force_seconds;
                    }
                    final int stime = seconds;
                    final Integer[] radius = arg_radius;
                    try {
                        final CommandSender player2 = player;
                        final int noisy = arg_noisy;
                        final String rtime = ts;
                        final ArrayList uuid_list = arg_uuids;
                        final List<Object> blist = arg_blocks;
                        final List<Object> elist = arg_exclude;
                        final List<String> euserlist = arg_exclude_users;
                        final Location location_final = lo;
                        final int final_arg_wid = arg_wid;
                        final List<Integer> final_arg_action = arg_action;
                        final String[] final_args = args;
                        final int final_preview = preview;
                        Config.active_rollbacks.put(player.getName(), true);
                        class BasicThread2
                        implements Runnable {
                            BasicThread2() {
                            }

                            @Override
                            public void run() {
                                try {
                                    int action = final_action;
                                    Location location = location_final;
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String baduser = "";
                                        boolean exists = false;
                                        for (String check : rollbackusers2) {
                                            if (!check.equals("#global") && !check.equals("#container")) {
                                                exists = Lookup.playerExists(connection, check);
                                                if (exists) continue;
                                                baduser = check;
                                                break;
                                            }
                                            exists = true;
                                        }
                                        if (exists) {
                                            for (String check : euserlist) {
                                                if (!check.equals("#global")) {
                                                    exists = Lookup.playerExists(connection, check);
                                                    if (exists) continue;
                                                    baduser = check;
                                                    break;
                                                }
                                                baduser = "#global";
                                                exists = false;
                                            }
                                        }
                                        if (exists) {
                                            boolean restrict_world = false;
                                            if (radius != null) {
                                                restrict_world = true;
                                            }
                                            if (location == null) {
                                                restrict_world = false;
                                            }
                                            if (final_arg_wid > 0) {
                                                restrict_world = true;
                                                location = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(final_arg_wid)), 0.0, 0.0, 0.0);
                                            }
                                            boolean verbose = false;
                                            if (noisy == 1) {
                                                verbose = true;
                                            }
                                            String users = "";
                                            for (String value : rollbackusers2) {
                                                if (users.length() == 0) {
                                                    users = "" + value + "";
                                                    continue;
                                                }
                                                users = users + ", " + value;
                                            }
                                            if (users.equals("#global") && restrict_world) {
                                                users = "#" + location.getWorld().getName();
                                            }
                                            if (final_preview == 2) {
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Cancelling preview...");
                                            } else if (final_preview == 1) {
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Preview started on \"" + users + "\".");
                                            } else if (action == 0) {
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Rollback started on \"" + users + "\".");
                                            } else {
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Restore started on \"" + users + "\".");
                                            }
                                            if (final_arg_action.contains(5)) {
                                                Lookup.performContainerRollbackRestore(statement, player2, uuid_list, rollbackusers2, rtime, blist, elist, euserlist, final_arg_action, location, radius, stime, restrict_world, false, verbose, action);
                                            } else {
                                                Lookup.performRollbackRestore(statement, player2, uuid_list, rollbackusers2, rtime, blist, elist, euserlist, final_arg_action, location, radius, stime, restrict_world, false, verbose, action, final_preview);
                                                if (final_preview < 2) {
                                                    ArrayList<Object[]> list = new ArrayList<Object[]>();
                                                    list.add(new Object[]{stime});
                                                    list.add(final_args);
                                                    Config.last_rollback.put(player2.getName(), list);
                                                }
                                            }
                                        } else {
                                            player2.sendMessage("\u00a73CoreProtect \u00a7f- User \"" + baduser + "\" not found.");
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (Config.active_rollbacks.get(player2.getName()) != null) {
                                    Config.active_rollbacks.remove(player2.getName());
                                }
                            }
                        }
                        BasicThread2 runnable = new BasicThread2();
                        Thread thread = new Thread(runnable);
                        thread.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (final_action == 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please specify the amount of time to rollback.");
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please specify the amount of time to restore.");
                }
            } else if (final_action == 0) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a rollback radius.");
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You did not specify a restore radius.");
            }
        } else {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
        }
    }
}

