/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.sql.Connection;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.Config;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class LookupCommand {
    protected static void runCommand(CommandSender player, boolean permission, String[] args) {
        String bid;
        int resultc = args.length;
        Location lo = CommandHandler.parseLocation(player, args);
        List<String> arg_users = CommandHandler.parseUsers(args);
        Integer[] arg_radius = CommandHandler.parseRadius(args, player, lo);
        int arg_noisy = CommandHandler.parseNoisy(args);
        List<String> arg_exclude_users = CommandHandler.parseExcludedUsers(player, args);
        List<Object> arg_exclude = CommandHandler.parseExcluded(player, args);
        List<Object> arg_blocks = CommandHandler.parseRestricted(player, args);
        String ts = CommandHandler.parseTimeString(args);
        int rbseconds = CommandHandler.parseTime(args);
        int arg_wid = CommandHandler.parseWorld(args);
        List<Integer> arg_action = CommandHandler.parseAction(args);
        boolean count = CommandHandler.parseCount(args);
        boolean worldedit = CommandHandler.parseWorldEdit(args);
        boolean page_lookup = false;
        if (arg_blocks == null || arg_exclude == null || arg_exclude_users == null) {
            return;
        }
        int arg_excluded = arg_exclude.size();
        int arg_restricted = arg_blocks.size();
        if (arg_action.size() == 0 && arg_blocks.size() > 0) {
            for (Object arg_block : arg_blocks) {
                if (arg_block instanceof Material) {
                    arg_action.add(0);
                    arg_action.add(1);
                    continue;
                }
                if (!(arg_block instanceof EntityType)) continue;
                arg_action.add(3);
            }
        }
        if (arg_wid == -1) {
            String world_name = CommandHandler.parseWorldName(args);
            player.sendMessage("\u00a73CoreProtect \u00a7f- World \"" + world_name + "\" not found.");
            return;
        }
        int type = 0;
        if (Config.lookup_type.get(player.getName()) != null) {
            type = Config.lookup_type.get(player.getName());
        }
        if (type == 0 && resultc > 1) {
            type = 4;
        } else if (resultc > 2) {
            type = 4;
        } else if (resultc > 1) {
            page_lookup = true;
            String dat = args[1];
            if (dat.contains(":")) {
                String[] split = dat.split(":");
                String check1 = split[0].replaceAll("[^a-zA-Z_]", "");
                String check2 = "";
                if (split.length > 1) {
                    check2 = split[1].replaceAll("[^a-zA-Z_]", "");
                }
                if (check1.length() > 0 || check2.length() > 0) {
                    type = 4;
                    page_lookup = false;
                }
            } else {
                String check1 = dat.replaceAll("[^a-zA-Z_]", "");
                if (check1.length() > 0) {
                    type = 4;
                    page_lookup = false;
                }
            }
        }
        if (arg_action.contains(6) || arg_action.contains(7) || arg_action.contains(8) || arg_action.contains(9)) {
            page_lookup = true;
        }
        if (!(permission || page_lookup && player.hasPermission("coreprotect.inspect"))) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
            return;
        }
        if (Config.converter_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
            return;
        }
        if (Config.purge_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
            return;
        }
        if (resultc < 2) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co l <params>\".");
            return;
        }
        if (arg_action.contains(-1)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- That is not a valid action.");
            return;
        }
        if (worldedit && arg_radius == null) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- WorldEdit selection not found.");
            return;
        }
        if (arg_radius != null && arg_radius[0] == -1) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please enter a valid radius.");
            return;
        }
        boolean allPermission = false;
        if (player.isOp()) {
            allPermission = true;
        }
        if (!allPermission) {
            if (!page_lookup && (arg_action.size() == 0 || arg_action.contains(0) || arg_action.contains(1)) && !player.hasPermission("coreprotect.lookup.block")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(2) && !player.hasPermission("coreprotect.lookup.click")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(3) && !player.hasPermission("coreprotect.lookup.kill")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(4) && !player.hasPermission("coreprotect.lookup.container")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(6) && !player.hasPermission("coreprotect.lookup.chat")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(7) && !player.hasPermission("coreprotect.lookup.command")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(8) && !player.hasPermission("coreprotect.lookup.session")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
            if (arg_action.contains(9) && !player.hasPermission("coreprotect.lookup.username")) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                return;
            }
        }
        if (arg_action.contains(6) || arg_action.contains(7) || arg_action.contains(8) || arg_action.contains(9)) {
            if (!arg_action.contains(8) && (arg_radius != null || arg_wid > 0 || worldedit)) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- \"r:\" can't be used with that action.");
                return;
            }
            if (arg_blocks.size() > 0) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- \"b:\" can't be used with that action.");
                return;
            }
            if (arg_exclude.size() > 0) {
                player.sendMessage("\u00a73CoreProtect \u00a7f- \"e:\" can't be used with that action.");
                return;
            }
        }
        if (resultc > 2 && ((bid = args[1]).equalsIgnoreCase("type") || bid.equalsIgnoreCase("id"))) {
            type = 6;
        }
        if (!(rbseconds > 0 || page_lookup || type != 4 || arg_blocks.size() <= 0 && arg_users.size() <= 0)) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please specify the amount of time to lookup.");
            return;
        }
        if (type == 1) {
            String[] data;
            boolean default_re = true;
            int p = 0;
            int re = 7;
            if (resultc > 1) {
                int pa;
                String pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        default_re = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && (pa = Integer.parseInt(pages)) > 0) {
                    p = pa;
                }
            }
            if (p <= 0) {
                p = 1;
            }
            String lcommand = Config.lookup_command.get(player.getName());
            data = lcommand.split("\\.");
            int x = Integer.parseInt(data[0]);
            int y = Integer.parseInt(data[1]);
            int z = Integer.parseInt(data[2]);
            int wid = Integer.parseInt(data[3]);
            int x2 = Integer.parseInt(data[4]);
            int y2 = Integer.parseInt(data[5]);
            int z2 = Integer.parseInt(data[6]);
            if (default_re) {
                re = Integer.parseInt(data[7]);
            }
            String bc = x + "." + y + "." + z + "." + wid + "." + x2 + "." + y2 + "." + z2 + "." + re;
            Config.lookup_command.put(player.getName(), bc);
            String world = Functions.getWorldName(wid);
            double dx = 0.5 * (double)(x + x2);
            double dy = 0.5 * (double)(y + y2);
            double dz = 0.5 * (double)(z + z2);
            final Location location = new Location(CoreProtect.getInstance().getServer().getWorld(world), dx, dy, dz);
            final CommandSender player2 = player;
            final int p2 = p;
            final int final_limit = re;
            class BasicThread
            implements Runnable {
                BasicThread() {
                }

                @Override
                public void run() {
                    try {
                        Connection connection = Database.getConnection(false);
                        if (connection != null) {
                            Statement statement = connection.createStatement();
                            String blockdata = Lookup.chest_transactions(statement, location, player2.getName(), p2, final_limit);
                            if (blockdata.contains("\n")) {
                                for (String b : blockdata.split("\n")) {
                                    player2.sendMessage(b);
                                }
                            } else {
                                player2.sendMessage(blockdata);
                            }
                            statement.close();
                            connection.close();
                        } else {
                            player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BasicThread runnable = new BasicThread();
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (type == 2 || type == 3 || type == 7) {
            boolean default_re = true;
            int page = 1;
            int re = 7;
            if (resultc > 1) {
                int p;
                String pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    String[] data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        default_re = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && (p = Integer.parseInt(pages)) > 0) {
                    page = p;
                }
            }
            String lcommand = Config.lookup_command.get(player.getName());
            String[] data = lcommand.split("\\.");
            int x = Integer.parseInt(data[0]);
            int y = Integer.parseInt(data[1]);
            int z = Integer.parseInt(data[2]);
            int wid = Integer.parseInt(data[3]);
            int lookup_type = Integer.parseInt(data[4]);
            if (default_re) {
                re = Integer.parseInt(data[5]);
            }
            String bc = x + "." + y + "." + z + "." + wid + "." + lookup_type + "." + re;
            Config.lookup_command.put(player.getName(), bc);
            String world = Functions.getWorldName(wid);
            final Block fblock = CoreProtect.getInstance().getServer().getWorld(world).getBlockAt(x, y, z);
            final CommandSender player2 = player;
            final int p2 = page;
            final int final_limit = re;
            final int t = type;
            class BasicThread
            implements Runnable {
                BasicThread() {
                }

                @Override
                public void run() {
                    try {
                        Connection connection = Database.getConnection(false);
                        if (connection != null) {
                            Statement statement = connection.createStatement();
                            String blockdata = null;
                            blockdata = t == 7 ? Lookup.interaction_lookup(statement, fblock, player2.getName(), 0, p2, final_limit) : Lookup.block_lookup(statement, fblock, player2.getName(), 0, p2, final_limit);
                            if (blockdata.contains("\n")) {
                                for (String b : blockdata.split("\n")) {
                                    player2.sendMessage(b);
                                }
                            } else if (blockdata.length() > 0) {
                                player2.sendMessage(blockdata);
                            }
                            statement.close();
                            connection.close();
                        } else {
                            player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BasicThread runnable = new BasicThread();
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (type == 4 || type == 5) {
            boolean default_re = true;
            int pa = 1;
            int re = 4;
            if (arg_action.contains(6) || arg_action.contains(7) || arg_action.contains(9)) {
                re = 7;
            }
            if (type == 5 && resultc > 1) {
                int p;
                String pages = args[1];
                if (pages.contains(":")) {
                    int r;
                    String[] data = pages.split(":");
                    pages = data[0];
                    String results = "";
                    if (data.length > 1) {
                        results = data[1];
                    }
                    if ((results = results.replaceAll("[^0-9]", "")).length() > 0 && (r = Integer.parseInt(results)) > 0) {
                        re = r;
                        default_re = false;
                    }
                }
                if ((pages = pages.replaceAll("[^0-9]", "")).length() > 0 && (p = Integer.parseInt(pages)) > 0) {
                    pa = p;
                }
            }
            boolean g = true;
            if (arg_users.contains("#global") && arg_radius == null) {
                g = false;
            }
            if (g && (page_lookup || arg_blocks.size() > 0 || arg_users.size() > 0 || arg_users.size() == 0 && arg_radius != null)) {
                int radius_value;
                int max_radius = Config.config.get("max-radius");
                if (arg_radius != null && (radius_value = arg_radius[0].intValue()) > max_radius && max_radius > 0) {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- The maximum lookup radius is " + max_radius + ".");
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Don't specify a radius to do a global lookup.");
                    return;
                }
                if (arg_users.size() == 0) {
                    arg_users.add("#global");
                }
                List<String> rollbackusers = arg_users;
                int c = 0;
                for (String ruser : rollbackusers) {
                    List players = CoreProtect.getInstance().getServer().matchPlayer(ruser);
                    for (Player p : players) {
                        if (!p.getName().equalsIgnoreCase(ruser)) continue;
                        rollbackusers.set(c, p.getName());
                    }
                    ++c;
                }
                int cs = -1;
                int x = 0;
                int y = 0;
                int z = 0;
                int wid = 0;
                if (type == 5) {
                    String lcommand = Config.lookup_command.get(player.getName());
                    String[] data = lcommand.split("\\.");
                    x = Integer.parseInt(data[0]);
                    y = Integer.parseInt(data[1]);
                    z = Integer.parseInt(data[2]);
                    wid = Integer.parseInt(data[3]);
                    cs = Integer.parseInt(data[4]);
                    arg_noisy = Integer.parseInt(data[5]);
                    arg_excluded = Integer.parseInt(data[6]);
                    arg_restricted = Integer.parseInt(data[7]);
                    arg_wid = Integer.parseInt(data[8]);
                    if (default_re) {
                        re = Integer.parseInt(data[9]);
                    }
                    rollbackusers = Config.lookup_ulist.get(player.getName());
                    arg_blocks = Config.lookup_blist.get(player.getName());
                    arg_exclude = Config.lookup_elist.get(player.getName());
                    arg_exclude_users = Config.lookup_e_userlist.get(player.getName());
                    arg_action = Config.lookup_alist.get(player.getName());
                    arg_radius = Config.lookup_radius.get(player.getName());
                    ts = Config.lookup_time.get(player.getName());
                    rbseconds = 1;
                } else {
                    if (lo != null) {
                        x = lo.getBlockX();
                        z = lo.getBlockZ();
                        wid = Functions.getWorldId(lo.getWorld().getName());
                    }
                    if (rollbackusers.contains("#container")) {
                        if (arg_action.contains(6) || arg_action.contains(7) || arg_action.contains(8) || arg_action.contains(9)) {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- \"#container\" is an invalid username.");
                            return;
                        }
                        boolean valid = false;
                        if (Config.lookup_type.get(player.getName()) != null) {
                            int lookup_type = Config.lookup_type.get(player.getName());
                            if (lookup_type == 1) {
                                valid = true;
                            } else if (lookup_type == 5 && Config.lookup_ulist.get(player.getName()).contains("#container")) {
                                valid = true;
                            }
                        }
                        if (valid) {
                            if (!player.hasPermission("coreprotect.lookup.container") && !allPermission) {
                                player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
                                return;
                            }
                            String lcommand = Config.lookup_command.get(player.getName());
                            String[] data = lcommand.split("\\.");
                            x = Integer.parseInt(data[0]);
                            y = Integer.parseInt(data[1]);
                            z = Integer.parseInt(data[2]);
                            wid = Integer.parseInt(data[3]);
                            arg_action.add(5);
                            arg_radius = null;
                            arg_wid = 0;
                        } else {
                            player.sendMessage("\u00a73CoreProtect \u00a7f- Please inspect a valid container first.");
                            return;
                        }
                    }
                }
                final List<String> rollbackusers2 = rollbackusers;
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                if (cs == -1) {
                    cs = rbseconds <= 0 ? 0 : unixtimestamp - rbseconds;
                }
                final int stime = cs;
                final Integer[] radius = arg_radius;
                try {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Lookup searching. Please wait...");
                    final CommandSender player2 = player;
                    final int final_x = x;
                    final int final_y = y;
                    final int final_z = z;
                    final int final_wid = wid;
                    final int final_arg_wid = arg_wid;
                    final int noisy = arg_noisy;
                    final String rtime = ts;
                    final int excluded = arg_excluded;
                    final int restricted = arg_restricted;
                    final List<Object> blist = arg_blocks;
                    final List<Object> elist = arg_exclude;
                    final List<String> euserlist = arg_exclude_users;
                    final int page = pa;
                    final int display_results = re;
                    final int type_lookup = type;
                    final Location final_location = lo;
                    final List<Integer> final_arg_action = arg_action;
                    final boolean final_count = count;
                    class BasicThread2
                    implements Runnable {
                        BasicThread2() {
                        }

                        @Override
                        public void run() {
                            block53: {
                                try {
                                    ArrayList<String> uuid_list = new ArrayList<String>();
                                    Location location = final_location;
                                    boolean exists = false;
                                    String bc = final_x + "." + final_y + "." + final_z + "." + final_wid + "." + stime + "." + noisy + "." + excluded + "." + restricted + "." + final_arg_wid + "." + display_results;
                                    Config.lookup_command.put(player2.getName(), bc);
                                    Config.lookup_page.put(player2.getName(), page);
                                    Config.lookup_time.put(player2.getName(), rtime);
                                    Config.lookup_type.put(player2.getName(), 5);
                                    Config.lookup_elist.put(player2.getName(), elist);
                                    Config.lookup_e_userlist.put(player2.getName(), euserlist);
                                    Config.lookup_blist.put(player2.getName(), blist);
                                    Config.lookup_ulist.put(player2.getName(), rollbackusers2);
                                    Config.lookup_alist.put(player2.getName(), final_arg_action);
                                    Config.lookup_radius.put(player2.getName(), radius);
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String baduser = "";
                                        for (String check : rollbackusers2) {
                                            if (!check.equals("#global") && !check.equals("#container") || final_arg_action.contains(9)) {
                                                exists = Lookup.playerExists(connection, check);
                                                if (!exists) {
                                                    baduser = check;
                                                    break;
                                                }
                                                if (!final_arg_action.contains(9) || Config.uuid_cache.get(check.toLowerCase()) == null) continue;
                                                String uuid = Config.uuid_cache.get(check.toLowerCase());
                                                uuid_list.add(uuid);
                                                continue;
                                            }
                                            exists = true;
                                        }
                                        if (exists) {
                                            for (String check : euserlist) {
                                                if (!check.equals("#global")) {
                                                    exists = Lookup.playerExists(connection, check);
                                                    if (exists) continue;
                                                    baduser = check;
                                                    break;
                                                }
                                                baduser = "#global";
                                                exists = false;
                                            }
                                        }
                                        if (exists) {
                                            ArrayList<String> user_list = new ArrayList();
                                            if (!final_arg_action.contains(9)) {
                                                user_list = rollbackusers2;
                                            }
                                            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                                            boolean restrict_world = false;
                                            if (radius != null) {
                                                restrict_world = true;
                                            }
                                            if (location == null) {
                                                restrict_world = false;
                                            }
                                            if (final_arg_wid > 0) {
                                                restrict_world = true;
                                                location = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(final_arg_wid)), (double)final_x, (double)final_y, (double)final_z);
                                            } else if (location != null) {
                                                location = new Location(CoreProtect.getInstance().getServer().getWorld(Functions.getWorldName(final_wid)), (double)final_x, (double)final_y, (double)final_z);
                                            }
                                            int row_max = page * display_results;
                                            int page_start = row_max - display_results;
                                            int rows = 0;
                                            boolean check_rows = true;
                                            if (type_lookup == 5 && page > 1 && page_start < (rows = Config.lookup_rows.get(player2.getName()).intValue())) {
                                                check_rows = false;
                                            }
                                            if (check_rows) {
                                                rows = Lookup.countLookupRows(statement, player2, uuid_list, user_list, blist, elist, euserlist, final_arg_action, location, radius, stime, restrict_world, true);
                                                Config.lookup_rows.put(player2.getName(), rows);
                                            }
                                            if (final_count) {
                                                String row_format = NumberFormat.getInstance().format(rows);
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- " + row_format + " row(s) found.");
                                            } else if (page_start < rows) {
                                                String arrows = "                      ";
                                                if (rows > display_results) {
                                                    int total_pages = (int)Math.ceil((double)rows / ((double)display_results + 0.0));
                                                    String page_back = "\u00ab";
                                                    String page_next = "\u00bb";
                                                    arrows = page > 1 && page < total_pages ? page_back + " | " + page_next : (page > 1 ? "    " + page_back : "    " + page_next);
                                                }
                                                arrows = "";
                                                List<String[]> lookup_list = Lookup.performPartialLookup(statement, player2, uuid_list, user_list, blist, elist, euserlist, final_arg_action, location, radius, stime, page_start, display_results, restrict_world, true);
                                                player2.sendMessage("\u00a7f----- \u00a73CoreProtect Lookup Results \u00a7f-----" + arrows);
                                                if (final_arg_action.contains(6) || final_arg_action.contains(7)) {
                                                    for (String[] data : lookup_list) {
                                                        String time = data[0];
                                                        String dplayer = data[1];
                                                        String message = data[2];
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        player2.sendMessage("\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + dplayer + ": \u00a7f" + message + "");
                                                    }
                                                } else if (final_arg_action.contains(8)) {
                                                    for (String[] data : lookup_list) {
                                                        String time = data[0];
                                                        String dplayer = data[1];
                                                        int wid = Integer.parseInt(data[2]);
                                                        int x = Integer.parseInt(data[3]);
                                                        int y = Integer.parseInt(data[4]);
                                                        int z = Integer.parseInt(data[5]);
                                                        int action = Integer.parseInt(data[6]);
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        String action_string = "in";
                                                        if (action == 0) {
                                                            action_string = "out";
                                                        }
                                                        String world = Functions.getWorldName(wid);
                                                        double time_length = (double)timeago.replaceAll("[^0-9]", "").length() * 1.5;
                                                        int padding = (int)(time_length + 12.5);
                                                        String left_padding = StringUtils.leftPad((String)"", (int)padding, (char)' ');
                                                        player2.sendMessage("\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + dplayer + " \u00a7flogged \u00a73" + action_string + "\u00a7f.");
                                                        player2.sendMessage("\u00a7f" + left_padding + "\u00a77^ \u00a7o(x" + x + "/y" + y + "/z" + z + "/" + world + ")");
                                                    }
                                                } else if (final_arg_action.contains(9)) {
                                                    for (String[] data : lookup_list) {
                                                        String time = data[0];
                                                        String user = Config.uuid_cache_reversed.get(data[1]);
                                                        String username = data[2];
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        player2.sendMessage("\u00a77" + timeago + "/h ago \u00a7f- \u00a73" + user + " \u00a7flogged in as \u00a73" + username + "\u00a7f.");
                                                    }
                                                } else {
                                                    for (String[] data : lookup_list) {
                                                        String string_amount = "";
                                                        int drb = Integer.parseInt(data[8]);
                                                        String rbd = "";
                                                        if (drb == 1) {
                                                            rbd = "\u00a7m";
                                                        }
                                                        int amount = 0;
                                                        String time = data[0];
                                                        String dplayer = data[1];
                                                        int x = Integer.parseInt(data[2]);
                                                        int y = Integer.parseInt(data[3]);
                                                        int z = Integer.parseInt(data[4]);
                                                        String dtype = data[5];
                                                        int ddata = Integer.parseInt(data[6]);
                                                        int daction = Integer.parseInt(data[7]);
                                                        int wid = Integer.parseInt(data[9]);
                                                        String a = "placed";
                                                        String tag = "\u00a7f-";
                                                        if (final_arg_action.contains(4) || final_arg_action.contains(5)) {
                                                            amount = Integer.parseInt(data[10]);
                                                            string_amount = "x" + amount + " ";
                                                            a = "added";
                                                        }
                                                        if (daction == 0) {
                                                            a = "removed";
                                                        } else if (daction == 2) {
                                                            a = "clicked";
                                                        } else if (daction == 3) {
                                                            a = "killed";
                                                        }
                                                        double time_since = (double)unixtimestamp - Double.parseDouble(time);
                                                        time_since /= 60.0;
                                                        String timeago = new DecimalFormat("0.00").format(time_since /= 60.0);
                                                        double time_length = (double)timeago.replaceAll("[^0-9]", "").length() * 1.5;
                                                        int padding = (int)(time_length + 12.5);
                                                        String left_padding = StringUtils.leftPad((String)"", (int)padding, (char)' ');
                                                        String world = Functions.getWorldName(wid);
                                                        String dname = "";
                                                        boolean isPlayer = false;
                                                        if (daction == 3) {
                                                            int dTypeInt = Integer.parseInt(dtype);
                                                            if (dTypeInt == 0) {
                                                                if (Config.player_id_cache_reversed.get(ddata) == null) {
                                                                    Database.loadUserName(connection, ddata);
                                                                }
                                                                dname = Config.player_id_cache_reversed.get(ddata);
                                                                isPlayer = true;
                                                            } else {
                                                                dname = Functions.getEntityType(dTypeInt).name();
                                                            }
                                                        } else {
                                                            dname = Functions.getType(Integer.parseInt(dtype)).name().toLowerCase();
                                                            dname = Functions.nameFilter(dname, ddata);
                                                        }
                                                        if (dname.length() > 0 && !isPlayer) {
                                                            dname = "minecraft:" + dname.toLowerCase() + "";
                                                        }
                                                        if (dname.contains("minecraft:")) {
                                                            String[] block_name_split = dname.split(":");
                                                            dname = block_name_split[1];
                                                        }
                                                        player2.sendMessage("\u00a77" + timeago + "/h ago " + tag + " \u00a73" + rbd + "" + dplayer + " \u00a7f" + rbd + "" + a + " " + string_amount + "\u00a73" + rbd + "" + dname + "\u00a7f.");
                                                        player2.sendMessage("\u00a7f" + left_padding + "\u00a77^ \u00a7o(x" + x + "/y" + y + "/z" + z + "/" + world + ")");
                                                    }
                                                }
                                                if (rows > display_results) {
                                                    int total_pages = (int)Math.ceil((double)rows / ((double)display_results + 0.0));
                                                    if (final_arg_action.contains(6) || final_arg_action.contains(7) || final_arg_action.contains(9)) {
                                                        player2.sendMessage("-----");
                                                    }
                                                    player2.sendMessage("\u00a7fPage " + page + "/" + total_pages + ". View older data by typing \"\u00a73/co l <page>\u00a7f\".");
                                                }
                                            } else if (rows > 0) {
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- No results found for that page.");
                                            } else {
                                                player2.sendMessage("\u00a73CoreProtect \u00a7f- No results found.");
                                            }
                                        } else {
                                            player2.sendMessage("\u00a73CoreProtect \u00a7f- User \"" + baduser + "\" not found.");
                                        }
                                        statement.close();
                                        connection.close();
                                        break block53;
                                    }
                                    player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    BasicThread2 runnable = new BasicThread2();
                    Thread thread = new Thread(runnable);
                    thread.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co l <params>\".");
            }
        } else if (type == 6) {
            bid = args[2];
            if ((bid = bid.replaceAll("[^0-9]", "")).length() > 0) {
                int b = Integer.parseInt(bid);
                if (b > 0) {
                    String bname = Functions.block_name_lookup(b);
                    if (bname.length() > 0) {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- The name of block ID #" + b + " is \"" + bname + "\".");
                    } else {
                        player.sendMessage("\u00a73CoreProtect \u00a7f- No data found for block ID #" + b + ".");
                    }
                } else {
                    player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co lookup type <ID>\".");
                }
            } else {
                player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co lookup type <ID>\".");
            }
        } else {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co l <params>\".");
        }
    }
}

