/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.TargetSelectors;

import java.util.HashSet;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.TargetSelectors.ILocationSelector;

public class MTRandomLocationsNearTargetEntities
extends ILocationSelector {
    int amount;
    int amountSq;
    int maxRadius;
    int minRadius;
    int minRadiusSq;
    int spacing;
    int spacingSq;

    public MTRandomLocationsNearTargetEntities(MythicLineConfig mlc) {
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 5);
        this.maxRadius = mlc.getInteger(new String[]{"radius", "r", "maxradius", "maxr"}, 5);
        this.minRadius = mlc.getInteger(new String[]{"minradius", "minr"}, 0);
        this.spacing = mlc.getInteger(new String[]{"spacing", "s"}, 0);
        this.amountSq = this.amount * this.amount;
        this.minRadiusSq = this.minRadius * this.minRadius;
        this.spacingSq = this.spacing * this.spacing;
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        for (AbstractEntity e : data.getEntityTargets()) {
            int i = 0;
            int j = 0;
            while (i < this.amount && j < this.amountSq) {
                ++j;
                MythicMobs.inst().getMobManager();
                AbstractLocation l = MobManager.findSafeSpawnLocation(e.getLocation(), this.maxRadius, 1, 1, true);
                if (this.minRadius > 0 && l.distanceSquared(e.getLocation()) < (double)this.minRadiusSq) continue;
                if (this.spacing > 0) {
                    boolean bad = false;
                    for (AbstractLocation l2 : targets) {
                        if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                        bad = true;
                        break;
                    }
                    if (bad) continue;
                }
                targets.add(l);
                ++i;
            }
        }
        return targets;
    }
}

