/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.TargetSelectors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillTargeter;
import org.bukkit.metadata.MetadataValue;

public abstract class IEntitySelector
extends SkillTargeter {
    private boolean targetPlayers = true;
    private boolean targetCreativeMode = false;
    private boolean targetSpectatorMode = false;
    private boolean targetCitizensNPCs = false;
    private boolean targetAnimals = true;
    private boolean targetCreatures = true;
    private boolean targetMonsters = true;
    private boolean targetWaterMobs = true;
    private boolean targetFlyingMobs = true;
    private boolean targetSameFaction = true;
    private List<String> ignoreTypes = null;

    public IEntitySelector(MythicLineConfig mlc) {
        String target = mlc.getString("target", null);
        String ignore = mlc.getString("ignore", null);
        String ignoreTypes = mlc.getString("ignoretype", null);
        if (target != null) {
            this.targetPlayers = false;
            this.targetCreativeMode = false;
            this.targetSpectatorMode = false;
            this.targetCitizensNPCs = false;
            this.targetAnimals = false;
            this.targetCreatures = false;
            this.targetMonsters = false;
            this.targetWaterMobs = false;
            this.targetFlyingMobs = false;
            if (target.contains("player")) {
                this.targetPlayers = true;
            }
            if (target.contains("creative")) {
                this.targetCreativeMode = true;
            }
            if (target.contains("spectator")) {
                this.targetSpectatorMode = true;
            }
            if (target.contains("npc")) {
                this.targetCitizensNPCs = true;
            }
            if (target.contains("animal")) {
                this.targetAnimals = true;
            }
            if (target.contains("monster")) {
                this.targetMonsters = true;
            }
            if (target.contains("creatures")) {
                this.targetCreatures = true;
            }
        }
        if (ignore != null) {
            if (ignore.contains("player")) {
                this.targetPlayers = false;
            }
            if (ignore.contains("creative")) {
                this.targetCreativeMode = false;
            }
            if (ignore.contains("spectator")) {
                this.targetSpectatorMode = false;
            }
            if (ignore.contains("npc")) {
                this.targetCitizensNPCs = false;
            }
            if (ignore.contains("animal")) {
                this.targetAnimals = false;
            }
            if (ignore.contains("monsters")) {
                this.targetMonsters = false;
            }
            if (ignore.contains("creatures")) {
                this.targetCreatures = false;
            }
            if (ignore.contains("faction")) {
                this.targetSameFaction = false;
            }
        }
        if (ignoreTypes != null) {
            this.ignoreTypes = new ArrayList<String>();
            for (String s : ignoreTypes.split(",")) {
                this.ignoreTypes.add(s);
            }
        }
        this.targetPlayers = mlc.getBoolean("targetplayers", this.targetPlayers);
        this.targetCreativeMode = mlc.getBoolean("targetcreative", this.targetCreativeMode);
        this.targetSpectatorMode = mlc.getBoolean("targetspectator", this.targetSpectatorMode);
        this.targetCitizensNPCs = mlc.getBoolean("targetnpcs", this.targetCitizensNPCs);
        this.targetAnimals = mlc.getBoolean("targetanimals", this.targetAnimals);
        this.targetCreatures = mlc.getBoolean("targetcreaturess", this.targetCreatures);
        this.targetSameFaction = mlc.getBoolean("targetcreaturess", this.targetSameFaction);
    }

    public abstract HashSet<AbstractEntity> getEntities(SkillMetadata var1);

    public void filter(SkillMetadata data, boolean targetCreative) {
        HashSet<AbstractEntity> targets = data.getEntityTargets();
        targets.removeIf(t -> {
            if (t == null) {
                return true;
            }
            if (!this.targetPlayers) {
                if (t.isPlayer()) {
                    return true;
                }
            } else {
                if (!this.targetCreativeMode && !targetCreative && t.isPlayer() && t.asPlayer().isInCreativeMode()) {
                    return true;
                }
                if (!this.targetSpectatorMode && !targetCreative && t.isPlayer() && t.asPlayer().isInSpectatorMode()) {
                    return true;
                }
            }
            if (!this.targetAnimals && t.isAnimal()) {
                return true;
            }
            if (!this.targetCreatures && t.isCreature()) {
                return true;
            }
            if (!this.targetMonsters && t.isMonster()) {
                return true;
            }
            if (!this.targetCitizensNPCs && t.isLiving() && t.getBukkitEntity().hasMetadata("NPC")) {
                return true;
            }
            if (!this.targetSameFaction) {
                ActiveMob am = (ActiveMob)data.getCaster();
                if (t.isLiving() && t.getBukkitEntity().hasMetadata("Faction")) {
                    List md = t.getBukkitEntity().getMetadata("Faction");
                    for (MetadataValue v : md) {
                        if (!v.asString().equals(am.getFaction())) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }
}

