/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class TeleportToSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected String world;
    protected String coords;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double z = 0.0;
    protected double yaw;
    protected double pitch;

    public TeleportToSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.coords = mlc.getString(new String[]{"location", "loc", "l", "coordinates", "c"}, null, new String[0]);
        if (this.coords != null) {
            String[] split = this.coords.split(",");
            try {
                this.x = Double.parseDouble(split[0]);
                this.y = Double.parseDouble(split[1]);
                this.z = Double.parseDouble(split[2]);
            }
            catch (Exception ex) {
                MythicMobs.skillConfigError("TELEPORTTO", line, "The 'coordinates' attribute must be in the format c=x,y,z.");
                return;
            }
        }
        this.world = mlc.getString(new String[]{"world", "w"}, null, new String[0]);
        this.yaw = mlc.getDouble(new String[]{"yaw", "y"}, 0.0);
        this.pitch = mlc.getDouble(new String[]{"pitch", "p"}, 0.0);
        if (this.coords == null && this.world == null) {
            MythicMobs.skillConfigError("TELEPORTTO", line, "Either the 'coordinates' attribute or 'world' attribute is required.");
            return;
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        AbstractLocation location = this.world == null ? new AbstractLocation(target.getWorld(), this.x, this.y, this.z) : (this.coords == null ? new AbstractLocation(MythicMobs.plugin.getMinecraftServer().getWorld(this.world), target.getLocation().getX(), target.getLocation().getY(), target.getLocation().getZ()) : new AbstractLocation(MythicMobs.plugin.getMinecraftServer().getWorld(this.world), this.x, this.y, this.z));
        location.setPitch((float)this.pitch);
        location.setYaw((float)this.yaw);
        target.teleport(location);
        return true;
    }
}

