/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class TeleportSkill
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected double spreadH;
    protected double spreadV;

    public TeleportSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.spreadH = mlc.getDouble("spreadh", 0.0);
        this.spreadH = mlc.getDouble("sh", this.spreadH);
        this.spreadV = mlc.getDouble("spreadv", 0.0);
        this.spreadV = mlc.getDouble("sv", this.spreadV);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            AbstractEntity abstractEntity = am.getEntity();
            MythicMobs.inst().getMobManager();
            abstractEntity.teleport(MobManager.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1));
        } else {
            AbstractEntity abstractEntity = data.getCaster().getEntity();
            MythicMobs.inst().getMobManager();
            abstractEntity.teleport(MobManager.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, 2));
        }
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.spreadH > 0.0 || this.spreadV > 0.0) {
            if (data.getCaster() instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)data.getCaster();
                MythicMobs.inst().getMobManager();
                target = MobManager.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1);
            } else {
                MythicMobs.inst().getMobManager();
                target = MobManager.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, 2);
            }
        }
        data.getCaster().getEntity().teleport(target);
        return true;
    }
}

