/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.ArrayList;
import java.util.List;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillString;

public class RandomMessageSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected List<String> messages = new ArrayList<String>();

    public RandomMessageSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        try {
            String m = mlc.getString(new String[]{"messages", "message", "msg", "msgs", "m"});
            for (String s : m.split(",")) {
                this.messages.add(s.substring(1, s.length() - 1));
                MythicMobs.debug(2, "-- Loaded RandomMessage " + s.substring(1, s.length() - 1));
            }
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("RANDOMMESSAGE", line, "The 'messages' attribute is required.");
            this.messages.add("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            MythicMobs.plugin.handleException(ex);
        }
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        String message = this.messages.get(MythicMobs.r.nextInt(this.messages.size()));
        MythicMobs.debug(2, "Executing RandomMessage skill with message: " + message);
        String m = SkillString.parseMobVariables(message, data.getCaster(), target, data.getTrigger());
        if (target.isPlayer()) {
            target.asPlayer().sendMessage(m);
            return true;
        }
        return false;
    }
}

