/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.ArrayList;
import java.util.HashSet;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class PrisonSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected int duration;
    protected boolean breakable;
    protected Material type;
    protected HashSet<Block> blocks = new HashSet();

    public PrisonSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 100);
        this.breakable = mlc.getBoolean(new String[]{"breakable", "b"}, false);
        String mat = mlc.getString(new String[]{"material", "m", "type", "t"}, "ICE", new String[0]);
        this.type = Material.getMaterial((String)mat.toUpperCase());
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.type == null) {
            return false;
        }
        int x = target.getLocation().getBlockX();
        int y = target.getLocation().getBlockY();
        int z = target.getLocation().getBlockZ();
        Location loc = new Location(BukkitAdapter.adapt(target.getLocation()).getWorld(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, target.getLocation().getYaw(), target.getLocation().getPitch());
        target.teleport(BukkitAdapter.adapt(loc));
        this.createPrison(target, data.getPower());
        return true;
    }

    private void createPrison(AbstractEntity t, float power) {
        Entity target = BukkitAdapter.adapt(t);
        ArrayList<Block> prisonBlocks = new ArrayList<Block>();
        Block feet = target.getLocation().getBlock();
        Block temp = feet.getRelative(1, 0, 0);
        if (temp.getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(1, 1, 0)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(-1, 0, 0)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(-1, 1, 0)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(0, 0, 1)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(0, 1, 1)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(0, 0, -1)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(0, 1, -1)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(0, -1, 0)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if ((temp = feet.getRelative(0, 2, 0)).getType() == Material.AIR) {
            temp.setType(this.type);
            prisonBlocks.add(temp);
        }
        if (this.duration > 0 && prisonBlocks.size() > 0) {
            this.blocks.addAll(prisonBlocks);
            MythicMobs.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)new PrisonRemover(prisonBlocks), (long)Math.round((float)this.duration * power));
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.blocks.contains(event.getBlock())) {
            event.setCancelled(true);
            if (this.breakable) {
                event.getBlock().setType(Material.AIR);
            }
        }
    }

    private class PrisonRemover
    implements Runnable {
        ArrayList<Block> prison;

        public PrisonRemover(ArrayList<Block> prison) {
            this.prison = prison;
        }

        @Override
        public void run() {
            for (Block block : this.prison) {
                if (PrisonSkill.this.type != block.getType()) continue;
                block.setType(Material.AIR);
            }
            PrisonSkill.this.blocks.removeAll(this.prison);
        }
    }
}

