/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.ArrayList;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractVector;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleEffect;
import net.elseland.xikage.MythicMobs.Skills.ParticleMaker;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Util.RandomUtil;

public class ParticleTornadoEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float cloudHSpread;
    float cloudVSpread;
    float cloudPSpeed;
    float cloudYOffset;
    public String strCloudParticle = "cloud";
    public float cloudSize = 2.5f;
    public float particleSpeedRamp = 0.0f;
    public int cloudAmount = 1;
    public double yOffset = 0.8;
    public float tornadoHeight = 5.0f;
    public float maxTornadoRadius = 5.0f;
    private int sliceHeight;
    private int interval;
    private int duration;
    private float rotationSpeed;
    public boolean showCloud = true;
    public boolean showTornado = true;
    public double distance = 0.375;

    public ParticleTornadoEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.maxTornadoRadius = mlc.getFloat(new String[]{"maxradius", "mr"}, 3.0f);
        this.yOffset = mlc.getFloat(new String[]{"yoffset", "yo"}, 0.8f);
        this.tornadoHeight = mlc.getFloat(new String[]{"height", "h"}, 4.0f);
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 4);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 200);
        this.rotationSpeed = mlc.getFloat(new String[]{"rotationspeed", "rs"}, 0.04f);
        this.sliceHeight = mlc.getInteger(new String[]{"sliceheight", "sh"}, 64);
        this.particleSpeedRamp = mlc.getFloat(new String[]{"particlespeedramp", "psr"}, 0.0f);
        this.strCloudParticle = mlc.getString(new String[]{"cloudparticle", "cp"}, "largeexplode", new String[0]);
        this.cloudSize = mlc.getFloat(new String[]{"cloudsize", "cs"}, 5.0f);
        this.cloudAmount = mlc.getInteger(new String[]{"cloudamount", "ca"}, 1);
        this.cloudHSpread = mlc.getFloat(new String[]{"cloudhspread", "chs"}, 1.0f);
        this.cloudVSpread = mlc.getFloat(new String[]{"cloudvspread", "cvs"}, 1.8f);
        this.cloudPSpeed = mlc.getFloat(new String[]{"cloudpspeed", "cps", "cs"}, 2.0f);
        this.cloudYOffset = mlc.getFloat(new String[]{"cloudyoffset", "cyo"}, 1.8f);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(target, this.interval, this.duration);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target, this.interval, this.duration);
        return false;
    }

    public ArrayList<AbstractVector> createCircle(double y, double radius, double rotation) {
        double amount = radius * (double)this.sliceHeight;
        double inc = Math.PI * 2 / amount;
        double r = rotation % 360.0;
        ArrayList<AbstractVector> vecs = new ArrayList<AbstractVector>();
        int i = 0;
        while ((double)i < amount) {
            double angle = (double)i * inc + r;
            double x = radius * Math.cos(angle);
            double z = radius * Math.sin(angle);
            AbstractVector v = new AbstractVector(x, y, z);
            vecs.add(v);
            ++i;
        }
        return vecs;
    }

    private class Animator
    implements Runnable {
        private AbstractEntity entity;
        private AbstractLocation location;
        private int interval;
        private int duration;
        private int iteration;
        private int taskId;

        public Animator(AbstractLocation location, int interval, int duration) {
            this(interval, duration);
            this.entity = null;
            this.location = location;
        }

        public Animator(AbstractEntity entity, int interval, int duration) {
            this(interval, duration);
            this.entity = entity;
        }

        protected Animator(int interval, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.iteration = 0;
            this.taskId = TaskManager.get().scheduleAsyncTask(this, 0, interval);
            MythicMobs.debug(3, "# Started ParticleTornado effect");
        }

        protected AbstractLocation getLocation() {
            if (this.entity != null) {
                return this.entity.getLocation();
            }
            return this.location.clone();
        }

        @Override
        public void run() {
            if (this.iteration * this.interval > this.duration) {
                TaskManager.get().cancelTask(this.taskId);
            } else {
                ++this.iteration;
                AbstractLocation l = this.getLocation().add(0.0, ParticleTornadoEffect.this.cloudYOffset, 0.0);
                int i = 0;
                while ((float)i < ParticleTornadoEffect.this.cloudSize) {
                    AbstractVector v = RandomUtil.getRandomCircleVector().multiply(RandomUtil.random.nextDouble() * (double)ParticleTornadoEffect.this.cloudSize);
                    if (ParticleTornadoEffect.this.showCloud) {
                        l.add(v);
                        new ParticleMaker.ParticlePacket(ParticleTornadoEffect.this.strCloudParticle, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudVSpread, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudPSpeed, ParticleTornadoEffect.this.cloudAmount, true).send(BukkitAdapter.adapt(l), ParticleTornadoEffect.this.viewDistance);
                        l.subtract(v);
                    }
                    ++i;
                }
                AbstractLocation t = l.clone().add(0.0, 0.2 + ParticleTornadoEffect.this.yOffset, 0.0);
                double r = 0.45 * ((double)ParticleTornadoEffect.this.maxTornadoRadius * (2.35 / (double)ParticleTornadoEffect.this.tornadoHeight));
                for (double y = 0.0; y < (double)ParticleTornadoEffect.this.tornadoHeight; y += ParticleTornadoEffect.this.distance) {
                    double fr = r * y;
                    if (fr > (double)ParticleTornadoEffect.this.maxTornadoRadius) {
                        fr = ParticleTornadoEffect.this.maxTornadoRadius;
                    }
                    for (AbstractVector v : ParticleTornadoEffect.this.createCircle(y, fr, (double)this.iteration * (double)this.interval * (double)ParticleTornadoEffect.this.rotationSpeed)) {
                        if (!ParticleTornadoEffect.this.showTornado) continue;
                        l.add(v);
                        new ParticleMaker.ParticlePacket(ParticleTornadoEffect.this.strParticle, ParticleTornadoEffect.this.hSpread, ParticleTornadoEffect.this.vSpread, ParticleTornadoEffect.this.hSpread, (float)((double)ParticleTornadoEffect.this.pSpeed + (double)ParticleTornadoEffect.this.particleSpeedRamp * y), ParticleTornadoEffect.this.amount, true).send(BukkitAdapter.adapt(l), ParticleTornadoEffect.this.viewDistance);
                        t.subtract(v);
                    }
                }
                l.subtract(0.0, ParticleTornadoEffect.this.yOffset, 0.0);
            }
        }
    }
}

