/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleEffect;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Util.RandomUtil;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleSphereEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    int points;
    float radius;

    public ParticleSphereEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.points = this.amount;
        this.amount = 1;
        this.radius = mlc.getFloat("radius", 0.0f);
        this.radius = mlc.getFloat("r", this.radius);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleSphereEffect(target);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleSphereEffect(target.getLocation());
        return true;
    }

    protected void playParticleSphereEffect(AbstractLocation t) {
        Location target = BukkitAdapter.adapt(t);
        Location location = target.clone();
        location.add(0.0, (double)this.yOffset, 0.0);
        for (int i = 0; i < this.points; ++i) {
            Vector vector = RandomUtil.getRandomVector().multiply(this.radius);
            location.add(vector);
            this.playParticleEffect(location);
            location.subtract(vector);
        }
    }
}

