/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleEffect;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.World;

public class ParticleRingEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float radius;
    int points;
    int inc;

    public ParticleRingEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.points = mlc.getInteger("points", 10);
        this.points = mlc.getInteger("pts", this.points);
        this.radius = mlc.getFloat("radius", 10.0f);
        this.radius = mlc.getFloat("r", this.radius);
        if (this.points <= 0) {
            this.points = 1;
        }
        this.amount /= this.points;
        this.inc = 360 / this.points;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.fromOrigin) {
            this.playParticleRingEffect(data.getOrigin());
        } else {
            this.playParticleRingEffect(target);
        }
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleRingEffect(target.getLocation());
        return false;
    }

    protected void playParticleRingEffect(AbstractLocation t) {
        Location target = BukkitAdapter.adapt(t);
        if (target == null) {
            return;
        }
        double bx = target.getX();
        double y = target.getY() + (double)this.yOffset;
        double bz = target.getZ();
        World w = target.getWorld();
        for (double i = 0.0; i < 360.0; i += (double)this.inc) {
            double angle = i * Math.PI / 180.0;
            double x = (int)(bx + (double)this.radius * Math.cos(angle));
            double z = (int)(bz + (double)this.radius * Math.sin(angle));
            Location l = new Location(w, x, y, z);
            this.playParticleEffect(l);
        }
    }
}

