/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ParticleEffect;
import net.elseland.xikage.MythicMobs.Skills.ParticleMaker;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Util.RandomUtil;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParticleBoxEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float radius;

    public ParticleBoxEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.radius = mlc.getFloat("radius", 5.0f);
        this.radius = mlc.getFloat("r", this.radius);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playParticleSphereEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playParticleSphereEffect(target.getLocation());
        return false;
    }

    protected void playParticleSphereEffect(final AbstractLocation t) {
        new BukkitRunnable(){

            public void run() {
                Location target = BukkitAdapter.adapt(t);
                Location location = target.clone();
                location.add(0.0, (double)ParticleBoxEffect.this.yOffset, 0.0);
                for (int i = 0; i < ParticleBoxEffect.this.amount; ++i) {
                    Vector vector = RandomUtil.getRandomVector().multiply(ParticleBoxEffect.this.radius);
                    location.add(vector);
                    new ParticleMaker.ParticlePacket(ParticleBoxEffect.this.strParticle, ParticleBoxEffect.this.hSpread, ParticleBoxEffect.this.vSpread, ParticleBoxEffect.this.hSpread, ParticleBoxEffect.this.pSpeed, 1, true).send(location, ParticleBoxEffect.this.viewDistance);
                    location.subtract(vector);
                }
            }
        }.runTaskAsynchronously((Plugin)MythicMobs.plugin);
    }
}

