/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractVector;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Util.BlockUtil;
import net.elseland.xikage.MythicMobs.Util.HitBox;

public class MissileSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected Optional<Skill> onTickSkill = Optional.empty();
    protected Optional<Skill> onHitSkill = Optional.empty();
    protected Optional<Skill> onEndSkill = Optional.empty();
    protected Optional<Skill> onStartSkill = Optional.empty();
    protected String onTickSkillName;
    protected String onHitSkillName;
    protected String onEndSkillName;
    protected String onStartSkillName;
    protected int tickInterval;
    protected float ticksPerSecond;
    protected float hitRadius;
    protected float verticalHitRadius;
    protected float range;
    protected float maxDistanceSquared;
    protected float duration;
    protected float startYOffset;
    protected float startForwardOffset;
    protected float targetYOffset;
    protected float projectileInertia;
    protected float projectileVelocity;
    protected boolean fromOrigin;
    protected boolean stopOnHitEntity;
    protected boolean stopOnHitGround;
    protected boolean powerAffectsVelocity = true;
    protected boolean powerAffectsRange = true;
    protected boolean hitTarget = true;
    protected boolean hitPlayers = false;
    protected boolean hitNonPlayers = false;
    protected boolean hitTargetOnly = false;

    public MissileSkill(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onTickSkillName = mlc.getString(new String[]{"ontickskill", "ontick", "ot", "skill", "s", "meta", "m"});
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        this.onEndSkillName = mlc.getString(new String[]{"onendskill", "onend", "oe"});
        this.onStartSkillName = mlc.getString(new String[]{"onstartskill", "onstart", "os"});
        this.tickInterval = mlc.getInteger(new String[]{"interval", "int", "i"}, 4);
        this.ticksPerSecond = 20.0f / (float)this.tickInterval;
        this.hitRadius = mlc.getFloat("horizontalradius", 1.25f);
        this.hitRadius = mlc.getFloat("hradius", this.hitRadius);
        this.hitRadius = mlc.getFloat("hr", this.hitRadius);
        this.hitRadius = mlc.getFloat("r", this.hitRadius);
        this.range = mlc.getFloat("maxrange", 40.0f);
        this.range = mlc.getFloat("mr", this.range);
        this.maxDistanceSquared = this.range * this.range;
        this.duration = mlc.getFloat("maxduration", 10.0f);
        this.duration = mlc.getFloat("md", this.duration);
        this.duration *= 1000.0f;
        this.verticalHitRadius = mlc.getFloat("verticalradius", this.hitRadius);
        this.verticalHitRadius = mlc.getFloat("vradius", this.verticalHitRadius);
        this.verticalHitRadius = mlc.getFloat("vr", this.verticalHitRadius);
        this.startYOffset = mlc.getFloat("startyoffset", 1.0f);
        this.startYOffset = mlc.getFloat("syo", this.startYOffset);
        this.startForwardOffset = mlc.getFloat("startfoffset", 1.0f);
        this.startForwardOffset = mlc.getFloat("sfo", this.startForwardOffset);
        this.targetYOffset = mlc.getFloat(new String[]{"targetyoffset", "targety", "tyo"}, 0.6f);
        this.projectileInertia = mlc.getFloat(new String[]{"intertia", "inertia", "in"}, 1.5f);
        this.projectileVelocity = mlc.getFloat("velocity", 5.0f);
        this.projectileVelocity = mlc.getFloat("v", this.projectileVelocity);
        this.stopOnHitEntity = mlc.getBoolean("stopatentity", true);
        this.stopOnHitEntity = mlc.getBoolean("se", this.stopOnHitEntity);
        this.stopOnHitGround = mlc.getBoolean("stopatblock", true);
        this.stopOnHitGround = mlc.getBoolean("sb", this.stopOnHitGround);
        this.powerAffectsVelocity = mlc.getBoolean("poweraffectsvelocity", true);
        this.powerAffectsVelocity = mlc.getBoolean("pav", this.powerAffectsVelocity);
        this.powerAffectsRange = mlc.getBoolean("poweraffectsrange", true);
        this.powerAffectsRange = mlc.getBoolean("par", this.powerAffectsRange);
        this.hitPlayers = mlc.getBoolean("hitplayers", false);
        this.hitPlayers = mlc.getBoolean("hp", this.hitPlayers);
        this.hitNonPlayers = mlc.getBoolean("hitnonplayers", false);
        this.hitNonPlayers = mlc.getBoolean("hnp", this.hitNonPlayers);
        this.hitTarget = mlc.getBoolean("hittarget", true);
        this.hitTarget = mlc.getBoolean("ht", this.hitTarget);
        this.hitTargetOnly = mlc.getBoolean("hittargetonly", false);
        this.hitTargetOnly = mlc.getBoolean("hittargetonly", this.hitTargetOnly);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onTickSkillName != null) {
                this.onTickSkill = MythicMobs.inst().getSkillManager().getSkill(this.onTickSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onTickSkillName);
            if (this.onHitSkillName != null) {
                this.onHitSkill = MythicMobs.inst().getSkillManager().getSkill(this.onHitSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onHitSkillName);
            if (this.onEndSkillName != null) {
                this.onEndSkill = MythicMobs.inst().getSkillManager().getSkill(this.onEndSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onEndSkillName);
            if (this.onStartSkillName != null) {
                this.onStartSkill = MythicMobs.inst().getSkillManager().getSkill(this.onStartSkillName);
            }
            MythicMobs.debug(3, "-- Loaded SkillSkill pointing at " + this.onStartSkillName);
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        try {
            new MissileTracker(data, target);
            return true;
        }
        catch (Exception ex) {
            MythicMobs.plugin.handleException(ex);
            return false;
        }
    }

    private class MissileTracker
    implements Runnable {
        private SkillMetadata data;
        private boolean cancelled = false;
        private SkillCaster am;
        private float power;
        private long startTime;
        private AbstractLocation startLocation;
        private AbstractLocation previousLocation;
        private AbstractLocation currentLocation;
        private AbstractEntity target;
        private float velocity;
        private AbstractVector currentVelocity;
        private int taskId;
        private HashSet<AbstractEntity> targets = new HashSet();
        private Set<AbstractEntity> inRange = ConcurrentHashMap.newKeySet();
        private Map<AbstractEntity, Long> immune = new HashMap<AbstractEntity, Long>();
        private int counter = 0;

        public MissileTracker(SkillMetadata data, AbstractEntity target) {
            this.data = data;
            this.cancelled = false;
            this.am = data.getCaster();
            this.target = target;
            this.power = data.getPower();
            this.startTime = System.currentTimeMillis();
            this.velocity = MissileSkill.this.projectileVelocity / MissileSkill.this.ticksPerSecond;
            this.startLocation = MissileSkill.this.fromOrigin ? data.getOrigin().clone() : this.am.getEntity().getLocation().clone();
            if (MissileSkill.this.startYOffset != 0.0f) {
                this.startLocation.setY(this.startLocation.getY() + (double)MissileSkill.this.startYOffset);
            }
            if (MissileSkill.this.startForwardOffset != 0.0f) {
                this.startLocation.add(this.startLocation.getDirection().clone().multiply(MissileSkill.this.startForwardOffset));
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            this.currentVelocity = target.getLocation().toVector().subtract(this.currentLocation.toVector()).normalize();
            if (MissileSkill.this.powerAffectsVelocity) {
                this.velocity *= this.power;
            }
            this.currentVelocity.multiply(this.velocity);
            MythicMobs.debug(3, "------ Initializing projectile skill");
            this.taskId = TaskManager.get().scheduleTask(this, 0, MissileSkill.this.tickInterval);
            if (MissileSkill.this.hitPlayers || MissileSkill.this.hitNonPlayers || MissileSkill.this.hitTarget) {
                this.inRange.addAll(this.currentLocation.getWorld().getLivingEntities());
                this.inRange.removeIf(e -> {
                    if (e != null) {
                        MythicMobs.debug(4, "-------- Added entity " + e.getName());
                        if (e.getUniqueId().equals(this.am.getEntity().getUniqueId())) {
                            MythicMobs.debug(4, "-------- Removed entity " + e.getName() + ": is self");
                            return true;
                        }
                        if (!MissileSkill.this.hitPlayers && e.isPlayer()) {
                            MythicMobs.debug(4, "-------- Removed entity " + e.getName() + ": is player");
                            return true;
                        }
                        if (!MissileSkill.this.hitNonPlayers && !e.isPlayer()) {
                            MythicMobs.debug(4, "-------- Removed entity " + e.getName() + ": is non-player");
                            return true;
                        }
                    } else {
                        return true;
                    }
                    return false;
                });
                if (MissileSkill.this.hitTarget) {
                    this.inRange.add(target);
                }
            }
            if (MissileSkill.this.onStartSkill.isPresent() && MissileSkill.this.onStartSkill.get().usable(data, null)) {
                SkillMetadata sData = data.deepClone();
                MissileSkill.this.onStartSkill.get().execute(sData.setLocationTarget(this.startLocation).setOrigin(this.currentLocation.clone()));
            }
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            if (!this.target.isValid()) {
                this.stop();
                return;
            }
            if (!this.currentLocation.getWorld().equals(this.target.getWorld())) {
                this.stop();
                return;
            }
            if (MissileSkill.this.duration > 0.0f && (float)this.startTime + MissileSkill.this.duration < (float)System.currentTimeMillis()) {
                this.stop();
                return;
            }
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            this.currentVelocity.multiply(MissileSkill.this.projectileInertia);
            this.currentVelocity.add(this.target.getLocation().add(0.0, MissileSkill.this.targetYOffset, 0.0).subtract(this.currentLocation.getX(), this.currentLocation.getY(), this.currentLocation.getZ()).toVector().normalize());
            this.currentVelocity.normalize().multiply(this.velocity);
            ++this.counter;
            if (MissileSkill.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock())) {
                this.stop();
                return;
            }
            if (this.currentLocation.distanceSquared(this.startLocation) >= (double)MissileSkill.this.maxDistanceSquared) {
                this.stop();
                return;
            }
            if (this.inRange != null) {
                MythicMobs.debug(4, "-------- Checking if entities in HitBox");
                HitBox hitBox = new HitBox(this.currentLocation, MissileSkill.this.hitRadius, MissileSkill.this.verticalHitRadius);
                for (AbstractEntity e : this.inRange) {
                    if (!e.isDead() && hitBox.contains(e.getLocation().add(0.0, 0.6, 0.0))) {
                        MythicMobs.debug(4, "---------- Target " + e.getUniqueId() + " is in HitBox!");
                        this.targets.add(e);
                        if (MissileSkill.this.stopOnHitEntity) {
                            this.doHit(this.targets);
                            this.stop();
                            return;
                        }
                        this.immune.put(e, System.currentTimeMillis());
                        break;
                    }
                    MythicMobs.debug(4, "---------- Target " + e.getUniqueId() + " is NOT in HitBox!");
                }
                Iterator<Map.Entry<AbstractEntity, Long>> iter = this.immune.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<AbstractEntity, Long> entry = iter.next();
                    if (entry.getValue() >= System.currentTimeMillis() - 2000L) continue;
                    iter.remove();
                    this.inRange.add(entry.getKey());
                }
            }
            if (MissileSkill.this.onTickSkill.isPresent() && MissileSkill.this.onTickSkill.get().usable(this.data, null)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = this.currentLocation.clone();
                MissileSkill.this.onTickSkill.get().execute(sData.setOrigin(location).setLocationTarget(location));
            }
            if (this.targets.size() > 0) {
                this.doHit((HashSet)this.targets.clone());
            }
            this.targets.clear();
        }

        public void doHit(HashSet<AbstractEntity> targets) {
            if (MissileSkill.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (MissileSkill.this.onHitSkill.get().usable(sData, null)) {
                    MissileSkill.this.onHitSkill.get().execute(sData);
                }
            }
        }

        public void stop() {
            if (MissileSkill.this.onEndSkill.isPresent() && MissileSkill.this.onEndSkill.get().isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                MissileSkill.this.onEndSkill.get().execute(sData.setOrigin(this.currentLocation).setLocationTarget(this.currentLocation));
            }
            TaskManager.get().cancelTask(this.taskId);
            this.cancelled = true;
            if (this.inRange != null) {
                this.inRange.clear();
            }
        }
    }
}

