/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Util.NMSReflection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageJSONMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected String message;
    private static Constructor<?> nmsPacketPlayOutChatConstructor;
    private static Object nmsChatSerializerGsonInstance;
    private static Method fromJsonMethod;

    public MessageJSONMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.target_creative = true;
        this.message = mlc.getString("message");
        this.message = mlc.getString("msg", this.message);
        this.message = mlc.getString("m", this.message);
        try {
            this.message = this.message.substring(1, this.message.length() - 1);
        }
        catch (Exception ex) {
            MythicMobs.skillConfigError("MESSAGE", line, "The 'message' attribute is required.");
            this.message = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
            MythicMobs.plugin.handleException(ex);
        }
        if (nmsPacketPlayOutChatConstructor == null) {
            try {
                nmsPacketPlayOutChatConstructor = NMSReflection.getNMSClass("PacketPlayOutChat").getDeclaredConstructor(NMSReflection.getNMSClass("IChatBaseComponent"));
                nmsPacketPlayOutChatConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Bukkit.getLogger().log(Level.SEVERE, "Could not find Minecraft method or constructor.", e);
            }
            catch (SecurityException e) {
                Bukkit.getLogger().log(Level.WARNING, "Could not access constructor.", e);
            }
        }
        MythicMobs.debug(2, "Loaded message skill with message " + this.message);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        MythicMobs.debug(2, "Executing message skill with message: " + this.message);
        String m = SkillString.parseMobVariables(this.message, data.getCaster(), target, data.getTrigger());
        if (target.isPlayer()) {
            this.send((CommandSender)((Player)target.getBukkitEntity()), m);
            return true;
        }
        return false;
    }

    private void send(CommandSender sender, String message) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        try {
            Object handle = NMSReflection.getHandle(player);
            Object connection = NMSReflection.getField(handle.getClass(), "playerConnection").get(handle);
            NMSReflection.getMethod(connection.getClass(), "sendPacket", NMSReflection.getNMSClass("Packet")).invoke(connection, this.createChatPacket(message));
        }
        catch (IllegalArgumentException e) {
            Bukkit.getLogger().log(Level.WARNING, "Argument could not be passed.", e);
        }
        catch (IllegalAccessException e) {
            Bukkit.getLogger().log(Level.WARNING, "Could not access method.", e);
        }
        catch (InstantiationException e) {
            Bukkit.getLogger().log(Level.WARNING, "Underlying class is abstract.", e);
        }
        catch (InvocationTargetException e) {
            Bukkit.getLogger().log(Level.WARNING, "A error has occured durring invoking of method.", e);
        }
        catch (NoSuchMethodException e) {
            Bukkit.getLogger().log(Level.WARNING, "Could not find method.", e);
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().log(Level.WARNING, "Could not find class.", e);
        }
    }

    private Object createChatPacket(String json) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        if (nmsChatSerializerGsonInstance == null) {
            Class<?> chatSerializerClazz;
            if (MythicMobs.inst().getMinecraftVersion() < 9) {
                String version = NMSReflection.getVersion();
                double majorVersion = Double.parseDouble(version.replace('_', '.').substring(1, 4));
                int lesserVersion = Integer.parseInt(version.substring(6, 7));
                chatSerializerClazz = majorVersion < 1.8 || majorVersion == 1.8 && lesserVersion == 1 ? NMSReflection.getNMSClass("ChatSerializer") : NMSReflection.getNMSClass("IChatBaseComponent$ChatSerializer");
            } else {
                chatSerializerClazz = NMSReflection.getNMSClass("IChatBaseComponent$ChatSerializer");
            }
            if (chatSerializerClazz == null) {
                throw new ClassNotFoundException("Can't find the ChatSerializer class");
            }
            for (Field declaredField : chatSerializerClazz.getDeclaredFields()) {
                if (!Modifier.isFinal(declaredField.getModifiers()) || !Modifier.isStatic(declaredField.getModifiers()) || !declaredField.getType().getName().endsWith("Gson")) continue;
                declaredField.setAccessible(true);
                nmsChatSerializerGsonInstance = declaredField.get(null);
                fromJsonMethod = nmsChatSerializerGsonInstance.getClass().getMethod("fromJson", String.class, Class.class);
                break;
            }
        }
        Object serializedChatComponent = fromJsonMethod.invoke(nmsChatSerializerGsonInstance, json, NMSReflection.getNMSClass("IChatBaseComponent"));
        return nmsPacketPlayOutChatConstructor.newInstance(serializedChatComponent);
    }
}

