/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class FireworkEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int type;
    protected int flightDuration;
    protected int[] colors;
    protected int[] fadeColors;
    protected boolean flicker;
    protected boolean trail;

    public FireworkEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.type = mlc.getInteger("type", 0);
        this.type = mlc.getInteger("t", this.type);
        this.flightDuration = mlc.getInteger("duration", 0);
        this.flightDuration = mlc.getInteger("d", this.flightDuration);
        this.flicker = mlc.getBoolean("flicker", false);
        this.flicker = mlc.getBoolean("f", this.flicker);
        this.trail = mlc.getBoolean("trail", false);
        this.trail = mlc.getBoolean("tr", this.trail);
        String colors = mlc.getString("colors");
        colors = mlc.getString("c", colors);
        this.colors = new int[]{0xFF0000};
        if (colors != null) {
            String[] c = colors.split(",");
            this.colors = new int[c.length];
            for (int i = 0; i < c.length; ++i) {
                this.colors[i] = Integer.parseInt(c[i], 16);
            }
        }
        String fadeColors = mlc.getString("fadecolors");
        fadeColors = mlc.getString("fc", colors);
        this.fadeColors = new int[]{0xFF0000};
        if (fadeColors != null) {
            String[] c = colors.split(",");
            this.fadeColors = new int[c.length];
            for (int i = 0; i < c.length; ++i) {
                this.fadeColors[i] = Integer.parseInt(c[i], 16);
            }
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return false;
    }

    protected void playEffect(AbstractLocation l) {
        MythicMobs.plugin.volatileCodeHandler.CreateFireworksExplosion(BukkitAdapter.adapt(l), this.flicker, this.trail, this.type, this.colors, this.fadeColors, this.flightDuration);
    }
}

