/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.SkillAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class BaseDamageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected double multiplier = 1.0;
    protected boolean ignore_armor = false;
    protected boolean preventKnockback;
    protected boolean preventImmunity;

    public BaseDamageMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.multiplier = mlc.getDouble(new String[]{"multiplier", "m"}, 1.0);
        this.ignore_armor = mlc.getBoolean(new String[]{"ignorearmor", "ia", "i"}, false);
        this.preventKnockback = mlc.getBoolean(new String[]{"preventknockback", "pkb", "pk"}, false);
        this.preventImmunity = mlc.getBoolean(new String[]{"preventimmunity", "pi"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        SkillCaster caster = data.getCaster();
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            if (am.isUsingDamageSkill()) {
                return false;
            }
            double damage = am.getDamage() * this.multiplier * (double)data.getPower();
            MythicMobs.debug(3, "BaseDamage AbstractSkill Fired for " + damage + " with " + data.getPower() + " power");
            SkillAdapter.get().doDamage(data.getCaster(), target, damage, this.ignore_armor, this.preventKnockback, this.preventImmunity);
        } else {
            double damage = this.multiplier * (double)data.getPower();
            MythicMobs.debug(3, "BaseDamage AbstractSkill Fired for " + damage + " with " + data.getPower() + " power");
            SkillAdapter.get().doDamage(data.getCaster(), target, damage, this.ignore_armor, this.preventKnockback, this.preventImmunity);
        }
        return true;
    }
}

