/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Mechanics;

import de.slikey.effectlib.util.ParticleEffect;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Compatibility.CompatibilityManager;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.ITargetedEntitySkill;
import net.elseland.xikage.MythicMobs.Skills.ITargetedLocationSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;

public class AtomEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    ParticleEffect particleNucleus;
    ParticleEffect particleOrbital;
    float radiusN;
    int radius;
    int amountN;
    int amountO;
    int orbitals;
    int rotation;
    int interval;
    int iterations;
    double velocity = 1.0;

    public AtomEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        if (CompatibilityManager.EffectLib == null) {
            return;
        }
        String strParticleNucleus = mlc.getString("particlenucleus", "reddust");
        strParticleNucleus = mlc.getString("particlen", strParticleNucleus);
        strParticleNucleus = mlc.getString("pn", strParticleNucleus);
        this.particleNucleus = CompatibilityManager.EffectLib.getParticleEffect(strParticleNucleus);
        String strParticleOrbital = mlc.getString("particleorbital", "reddust");
        strParticleOrbital = mlc.getString("particleo", strParticleOrbital);
        strParticleOrbital = mlc.getString("po", strParticleOrbital);
        this.particleOrbital = CompatibilityManager.EffectLib.getParticleEffect(strParticleOrbital);
        this.amountN = mlc.getInteger("amountnucleus", 50);
        this.amountN = mlc.getInteger("amountn", this.amountN);
        this.amountN = mlc.getInteger("apn", this.amountN);
        this.amountN = mlc.getInteger("an", this.amountN);
        this.amountO = mlc.getInteger("amountorbital", 100);
        this.amountO = mlc.getInteger("amounto", this.amountO);
        this.amountO = mlc.getInteger("apo", this.amountO);
        this.amountO = mlc.getInteger("ao", this.amountO);
        this.orbitals = mlc.getInteger("orbitals", 2);
        this.orbitals = mlc.getInteger("o", this.orbitals);
        this.radius = mlc.getInteger("radius", 4);
        this.radius = mlc.getInteger("r", this.radius);
        this.radiusN = mlc.getFloat("radiusnucleus", 1.0f);
        this.radiusN = mlc.getFloat("rn", this.radiusN);
        this.rotation = mlc.getInteger("rotation", 0);
        this.rotation = mlc.getInteger("ro", this.rotation);
        this.iterations = mlc.getInteger("ticks", 1);
        this.iterations = mlc.getInteger("t", this.iterations);
        this.interval = mlc.getInteger("interval", 10);
        this.interval = mlc.getInteger("in", this.interval);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (CompatibilityManager.EffectLib == null) {
            return false;
        }
        CompatibilityManager.EffectLib.doAtomEffect(BukkitAdapter.adapt(target), this.particleNucleus, this.amountN, this.particleOrbital, this.amountO, this.orbitals, this.radius, this.radiusN, this.velocity, this.rotation, this.interval, this.iterations);
        return true;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (CompatibilityManager.EffectLib == null) {
            return false;
        }
        CompatibilityManager.EffectLib.doAtomEffect(BukkitAdapter.adapt(target.getLocation()), this.particleNucleus, this.amountN, this.particleOrbital, this.amountO, this.orbitals, this.radius, this.radiusN, this.velocity, this.rotation, this.interval, this.iterations);
        return true;
    }
}

