/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills.Conditions.Conditions;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.Skills.Conditions.IEntityComparisonCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.ILocationComparisonCondition;
import net.elseland.xikage.MythicMobs.Skills.Conditions.MythicCondition;
import net.elseland.xikage.MythicMobs.Util.Generics.RangedDouble;

public class DistanceCondition
extends MythicCondition
implements IEntityComparisonCondition,
ILocationComparisonCondition {
    protected RangedDouble distance;

    public DistanceCondition(String line, MythicLineConfig mlc) {
        super(line);
        String d = mlc.getString(new String[]{"distance", "d"}, this.conditionVar, new String[0]);
        this.distance = new RangedDouble(d, true);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        double diffSq = (float)entity.getLocation().distanceSquared(target.getLocation());
        return this.distance.equals(diffSq);
    }

    @Override
    public boolean check(AbstractLocation location, AbstractLocation target) {
        double diffSq = (float)location.distanceSquared(target);
        return this.distance.equals(diffSq);
    }
}

