/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Skills;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.IO.Load.MythicLineConfig;
import net.elseland.xikage.MythicMobs.LegacySkills.LegacySkillHandler;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.SConditions.SCondition;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Skills.SkillHelper;
import net.elseland.xikage.MythicMobs.Skills.SkillMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillTargeter;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;

public abstract class AbstractSkill
implements Listener {
    protected boolean ASYNC_SAFE = true;
    public static long cooldownTimer = 0L;
    protected UUID uuid;
    protected float cooldown = 0.0f;
    protected float power = 0.0f;
    protected int delay = 0;
    protected int repeat;
    protected int repeatInterval = 0;
    protected float chance = 1.0f;
    protected String target = null;
    protected String healthMod = null;
    protected float powerScale = 1.0f;
    protected boolean powerSplitBetweenTargets = false;
    protected SkillTrigger trigger = SkillTrigger.COMBAT;
    protected boolean sourceIsOrigin = false;
    protected HashMap<UUID, Long> cooldowns = new HashMap();
    protected List<String> conditionsSelf = new ArrayList<String>();
    protected List<String> conditionsTarget = new ArrayList<String>();

    public AbstractSkill() {
        this.uuid = UUID.randomUUID();
    }

    public SkillTrigger getTrigger() {
        return this.trigger;
    }

    public boolean onCooldown(SkillCaster skillCaster) {
        if (this.cooldown == 0.0f) {
            return false;
        }
        Long next = this.cooldowns.get(skillCaster.getEntity().getUniqueId());
        return next != null && next >= cooldownTimer;
    }

    public void setCooldown(SkillCaster skillCaster, float cooldown) {
        if (cooldown > 0.0f) {
            this.cooldowns.put(skillCaster.getEntity().getUniqueId(), (long)((float)cooldownTimer + cooldown * 20.0f - 2.0f));
        } else {
            this.cooldowns.remove(skillCaster.getEntity().getUniqueId());
        }
    }

    public boolean rollChance() {
        if (this.chance == 1.0f) {
            return true;
        }
        return !(MythicMobs.r.nextFloat() > this.chance);
    }

    public boolean checkHealth(SkillCaster skillCaster) {
        String[] healthparts;
        MythicMobs.debug(3, "-- Performing Health Check for skill...");
        if (this.healthMod == null) {
            return true;
        }
        String[] stringArray = healthparts = this.healthMod.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double bosshp;
            String health;
            String healthT = health = stringArray[i];
            String skillstr = skillCaster.getEntity().getUniqueId() + this.uuid.toString() + "#" + health;
            healthT = healthT.replace("%", "");
            healthT = healthT.replace("<", "");
            healthT = healthT.replace(">", "");
            healthT = healthT.replace("=", "");
            if (!(healthT = healthT.replace("-", "")).matches("[-+]?[0-9]*.?[0-9]+")) {
                return true;
            }
            double hp = Double.parseDouble(healthT);
            if (health.endsWith("%")) {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / 100.0;
            } else {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / skillCaster.getEntity().getMaxHealth();
            }
            MythicMobs.debug(3, "-- orighealth = " + health + ", Boss hp = " + bosshp + "%, skill %hp=" + hp);
            if (health.startsWith(">")) {
                MythicMobs.debug(4, "---- Parsing GREATER THAN for skill...");
                health = health.replace(">", "");
                if (!(bosshp > hp)) continue;
                return true;
            }
            if (health.startsWith("<")) {
                MythicMobs.debug(4, "---- Parsing LESS THAN for skill...");
                health = health.replace("<", "");
                if (!(bosshp < hp)) continue;
                return true;
            }
            if (health.startsWith("=")) {
                MythicMobs.debug(4, "---- Parsing EQUAL TO for skill...");
                health = health.replace("=", "");
                if (health.contains("-")) {
                    MythicMobs.debug(4, "---- Parsing RANGE for skill...");
                    String[] hps = health.split("-");
                    double hp1 = hps[0].endsWith("%") ? Double.parseDouble(hps[0].substring(0, hps[0].length() - 1)) / 100.0 : Double.parseDouble(hps[0].substring(0, hps[0].length())) / skillCaster.getEntity().getMaxHealth();
                    double hp2 = hps[1].endsWith("%") ? Double.parseDouble(hps[1].substring(0, hps[1].length() - 1)) / 100.0 : Double.parseDouble(hps[1].substring(0, hps[1].length())) / skillCaster.getEntity().getMaxHealth();
                    if (hp2 > hp1) {
                        double hp3 = hp1;
                        hp1 = hp2;
                        hp2 = hp3;
                    }
                    MythicMobs.debug(4, "------ RANGE scaled to " + hp1 + "-" + hp2);
                    if (!(bosshp > hp2) || !(bosshp < hp1)) continue;
                    return true;
                }
                if (!(bosshp <= hp) || !(skillCaster.getEntity().getHealth() > hp) || SkillHelper.hasUsedSkill(skillstr, skillCaster.getEntity())) continue;
                if (skillCaster instanceof ActiveMob && !((ActiveMob)skillCaster).getType().repeatAllSkills) {
                    MythicMobs.inst().getMobManager();
                    MobManager.setMetaData(skillCaster.getEntity(), skillstr, skillstr);
                }
                return true;
            }
            MythicMobs.debug(3, "-- AbstractSkill Health Check is invalid or not present? Assuming 100% up-time.");
            return true;
        }
        return false;
    }

    public boolean checkSkillTrigger(SkillTrigger trigger) {
        if (trigger == null) {
            return true;
        }
        if (trigger.equals((Object)SkillTrigger.SIGNAL)) {
            return true;
        }
        switch (this.trigger) {
            case TIMER: {
                return true;
            }
            case API: {
                return true;
            }
            case SIGNAL: {
                return true;
            }
            case SPAWN: {
                return trigger == SkillTrigger.SPAWN;
            }
            case DEATH: {
                return trigger == SkillTrigger.DEATH;
            }
            case COMBAT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK;
            }
            case DAMAGED: {
                return trigger == SkillTrigger.DAMAGED;
            }
            case ATTACK: {
                return trigger == SkillTrigger.ATTACK;
            }
            case EXPLODE: {
                return trigger == SkillTrigger.EXPLODE;
            }
            case TELEPORT: {
                return trigger == SkillTrigger.TELEPORT;
            }
            case KILL: {
                return trigger == SkillTrigger.KILL || trigger == SkillTrigger.KILLPLAYER;
            }
            case KILLPLAYER: {
                return trigger == SkillTrigger.KILLPLAYER;
            }
            case ENTERCOMBAT: {
                return trigger == SkillTrigger.ENTERCOMBAT;
            }
            case DROPCOMBAT: {
                return trigger == SkillTrigger.DROPCOMBAT;
            }
            case TARGETCHANGE: {
                return trigger == SkillTrigger.TARGETCHANGE;
            }
            case INTERACT: {
                return trigger == SkillTrigger.INTERACT;
            }
            case DEFAULT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK || trigger == SkillTrigger.SPAWN || trigger == SkillTrigger.DEATH || trigger == SkillTrigger.TIMER;
            }
        }
        return true;
    }

    public boolean checkMobConditions(SkillCaster skillCaster) {
        if (this.conditionsSelf.size() > 0) {
            for (String strCondition : this.conditionsSelf) {
                String[] split = strCondition.split(" ");
                String conditionData = null;
                if (split.length > 1) {
                    conditionData = split[1];
                }
                if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(skillCaster.getEntity().getLocation()), (LivingEntity)skillCaster.getEntity().getBukkitEntity(), conditionData)) continue;
                return false;
            }
        }
        return true;
    }

    public static SkillTrigger parseSkillTrigger(String strTrigger) {
        MythicMobs.debug(3, "-- Performing Trigger Check for skill...");
        String search = strTrigger.substring(1);
        if (search.contains("onTimer")) {
            return SkillTrigger.TIMER;
        }
        switch (search) {
            case "onSpawn": {
                return SkillTrigger.SPAWN;
            }
            case "onDeath": {
                return SkillTrigger.DEATH;
            }
            case "onCombat": {
                return SkillTrigger.COMBAT;
            }
            case "onDamaged": 
            case "onHurt": {
                return SkillTrigger.DAMAGED;
            }
            case "onAttack": {
                return SkillTrigger.ATTACK;
            }
            case "onExplode": {
                return SkillTrigger.EXPLODE;
            }
            case "onTeleport": {
                return SkillTrigger.TELEPORT;
            }
            case "onKill": {
                return SkillTrigger.KILL;
            }
            case "onKillPlayer": 
            case "onPlayerKill": {
                return SkillTrigger.KILLPLAYER;
            }
            case "onPlayerDeath": 
            case "onPlayerDie": {
                return SkillTrigger.PLAYERDEATH;
            }
            case "onEnterCombat": {
                return SkillTrigger.ENTERCOMBAT;
            }
            case "onCombatDrop": 
            case "onDropCombat": {
                return SkillTrigger.DROPCOMBAT;
            }
            case "onChangeTarget": 
            case "onTargetChange": {
                return SkillTrigger.TARGETCHANGE;
            }
            case "onInteract": {
                return SkillTrigger.INTERACT;
            }
            case "onReady": 
            case "onBirth": 
            case "onGenesis": 
            case "onCreation": 
            case "onFirstSpawn": {
                return SkillTrigger.READY;
            }
        }
        return SkillTrigger.DEFAULT;
    }

    public static SkillTargeter parseSkillTargeter(String strTarget) {
        String search = strTarget.substring(1);
        MythicLineConfig mlc = new MythicLineConfig(search);
        String name = search.contains("{") ? search.substring(0, search.indexOf("{")) : search;
        MythicMobs.debug(3, "-- Parsing Targeter '" + search + "' for skill...");
        return SkillTargeter.getMythicTargeter(name, mlc);
    }

    public static void RunTimerSkills(long timer) {
        for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
            am.tickGlobalCooldown(Configuration.ClockInterval);
            if (am.isDead() || !am.getEntity().isValid() || !am.getType().usingTimers) continue;
            AbstractSkill.ExecuteTimerSkills(am, timer);
        }
    }

    public static void RunLegacyTimerSkills(long timer) {
        if (Configuration.EnableLegacySkills) {
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (am.isDead() || !am.getEntity().isValid() || !am.getType().usingTimers) continue;
                LegacySkillHandler.ExecuteTimerSkills(am.getType().legacyTimerSkills, am, timer);
            }
        }
    }

    public static void ExecuteTimerSkills(ActiveMob am, long timer) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.TIMER, am, null);
        data.setPower(am.getPower());
        for (SkillMechanic skill : am.getType().getTimerSkills()) {
            MythicMobs.plugin.getTimingsHandler().markSkillNew(am.getType().getInternalName() + ":" + skill.line);
            if ((double)timer % ((double)skill.interval / (double)Configuration.ClockInterval) == 0.0 && skill.usable(am)) {
                skill.execute(data);
            }
            MythicMobs.plugin.getTimingsHandler().markSkillComplete(am.getType().getInternalName() + ":" + skill.line);
        }
    }

    protected static class DelayedSkill
    implements Runnable {
        private SkillMetadata data;
        private Queue<SkillMechanic> skills;
        private boolean cancelled;

        public DelayedSkill(SkillMetadata data, Queue<SkillMechanic> skills) {
            this.data = data;
            this.skills = skills;
            this.cancelled = false;
        }

        public void cancel() {
            this.skills = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                if (!(!this.data.getCaster().getEntity().isDead() || this.data.getCause().equals((Object)SkillTrigger.DEATH) && this.data.getCause().equals((Object)SkillTrigger.EXPLODE))) {
                    this.cancel();
                    return;
                }
                Skill.execute(this.data, this.skills);
                return;
            }
        }
    }
}

