/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractPlayer;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.event.Listener;

public class EntityManager
implements Listener {
    private Set<AbstractPlayer> cachedAllPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    private ConcurrentHashMap<AbstractWorld, List<AbstractEntity>> cachedLivingEntities;
    private ConcurrentHashMap<AbstractWorld, List<AbstractPlayer>> cachedPlayers = new ConcurrentHashMap();

    public EntityManager() {
        this.cachedLivingEntities = new ConcurrentHashMap();
        this.refreshCaches();
    }

    public synchronized void refreshCaches() {
        this.cachedAllPlayers.clear();
        this.cachedPlayers.clear();
        this.cachedLivingEntities.clear();
        for (AbstractWorld world : MythicMobs.inst().getMinecraftServer().getWorlds()) {
            this.cachedAllPlayers.addAll(world.getPlayers());
            this.cachedPlayers.put(world, world.getPlayers());
            this.cachedLivingEntities.put(world, world.getLivingEntities());
        }
    }

    public synchronized List<AbstractEntity> getLivingEntities(AbstractWorld world) {
        return this.cachedLivingEntities.get(world);
    }

    public synchronized Collection<AbstractPlayer> getPlayers() {
        return this.cachedAllPlayers;
    }

    public synchronized List<AbstractPlayer> getPlayers(AbstractWorld world) {
        return this.cachedPlayers.get(world);
    }

    public synchronized void registerMob(AbstractWorld world, AbstractEntity entity) {
        this.cachedLivingEntities.get(world).add(entity);
    }

    public Set<AbstractPlayer> getPlayersInRangeSq(AbstractLocation location, int rangeSq) {
        HashSet<AbstractPlayer> inRange = new HashSet<AbstractPlayer>();
        this.cachedPlayers.get(location.getWorld()).stream().forEach(player -> {
            if (player.getWorld().equals(location.getWorld()) && player.getLocation().distanceSquared(location) <= (double)rangeSq) {
                inRange.add((AbstractPlayer)player);
            }
        });
        return inRange;
    }
}

