/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs.Entities;

import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.ItemStack;

public class MythicHorse
extends MythicEntity {
    private static final int height = 2;
    int age = 0;
    String horseStyle;
    String horseType;
    String horseColor;
    String horseArmor;
    boolean ageLock;
    boolean horseChest;
    boolean horseSaddled;
    boolean horseTamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.age = mc.getInt("Options.Age", 0);
        this.ageLock = mc.getBoolean("Options.AgeLock", false);
        this.horseArmor = mc.getString("Options.HorseArmor");
        this.horseChest = mc.getBoolean("Options.HorseCarryingChest", false);
        this.horseStyle = mc.getString("Options.HorseStyle");
        this.horseType = mc.getString("Options.HorseType");
        this.horseColor = mc.getString("Options.HorseColor");
        this.horseColor = mc.getString("Options.Color", this.horseColor);
        this.horseSaddled = mc.getBoolean("Options.HorseSaddled", false);
        this.horseSaddled = mc.getBoolean("Options.Saddled", this.horseSaddled);
        this.horseTamed = mc.getBoolean("Options.HorseTamed", false);
        this.horseTamed = mc.getBoolean("Options.Tamed", this.horseTamed);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Horse e = (Horse)location.getWorld().spawnEntity(location, EntityType.HORSE);
        e = this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Horse e = (Horse)location.getWorld().spawnEntity(location, EntityType.HORSE);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Horse e = (Horse)entity;
        e.setAge(this.age);
        e.setAgeLock(this.ageLock);
        HorseInventory hi = e.getInventory();
        if (this.horseStyle != null) {
            e.setStyle(Horse.Style.valueOf((String)this.horseStyle.toUpperCase()));
        }
        if (MythicMobs.inst().getMinecraftVersion() < 11 && this.horseType != null) {
            e.setVariant(Horse.Variant.valueOf((String)this.horseType.toUpperCase()));
        }
        if (this.horseColor != null) {
            try {
                e.setColor(Horse.Color.valueOf((String)this.horseColor.toUpperCase()));
            }
            catch (Exception ex) {
                MythicMobs.error("invalid horse color");
            }
        }
        if (this.horseTamed) {
            e.setTamed(true);
        }
        if (this.horseSaddled) {
            hi.setSaddle(new ItemStack(Material.SADDLE, 1, 0));
        }
        if (this.horseArmor != null) {
            switch (this.horseArmor) {
                case "diamond": {
                    hi.setArmor(new ItemStack(Material.DIAMOND_BARDING, 1, 0));
                    break;
                }
                case "gold": 
                case "golden": {
                    hi.setArmor(new ItemStack(Material.GOLD_BARDING, 1, 0));
                    break;
                }
                default: {
                    hi.setArmor(new ItemStack(Material.IRON_BARDING, 1, 0));
                }
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Horse;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

