/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs.Entities;

import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;

public class MythicBabyZombieVillager
extends MythicEntity {
    private static final int height = 1;
    private double reinforcementChance = -1.0;
    private Villager.Profession villagerProfession;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
        String prof = mc.getString("Options.Profession", "FARMER");
        try {
            this.villagerProfession = Villager.Profession.valueOf((String)prof.toUpperCase());
        }
        catch (Exception ex) {
            this.villagerProfession = Villager.Profession.FARMER;
        }
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            ZombieVillager e = (ZombieVillager)location.getWorld().spawnEntity(location, EntityType.ZOMBIE_VILLAGER);
            e.setBaby(true);
            e = (ZombieVillager)this.applyOptions((Entity)e);
            return e;
        }
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(true);
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            e.setVillagerProfession(this.villagerProfession);
        } else {
            e.setVillager(true);
        }
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            ZombieVillager e = (ZombieVillager)location.getWorld().spawnEntity(location, EntityType.ZOMBIE_VILLAGER);
            e.setBaby(true);
            e = (ZombieVillager)this.applyOptions((Entity)e);
            return e;
        }
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(true);
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            e.setVillagerProfession(this.villagerProfession);
        } else {
            e.setVillager(true);
        }
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            ZombieVillager e = (ZombieVillager)entity;
            e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        } else {
            Zombie e = (Zombie)entity;
            if (this.reinforcementChance >= 0.0) {
                if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                    e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
                } else {
                    MythicMobs.plugin.getVolatileCodeHandler().setZombieSpawnReinforcements(e, this.reinforcementChance);
                }
            }
        }
        return entity;
    }

    @Override
    public boolean compare(Entity e) {
        return MythicBabyZombieVillager.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            if (e instanceof ZombieVillager) {
                return ((ZombieVillager)e).isBaby();
            }
        } else if (e instanceof Zombie) {
            return ((Zombie)e).isBaby() && ((Zombie)e).isVillager();
        }
        return false;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

