/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Mobs.Entities;

import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntity;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Zombie;

public class MythicBabyZombie
extends MythicEntity {
    private static final int height = 1;
    private double reinforcementChance = -1.0;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(true);
        if (MythicMobs.inst().getMinecraftVersion() < 11) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.setVillagerProfession(null);
            } else {
                e.setVillager(false);
            }
        }
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(true);
        if (MythicMobs.inst().getMinecraftVersion() < 11) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.setVillagerProfession(null);
            } else {
                e.setVillager(false);
            }
        }
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Zombie e = (Zombie)entity;
        if (this.reinforcementChance >= 0.0) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
            } else {
                MythicMobs.plugin.getVolatileCodeHandler().setZombieSpawnReinforcements(e, this.reinforcementChance);
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return MythicBabyZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return e instanceof Zombie && (MythicMobs.inst().getMinecraftVersion() >= 11 ? ((Zombie)e).isBaby() : ((Zombie)e).isBaby() && !((Zombie)e).isVillager());
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

