/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.LegacySkills.OldSkills;

import java.util.ArrayList;
import java.util.Set;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectAtom;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectBleed;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectDNA;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectEnderSignal;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectExplosion;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectFirework;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectFlames;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectLightning;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectLightningRing;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectParticleLine;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectParticleRing;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectParticleSquare;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectParticles;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectRadiusFireworks;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectSmoke;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectSound;
import net.elseland.xikage.MythicMobs.LegacySkills.OldSkills.EffectVortex;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillHelper;
import net.elseland.xikage.MythicMobs.Spawners.MythicSpawner;
import net.elseland.xikage.MythicMobs.Spawners.SpawnerManager;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SkillEffect {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ExecuteSkill(LivingEntity l, String skill, LivingEntity target) {
        MythicMobs.debug(2, "Running Effect! SkillString=" + skill);
        String[] base = skill.split(" ");
        String location = base[1];
        String effect = base[2];
        String effectdata = null;
        if (base.length > 3) {
            effectdata = base[3];
        }
        if (location.equals("boss") || location.equals("self")) {
            SkillEffect.EffectHandler(l, l.getLocation(), l, effect, effectdata);
            return;
        } else if (location.equals("target")) {
            Location tl = null;
            if (target == null) {
                if (l instanceof Creature) {
                    target = ((Creature)l).getTarget();
                    if (target != null) {
                        tl = target.getLocation();
                    }
                } else {
                    if (!(l instanceof Player)) return;
                    tl = ((Player)l).getTargetBlock((Set)null, 64).getLocation();
                }
            } else {
                tl = target.getLocation();
            }
            if (tl == null) {
                return;
            }
            SkillEffect.EffectHandler(l, tl, target, effect, effectdata);
            return;
        } else if (location.contains("playersinradius")) {
            int radius = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l).getType().maxAttackRange;
            if (location.contains(":")) {
                String[] split = location.split(":");
                radius = Integer.parseInt(split[1]);
            }
            for (Player p : SkillHelper.getPlayersInRadius(l, radius)) {
                SkillEffect.EffectHandler(l, p.getLocation(), target, effect, effectdata);
            }
            return;
        } else if (location.contains("entitiesinradius")) {
            double radius;
            double radiusY = radius = (double)MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l).getType().maxAttackRange;
            if (location.contains(":")) {
                String[] split = location.split(":");
                radius = Integer.parseInt(split[1]);
                if (split.length > 2) {
                    radiusY = Integer.parseInt((String)split[2]);
                }
            }
            for (Entity e : l.getNearbyEntities(radius, radiusY, radius)) {
                if (!(e instanceof LivingEntity)) continue;
                SkillEffect.EffectHandler(l, e.getLocation(), target, effect, effectdata);
            }
            return;
        } else if (location.contains("mythicmobsinradius")) {
            double radius;
            double radiusY = radius = (double)MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l).getType().maxAttackRange;
            if (location.contains(":")) {
                String[] split = location.split(":");
                radius = Integer.parseInt(split[1]);
                if (split.length > 2) {
                    radiusY = Integer.parseInt((String)split[2]);
                }
            }
            for (Entity e : l.getNearbyEntities(radius, radiusY, radius)) {
                if (!MythicMobs.inst().getMobManager().isActiveMob(e.getUniqueId())) continue;
                SkillEffect.EffectHandler(l, e.getLocation(), target, effect, effectdata);
            }
            return;
        } else if (location.contains("threattargets")) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l);
            if (am == null) {
                return;
            }
            if (!am.getType().usesThreatTable()) {
                return;
            }
            for (AbstractEntity p : am.getThreatTable().getAllThreatTargets()) {
                SkillEffect.EffectHandler(l, BukkitAdapter.adapt(p).getLocation(), target, effect, effectdata);
            }
            return;
        } else if (location.contains("location")) {
            try {
                String[] split = location.split(":");
                String[] coords = split[1].split(",");
                double x = Double.parseDouble(coords[0]);
                double y = Double.parseDouble(coords[1]);
                double z = Double.parseDouble(coords[2]);
                Location tl = new Location(l.getWorld(), x, y, z);
                SkillEffect.EffectHandler(l, tl, target, effect, effectdata);
                return;
            }
            catch (Exception ex) {
                MythicMobs.error("You have an incorrectly configured @location effect: Format is location:x,y,z! String=" + skill);
                ex.printStackTrace();
            }
            return;
        } else {
            if (!location.contains("spawner")) return;
            try {
                String[] split = location.split(":");
                if (split[1].equalsIgnoreCase("g") && split.length > 2) {
                    MythicMobs.debug(3, "-- Executing effects on spawner group " + split[2]);
                    ArrayList<MythicSpawner> msl = SpawnerManager.getSpawnersByGroup(split[2]);
                    for (MythicSpawner ms : msl) {
                        Location loc = BukkitAdapter.adapt(ms.getLocation()).clone().add(0.5, 0.5, 0.5);
                        SkillEffect.EffectHandler(l, loc, target, effect, effectdata);
                    }
                    return;
                }
                MythicSpawner ms = SpawnerManager.getSpawnerByName(split[1]);
                Location loc = BukkitAdapter.adapt(ms.getLocation()).clone().add(0.5, 0.5, 0.5);
                SkillEffect.EffectHandler(l, loc, target, effect, effectdata);
                return;
            }
            catch (Exception ex) {
                MythicMobs.error("You have an incorrectly configured @spawner effect: Format is spawner:[spawnername]! String=" + skill);
                ex.printStackTrace();
            }
        }
    }

    public static void EffectHandler(LivingEntity sourceentity, Location targetlocation, LivingEntity targetentity, String effect, String effectdata) {
        MythicMobs.debug(3, "-- Executing effect " + effect + ". EffectData=" + effectdata);
        switch (effect) {
            case "endersignal": 
            case "ender": {
                EffectEnderSignal.DoEffect(targetlocation);
                break;
            }
            case "explosion": 
            case "explode": {
                EffectExplosion.DoEffect(targetlocation);
                break;
            }
            case "firework": 
            case "fireworks": {
                EffectFirework.DoEffect(targetlocation, effectdata);
                break;
            }
            case "flames": {
                EffectFlames.DoEffect(targetlocation);
                break;
            }
            case "lightning": {
                EffectLightning.DoEffect(targetlocation);
                break;
            }
            case "lightningring": {
                EffectLightningRing.DoEffect(targetlocation, effectdata);
                break;
            }
            case "particles": 
            case "p": {
                EffectParticles.DoEffect(targetlocation, effectdata);
                break;
            }
            case "particleline": 
            case "pl": {
                EffectParticleLine.DoEffect(sourceentity, targetlocation, effectdata);
                break;
            }
            case "particlering": 
            case "pr": {
                EffectParticleRing.DoEffect(targetlocation, effectdata);
                break;
            }
            case "particlesquare": {
                EffectParticleSquare.DoEffect(targetlocation, effectdata);
                break;
            }
            case "radiusfireworks": 
            case "radiusfirework": {
                EffectRadiusFireworks.DoEffect(targetlocation, effectdata);
                break;
            }
            case "smoke": {
                EffectSmoke.DoEffect(targetlocation, effectdata);
                break;
            }
            case "sound": 
            case "s": {
                EffectSound.DoEffect(targetlocation, effectdata);
                break;
            }
            case "atom": {
                EffectAtom.DoEffect(targetlocation, effectdata);
                break;
            }
            case "bleed": {
                EffectBleed.DoEffect(targetentity, effectdata);
                break;
            }
            case "dna": {
                EffectDNA.DoEffect(sourceentity.getLocation(), targetlocation, effectdata);
                break;
            }
            case "vortex": {
                EffectVortex.DoEffect(targetlocation, effectdata);
            }
        }
    }
}

