/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.IO.Load;

import java.util.HashMap;
import net.elseland.xikage.MythicMobs.MythicMobs;

public class MythicLineConfig {
    private String line;
    private HashMap<String, String> config = new HashMap();

    public MythicLineConfig(String s) {
        String[] split2;
        String[] split;
        this.line = s;
        MythicMobs.debug(4, "~ LOADING LineConfig FOR LINE: " + s);
        if (s.contains("{") && s.contains("}")) {
            try {
                split = s.split("\\{");
                s = split[1];
                split2 = s.split("\\}");
                s = split2[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                MythicMobs.throwSevere("error-config-load-badbrackets", "Could not load LineConfig: Invalid syntax. String = {0}", s);
                return;
            }
        }
        if (s.contains("[") && s.contains("]")) {
            try {
                split = s.split("\\[");
                s = split[1];
                split2 = s.split("\\]");
                s = split2[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                MythicMobs.throwSevere("error-config-load-badbrackets", "Could not load LineConfig: Invalid syntax. String = {0}", s);
                return;
            }
        }
        MythicMobs.debug(4, "~~~ LINE REDUCED TO: " + s);
        for (String i : split = s.split(";")) {
            String[] j = i.split("=");
            if (j.length != 2) continue;
            MythicMobs.debug(4, "~~~~~ LOADED ELEMENT " + j[0] + " == " + j[1]);
            this.config.put(j[0].toLowerCase(), j[1]);
        }
    }

    public String getLine() {
        return this.line;
    }

    public int size() {
        return this.config.size();
    }

    public static String getKey(String s) {
        String key = null;
        key = s.contains("{") ? s.substring(0, s.indexOf("{")) : (s.contains("[") ? s.substring(0, s.indexOf("[")) : s);
        return key;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        String s = this.config.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public boolean getBoolean(String[] key, boolean def) {
        String k;
        String s = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s = this.config.get(k = stringArray[i])) == null; ++i) {
        }
        if (s == null) {
            return def;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String[] key) {
        return this.getString(key, null, new String[0]);
    }

    public String getString(String key, String def) {
        MythicMobs.debug(4, "~ Requested LineConfig element " + key);
        String s = this.config.get(key);
        if (s == null) {
            MythicMobs.debug(4, "~~~ No element found, returning default");
            return def;
        }
        MythicMobs.debug(4, "~~~ Found config element " + key + " = " + s);
        return s;
    }

    public String getString(String[] key, String def, String ... args) {
        MythicMobs.debug(4, "~ Requested LineConfig element " + key);
        String s = null;
        for (String k : key) {
            s = this.config.get(k);
            if (s == null) continue;
            return s;
        }
        for (String a : args) {
            if (a == null) continue;
            return a;
        }
        MythicMobs.debug(4, "~~~ No element found, returning default");
        return def;
    }

    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String[] key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String key, int def) {
        String s = this.config.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public int getInteger(String[] key, int def) {
        String k;
        String s = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s = this.config.get(k = stringArray[i])) == null; ++i) {
        }
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String[] key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double def) {
        String s = this.config.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public double getDouble(String[] key, double def) {
        String k;
        String s = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s = this.config.get(k = stringArray[i])) == null; ++i) {
        }
        if (s == null) {
            return def;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String[] key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float def) {
        String s = this.config.get(key);
        if (s == null) {
            return def;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public float getFloat(String[] key, float def) {
        String k;
        String s = null;
        String[] stringArray = key;
        int n = stringArray.length;
        for (int i = 0; i < n && (s = this.config.get(k = stringArray[i])) == null; ++i) {
        }
        if (s == null) {
            return def;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (Exception ex) {
            return def;
        }
    }
}

