/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.IO.Load;

import java.io.File;
import java.util.List;
import net.elseland.xikage.MythicMobs.IO.IOHandler;
import net.elseland.xikage.MythicMobs.IO.IOLoader;
import net.elseland.xikage.MythicMobs.IO.Load.LoadDropTables;
import net.elseland.xikage.MythicMobs.IO.Load.LoadItems;
import net.elseland.xikage.MythicMobs.IO.Load.LoadMythicSpawners;
import net.elseland.xikage.MythicMobs.IO.Load.LoadRandomSpawners;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.IO.Save.SaveSpawners;
import net.elseland.xikage.MythicMobs.Mobs.WorldScaling;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.SkillString;
import net.elseland.xikage.MythicMobs.Spawners.MythicSpawner;

public class Configuration {
    public static List<File> MobFiles;
    public static List<File> ItemFiles;
    public static List<File> LootFiles;
    public static List<File> TimerFiles;
    public static List<File> SpawningFiles;
    public static List<File> SpawnerFiles;
    public static int ClockInterval;
    public static int debugLevel;
    public static boolean debugMode;
    public static boolean debugSpawners;
    public static boolean errorLogging;
    public static int SaveInteval;
    public static int SpawningInterval;
    public static int timerupdate;
    public static int walkupdate;
    public static int ShowHealthRadius;
    public static int ScanInterval;
    public static int ClnrInterval;
    public static boolean AllowMetrics;
    public static boolean UseCompatibilityMode;
    public static boolean UseVolatileFeatures;
    public static String ShowHealthFormat;
    public static String KillMessagePrefix;
    public static boolean AllowUpdateChecking;
    public static int SpawnerRange;
    public static boolean EnableAIModifiers;
    public static boolean EnableTimerSkills;
    public static boolean EnableThreatTables;
    public static boolean EnablePlayerFactions;
    public static boolean EnableLegacySkills;
    public static String defaultLevelModifierHealth;
    public static String defaultLevelModifierDamage;
    public static String defaultLevelModifierPower;
    public static String defaultLevelModifierArmor;
    public static String defaultLevelModifierKBR;
    public static boolean apiUseDeathEvent;
    public static boolean apiUseSkillEvent;
    public static boolean apiUseCustomSkillEvent;
    public static boolean compatHeroesXPEnable;
    public static boolean compatHeroesShowXPMessage;
    public static String compatHeroesXPMessageFormat;
    public static boolean compatSkillAPIShowXPMessage;
    public static String compatSkillAPIXPMessageFormat;
    public static boolean compatVaultShowMoneyMessage;
    public static String compatVaultMoneyMessageFormat;
    public static boolean compatMcMMOShowXPMessage;
    public static String compatMcMMOXPMessageFormat;
    private static boolean rsGeneratePoints;
    private static int rsMaxMobsPerChunk;
    private static int rsPlayerRadius;
    private static int rsPlayerRadiusY;
    private static int rsPointsPerSecondLand;
    private static int rsPointsPerSecondAir;
    private static int rsPointsPerSecondSea;
    private static int rsPointsPerSecondLava;
    private static int rsPointsPerSecondGround;
    private static int rsMaxGenerationTimeMillis;
    private static boolean rsDespawnVanillaOutsideRadius;

    public static void SaveAll() {
        MythicMobs.inst().getMobManager().saveCachedActiveMobs();
        SaveSpawners.SaveAll();
    }

    public static void ResetAll() {
        MythicMobs.plugin.saveItemList.clear();
        MythicMobs.plugin.saveDropTablesList.clear();
        MythicMobs.plugin.saveRandomSpawnerList.clear();
        MythicMobs.inst().mmSpawnerHashcodeLookup.clear();
        MythicMobs.plugin.listDropTables.clear();
        MythicMobs.plugin.listItems.clear();
        MythicMobs.plugin.listLegacySkills.clear();
        MythicMobs.plugin.listRandomSpawningA.clear();
        MythicMobs.plugin.listRandomSpawningR.clear();
        MythicMobs.plugin.listSpawners.clear();
        MythicMobs.plugin.unregisterSkillEvents();
    }

    public static void LoadAll(boolean msg) {
        MythicMobs.plugin.items = new IOLoader(MythicMobs.plugin, "ExampleItems.yml", "Items");
        MythicMobs.plugin.droptables = new IOLoader(MythicMobs.plugin, "ExampleDropTables.yml", "DropTables");
        MythicMobs.plugin.spawning = new IOLoader(MythicMobs.plugin, "ExampleRandomSpawns.yml", "RandomSpawns");
        MythicMobs.plugin.settings = new IOLoader(MythicMobs.plugin, "config.yml");
        ItemFiles = IOHandler.getAllFiles(MythicMobs.plugin.items.thefile.getParent());
        LootFiles = IOHandler.getAllFiles(MythicMobs.plugin.droptables.thefile.getParent());
        SpawningFiles = IOHandler.getAllFiles(MythicMobs.plugin.spawning.thefile.getParent());
        File SpawnerFile = new File(MythicMobs.plugin.getDataFolder() + System.getProperty("file.separator") + "Spawners");
        if (!SpawnerFile.exists()) {
            MythicMobs.log("Spawners folder not found! Creating...");
            SpawnerFile.mkdir();
        }
        SpawnerFiles = IOHandler.getAllFiles(MythicMobs.plugin.getDataFolder() + System.getProperty("file.separator") + "Spawners");
        MythicMobs.plugin.saveItemList = IOHandler.getSaveLoad(ItemFiles, "Items");
        MythicMobs.plugin.saveDropTablesList = IOHandler.getSaveLoad(LootFiles, "DropTables");
        MythicMobs.plugin.saveMythicSpawnerList = IOHandler.getSaveLoad(SpawnerFiles, "Spawners");
        MythicMobs.plugin.saveRandomSpawnerList = IOHandler.getSaveLoad(SpawningFiles, "RandomSpawns");
        Configuration.loadSettings();
        LoadItems.LoadAllItems();
        MythicMobs.inst().getSkillManager().loadSkills();
        MythicMobs.inst().getMobManager().loadMobs();
        LoadDropTables.LoadAllDropTables();
        LoadRandomSpawners.LoadSpawners();
        LoadMythicSpawners.LoadSpawners();
        MythicMobs.inst().getSkillManager().runSecondPass();
        MythicSpawner.buildSpawnerChunkLookupTable();
        MythicMobs.log("Loaded " + MythicMobs.inst().getMobManager().getMobTypes().size() + " mobs.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getMobManager().getVanillaTypes().size() + " vanilla mob overrides.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getMobManager().getMobStacks().size() + " mob stacks.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getSkillManager().getSkills().size() + " skills.");
        MythicMobs.log("Loaded " + (MythicMobs.plugin.listRandomSpawningA.size() + MythicMobs.plugin.listRandomSpawningR.size()) + " random spawns.");
        MythicMobs.log("Loaded " + MythicMobs.plugin.listItems.size() + " mythic items.");
        MythicMobs.log("Loaded " + MythicMobs.plugin.listDropTables.size() + " drop tables.");
        MythicMobs.log("Loaded " + MythicMobs.plugin.listSpawners.size() + " mob spawners.");
    }

    public static void loadSettings() {
        Configuration.loadLegacySettings();
        MythicMobs.debug(1, "* Checking for Settings...");
        if (!MythicMobs.plugin.settings.getCustomConfig().contains("Configuration.Version")) {
            return;
        }
        MythicMobs.debug(1, "** Loading Settings...");
        MythicConfig mc = new MythicConfig("Configuration", MythicMobs.plugin.settings.getCustomConfig());
        AllowMetrics = mc.getBoolean("General.AllowMetrics", true);
        if (debugLevel == -1) {
            debugLevel = mc.getInt("General.DebugLevel", 0);
        }
        errorLogging = mc.getBoolean("General.ErrorLogging", true);
        UseCompatibilityMode = mc.getBoolean("General.Compatibilitymode", false);
        UseVolatileFeatures = mc.getBoolean("General.UseVolatileFeatures", true);
        AllowUpdateChecking = mc.getBoolean("General.CheckForUpdates", true);
        int i = mc.getInt("Clock.SaveInterval", 5);
        SaveInteval = i * 60;
        ClockInterval = mc.getInt("Clock.ClockInterval", 5);
        SpawningInterval = mc.getInt("Clock.SpawnsInterval", 2);
        ScanInterval = mc.getInt("Clock.ScannerInterval", 10);
        ClnrInterval = mc.getInt("Clock.CleanupInterval", 600);
        EnableAIModifiers = mc.getBoolean("Mobs.EnableAIModifiers", true);
        EnableTimerSkills = mc.getBoolean("Mobs.EnableTimerSkills", true);
        EnableLegacySkills = mc.getBoolean("Mobs.EnableLegacySkills", false);
        EnableThreatTables = mc.getBoolean("Mobs.EnableThreatTables", true);
        EnablePlayerFactions = mc.getBoolean("Mobs.EnablePlayerFactions", true);
        ShowHealthRadius = mc.getInt("Mobs.ShowHealth.Radius", 25);
        ShowHealthFormat = mc.getString("Mobs.ShowHealth.Format", ShowHealthFormat);
        KillMessagePrefix = SkillString.parseMessageSpecialChars(mc.getString("Mobs.KillMessagePrefix", KillMessagePrefix));
        rsGeneratePoints = mc.getBoolean("RandomSpawning.GenerateSpawnPoints", false);
        rsMaxMobsPerChunk = mc.getInt("RandomSpawning.MaxMobsPerChunk", 20);
        rsPlayerRadius = mc.getInt("RandomSpawning.SpawnRadiusPerPlayer", 64);
        rsPlayerRadiusY = mc.getInt("RandomSpawning.SpawnRadiusPerPlayerY", 16);
        rsPointsPerSecondLand = mc.getInt("RandomSpawning.PointsPerSecond.Land", 10);
        rsPointsPerSecondAir = mc.getInt("RandomSpawning.PointsPerSecond.Air", 1);
        rsPointsPerSecondSea = mc.getInt("RandomSpawning.PointsPerSecond.Sea", 1);
        rsPointsPerSecondLava = mc.getInt("RandomSpawning.PointsPerSecond.Lava", 0);
        rsPointsPerSecondGround = mc.getInt("RandomSpawning.PointsPerSecond.Ground", 0);
        rsDespawnVanillaOutsideRadius = mc.getBoolean("RandomSpawning.DespawnLazyRandomMobs", true);
        rsMaxGenerationTimeMillis = mc.getInt("RandomSpawning.MaxGenerationTime", 20);
        compatHeroesXPEnable = mc.getBoolean("Compatibility.Heroes.Enabled", compatHeroesXPEnable);
        compatHeroesShowXPMessage = mc.getBoolean("Compatibility.Heroes.ShowXPMessage", compatHeroesShowXPMessage);
        compatHeroesXPMessageFormat = mc.getString("Compatibility.Heroes.XPMessageFormat", compatHeroesXPMessageFormat);
        compatMcMMOShowXPMessage = mc.getBoolean("Compatibility.McMMO.ShowXPMessage", compatMcMMOShowXPMessage);
        compatMcMMOXPMessageFormat = mc.getString("Compatibility.McMMO.XPMessageFormat", compatMcMMOXPMessageFormat);
        compatSkillAPIShowXPMessage = mc.getBoolean("Compatibility.SkillAPI.ShowXPMessage", compatSkillAPIShowXPMessage);
        compatSkillAPIXPMessageFormat = mc.getString("Compatibility.SkillAPI.XPMessageFormat", compatSkillAPIXPMessageFormat);
        compatVaultShowMoneyMessage = mc.getBoolean("Compatibility.Vault.ShowMoneyMessage", compatVaultShowMoneyMessage);
        compatVaultMoneyMessageFormat = mc.getString("Compatibility.Vault.MoneyMessageFormat", compatVaultMoneyMessageFormat);
        compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
        compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
        compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
        compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        MythicMobs.debug(1, "** Loading WorldScaling Settings...");
        WorldScaling.reset();
        if (MythicMobs.plugin.settings.getCustomConfig().contains("Configuration.Mobs.Scaling")) {
            for (String world : MythicMobs.plugin.settings.getCustomConfig().getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                MythicMobs.debug(1, "*** Loading WorldScaling for world " + world);
                MythicConfig wmc = new MythicConfig("Configuration.Mobs.Scaling." + world, MythicMobs.plugin.settings.getCustomConfig());
                WorldScaling.initialize(world, wmc);
            }
        }
        MythicMobs.debug(1, "** Finished Load WorldScaling Settings!");
        MythicMobs.debug(1, "** Loading Default Level Modifiers...");
        defaultLevelModifierHealth = mc.getString("Mobs.DefaultLevelModifiers.Health", "0.1");
        defaultLevelModifierDamage = mc.getString("Mobs.DefaultLevelModifiers.Damage", "0");
        defaultLevelModifierPower = mc.getString("Mobs.DefaultLevelModifiers.Power", "0");
        defaultLevelModifierArmor = mc.getString("Mobs.DefaultLevelModifiers.Armor", "0");
        defaultLevelModifierKBR = mc.getString("Mobs.DefaultLevelModifiers.KnockbackResistance", "0");
        MythicMobs.debug(1, "**** Default Level Modifiers - Health: " + defaultLevelModifierHealth);
        MythicMobs.debug(1, "**** Default Level Modifiers - Damage: " + defaultLevelModifierDamage);
        MythicMobs.debug(1, "**** Default Level Modifiers - Power: " + defaultLevelModifierPower);
        MythicMobs.debug(1, "**** Default Level Modifiers - Armor: " + defaultLevelModifierArmor);
        MythicMobs.debug(1, "**** Default Level Modifiers - KBR: " + defaultLevelModifierKBR);
        MythicMobs.debug(1, "** Finished Load Default Level Modifiers!");
    }

    public static void loadLegacySettings() {
        MythicMobs.debug(1, "* Checking for Legacy Settings...");
        if (MythicMobs.plugin.settings.getCustomConfig().contains("general.debug-level")) {
            MythicMobs.debug(1, "** Loading Legacy Settings...");
            if (debugLevel == 0) {
                debugLevel = MythicMobs.plugin.settings.getCustomConfig().getInt("general.debug-level", 0);
            }
            errorLogging = MythicMobs.plugin.settings.getCustomConfig().getBoolean("general.error-logging", true);
            int i = MythicMobs.plugin.settings.getCustomConfig().getInt("general.save-interval", 5);
            SaveInteval = i * 60;
            ClockInterval = MythicMobs.plugin.settings.getCustomConfig().getInt("general.clock-interval", ClockInterval);
            SpawningInterval = MythicMobs.plugin.settings.getCustomConfig().getInt("general.spawns-interval", SpawningInterval);
            ScanInterval = MythicMobs.plugin.settings.getCustomConfig().getInt("general.scanner-interval", ScanInterval);
            ClnrInterval = MythicMobs.plugin.settings.getCustomConfig().getInt("general.cleanup-interval", ClnrInterval);
            EnableTimerSkills = MythicMobs.plugin.settings.getCustomConfig().getBoolean("mobs.enable-timer-skills", EnableTimerSkills);
            EnableLegacySkills = MythicMobs.plugin.settings.getCustomConfig().getBoolean("mobs.enable-legacy-skills", EnableLegacySkills);
            EnableThreatTables = MythicMobs.plugin.settings.getCustomConfig().getBoolean("mobs.enable-threat-tables", EnableThreatTables);
            EnablePlayerFactions = MythicMobs.plugin.settings.getCustomConfig().getBoolean("enable-player-factions", EnablePlayerFactions);
            ShowHealthRadius = MythicMobs.plugin.settings.getCustomConfig().getInt("mobs.show-health-radius", ShowHealthRadius);
            ShowHealthFormat = MythicMobs.plugin.settings.getCustomConfig().getString("mobs.show-health-format", ShowHealthFormat);
            KillMessagePrefix = MythicMobs.plugin.settings.getCustomConfig().getString("mobs.kill-message-prefix", KillMessagePrefix);
            UseCompatibilityMode = MythicMobs.plugin.settings.getCustomConfig().getBoolean("general.compatibility-mode", UseCompatibilityMode);
            UseVolatileFeatures = MythicMobs.plugin.settings.getCustomConfig().getBoolean("general.use-volatile-features");
            AllowUpdateChecking = MythicMobs.plugin.settings.getCustomConfig().getBoolean("general.check-for-updates");
            AllowMetrics = MythicMobs.plugin.settings.getCustomConfig().getBoolean("metrics.allow");
            compatHeroesXPEnable = MythicMobs.plugin.settings.getCustomConfig().getBoolean("compatibility.heroes-xp-enable", compatHeroesXPEnable);
            compatHeroesShowXPMessage = MythicMobs.plugin.settings.getCustomConfig().getBoolean("compatibility.heroes-show-xp-message", compatHeroesShowXPMessage);
            compatHeroesXPMessageFormat = MythicMobs.plugin.settings.getCustomConfig().getString("compatibility.heroes-xp-message-format", compatHeroesXPMessageFormat);
            compatMcMMOShowXPMessage = MythicMobs.plugin.settings.getCustomConfig().getBoolean("compatibility.mcmmo-show-xp-message", compatMcMMOShowXPMessage);
            compatMcMMOXPMessageFormat = MythicMobs.plugin.settings.getCustomConfig().getString("compatibility.mcmmo-xp-message-format", compatMcMMOXPMessageFormat);
            compatSkillAPIShowXPMessage = MythicMobs.plugin.settings.getCustomConfig().getBoolean("compatibility.skillapi-show-xp-message", compatSkillAPIShowXPMessage);
            compatSkillAPIXPMessageFormat = MythicMobs.plugin.settings.getCustomConfig().getString("compatibility.skillapi-xp-message-format", compatSkillAPIXPMessageFormat);
            compatVaultShowMoneyMessage = MythicMobs.plugin.settings.getCustomConfig().getBoolean("compatibility.vault-show-money-message", compatVaultShowMoneyMessage);
            compatVaultMoneyMessageFormat = MythicMobs.plugin.settings.getCustomConfig().getString("compatibility.vault-money-message-format", compatVaultMoneyMessageFormat);
            compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
            compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
            compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
            compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        }
    }

    public static boolean generateRSPoints() {
        return rsGeneratePoints;
    }

    public static int getRSMaxMobsPerChunk() {
        return rsMaxMobsPerChunk;
    }

    public static int getRSPlayerRadius() {
        return rsPlayerRadius;
    }

    public static int getRSPlayerRadiusY() {
        return rsPlayerRadiusY;
    }

    public static int getRSPointsPerSecondLand() {
        return rsPointsPerSecondLand;
    }

    public static int getRSPointsPerSecondAir() {
        return rsPointsPerSecondAir;
    }

    public static int getRSPointsPerSecondSea() {
        return rsPointsPerSecondSea;
    }

    public static int getRSPointsPerSecondLava() {
        return rsPointsPerSecondLava;
    }

    public static int getRSPointsPerSecondGround() {
        return rsPointsPerSecondGround;
    }

    public static int getRSMaxGenerationTimeMillis() {
        return rsMaxGenerationTimeMillis;
    }

    public static boolean getRSDespawnVanillaOutsideRadius() {
        return rsDespawnVanillaOutsideRadius;
    }

    static {
        ClockInterval = 1;
        debugLevel = -1;
        debugMode = false;
        debugSpawners = false;
        errorLogging = true;
        SaveInteval = 300;
        SpawningInterval = 1;
        ShowHealthRadius = 25;
        ScanInterval = 10;
        ClnrInterval = 600;
        AllowMetrics = true;
        UseCompatibilityMode = false;
        UseVolatileFeatures = true;
        ShowHealthFormat = "$mobname: $mobhp / $mobmaxhp";
        KillMessagePrefix = "";
        AllowUpdateChecking = true;
        SpawnerRange = 40;
        EnableAIModifiers = true;
        EnableTimerSkills = true;
        EnableThreatTables = true;
        EnablePlayerFactions = true;
        EnableLegacySkills = true;
        apiUseDeathEvent = true;
        apiUseSkillEvent = true;
        apiUseCustomSkillEvent = true;
        compatHeroesXPEnable = false;
        compatHeroesShowXPMessage = true;
        compatHeroesXPMessageFormat = "";
        compatSkillAPIShowXPMessage = true;
        compatSkillAPIXPMessageFormat = "";
        compatVaultShowMoneyMessage = true;
        compatVaultMoneyMessageFormat = "";
        compatMcMMOShowXPMessage = true;
        compatMcMMOXPMessageFormat = "";
        rsGeneratePoints = false;
        rsMaxMobsPerChunk = 20;
        rsPlayerRadius = 64;
        rsPlayerRadiusY = 16;
        rsPointsPerSecondLand = 10;
        rsPointsPerSecondAir = 0;
        rsPointsPerSecondSea = 1;
        rsPointsPerSecondLava = 0;
        rsPointsPerSecondGround = 0;
        rsMaxGenerationTimeMillis = 20;
        rsDespawnVanillaOutsideRadius = false;
    }
}

