/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Compatibility;

import com.kirelcodes.miniaturepets.api.pets.APIMob;
import com.kirelcodes.miniaturepets.api.pets.APIMobContainer;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.MythicConfig;
import net.elseland.xikage.MythicMobs.MythicMobs;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class MPetCompat {

    public class MiniaturePetType {
        private APIMobContainer mType;
        private String display;
        private boolean showName;
        private boolean valid = false;

        public MiniaturePetType(MythicConfig mc) {
            String type = mc.getString("MiniaturePet.Type", null);
            String anchor = mc.getString("MiniaturePet.Anchor", null);
            double speed = mc.getDouble("Options.MovementSpeed", 0.17);
            this.showName = mc.getBoolean("MiniaturePet.ShowName", false);
            this.showName = mc.getBoolean("MPet.ShowName", this.showName);
            this.display = mc.getString("displayName", "");
            if (type == null) {
                type = mc.getString("MPet.Type", null);
            }
            if (anchor == null) {
                anchor = mc.getString("MPet.Anchor", null);
            }
            try {
                EntityType anchorType = EntityType.valueOf((String)anchor.toUpperCase());
                MythicMobs.log("Loading MPet type " + type + " with anchor " + anchor);
                this.mType = new APIMobContainer(type, type, 20.0, speed, anchorType, anchorType.toString().toLowerCase());
            }
            catch (Exception ex) {
                MythicMobs.error("Invalid MiniaturePet Anchor type: " + anchor);
                ex.printStackTrace();
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public Entity spawn(AbstractLocation location) {
            Location loc = BukkitAdapter.adapt(location);
            APIMob mob = this.mType.spawnMob(loc);
            if (this.showName) {
                mob.setCustomName(this.display);
            }
            return mob.getNavigator();
        }
    }
}

