/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events;

import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MobManager;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.QueuedMobSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.ProjectileSource;

public class SkillTriggerAD
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void MobSkillEvent(EntityDamageByEntityEvent e) {
        ActiveMob am;
        ProjectileSource ps;
        MythicMobs.debug(3, "EntityDamageByEntityEvent fired for " + e.getFinalDamage());
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        AbstractEntity damager = e.getDamager() instanceof LivingEntity ? BukkitAdapter.adapt(e.getDamager()) : (e.getDamager() instanceof Projectile ? ((ps = ((Projectile)e.getDamager()).getShooter()) instanceof LivingEntity ? BukkitAdapter.adapt((Entity)((LivingEntity)ps)) : null) : null);
        AbstractEntity damaged = e.getEntity() instanceof LivingEntity ? BukkitAdapter.adapt(e.getEntity()) : null;
        if (damaged != null && MythicMobs.inst().getMobManager().isActiveMob(damaged.getUniqueId())) {
            am = MythicMobs.inst().getMobManager().getMythicMobInstance(damaged);
            if (damager != null && MythicMobs.inst().getMobManager().isActiveMob(damager.getUniqueId())) {
                ActiveMob am2 = MythicMobs.inst().getMobManager().getMythicMobInstance(damager);
                if (am.getFaction() != null && am2.getFaction() != null && am.getFaction().equals(am2.getFaction())) {
                    e.setCancelled(true);
                    return;
                }
            }
            if (am.getType().maxAttackableRange > 0 && damager != null) {
                if (damaged.getLocation().distanceSquared(damager.getLocation()) > Math.pow(am.getType().maxAttackableRange, 2.0)) {
                    MythicMobs.debug(3, "---- Damager is out of MaxCombatRange, cancelling damage.");
                    e.setCancelled(true);
                    return;
                }
            } else if (am.getType().maxAttackableRange == 0) {
                MythicMobs.debug(3, "---- MythicMob is not attackable, cancelling damage.");
                e.setCancelled(true);
                return;
            }
            if (am.getType().getShowHealthInChat()) {
                MythicMobs.inst().getMobManager();
                MobManager.showHealth(am);
            }
            new QueuedMobSkill(SkillTrigger.DAMAGED, am, damager);
            if (am.getType().usesThreatTable() && damager != null && !am.getEntity().getUniqueId().equals(damager.getUniqueId()) && am.getType().getThreatTableUseDamageTaken()) {
                am.getThreatTable().threatGain(damager, e.getDamage());
            }
            if (am.getType().getEntityDamageModifiers() != null) {
                double damage = e.getDamage();
                for (String dm : am.getType().getEntityDamageModifiers()) {
                    String[] split = dm.split(" ");
                    try {
                        if (EntityType.valueOf((String)split[0].toUpperCase()) != e.getDamager().getType()) continue;
                        if ((damage *= Double.parseDouble(split[1])) > 0.0) {
                            e.setDamage(damage);
                            continue;
                        }
                        if (damage == 0.0) {
                            e.setDamage(0.0);
                            continue;
                        }
                        if (!(damage < 0.0)) continue;
                        e.setDamage(0.0);
                        e.setCancelled(true);
                        if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                            damaged.setHealth(damaged.getMaxHealth());
                            continue;
                        }
                        damaged.setHealth(damaged.getHealth() - damage);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (damager != null && MythicMobs.inst().getMobManager().isActiveMob(damager.getUniqueId())) {
            MythicMobs.debug(3, "A MythicMob attacked something for " + e.getOriginalDamage(EntityDamageEvent.DamageModifier.BASE));
            am = MythicMobs.inst().getMobManager().getMythicMobInstance(damager);
            MythicMobs.debug(3, "-- Attacking mob was " + am.getType().getInternalName() + "!");
            if (am.getOwner().isPresent() && am.getOwner().get().equals(damaged.getUniqueId())) {
                e.setCancelled(true);
                return;
            }
            if (am.isUsingDamageSkill()) {
                e.setDamage(EntityDamageEvent.DamageModifier.BASE, am.getLastDamageSkillAmount());
            } else if (e.getDamager() instanceof Creeper) {
                if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                    MythicMobs.debug(3, "** Setting Creeper Custom Damage");
                    e.setDamage(am.getDamage());
                }
            } else if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                MythicMobs.debug(3, "** Setting Mob Custom Damage to " + am.getDamage());
                if (am.getDamage() > 0.0 && MythicMobs.inst().getMinecraftVersion() < 8) {
                    e.setDamage(am.getDamage());
                }
            }
            new QueuedMobSkill(SkillTrigger.ATTACK, am, damaged);
        }
    }
}

