/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events;

import java.util.Optional;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Adapters.TaskManager;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.Entities.MythicEntityType;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.Mobs.VanillaManager;
import net.elseland.xikage.MythicMobs.Mobs.WorldScaling;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawnPoint;
import net.elseland.xikage.MythicMobs.RandomSpawning.RandomSpawner;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.plugin.Plugin;

public class MobSpawnListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void MobSpawnEvent(CreatureSpawnEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        if (Configuration.debugMode) {
            return;
        }
        if (Configuration.debugSpawners) {
            return;
        }
        if (MythicMobs.inst().getCompatibility().getWorldGuard().isPresent() && !MythicMobs.inst().getCompatibility().getWorldGuard().get().LocationAllowsMobSpawning(e.getLocation())) {
            return;
        }
        RandomSpawnPoint rsp = new RandomSpawnPoint(BukkitAdapter.adapt((Entity)e.getEntity()), BukkitAdapter.adapt(e.getLocation()), e.getSpawnReason());
        final AbstractEntity spawn = BukkitAdapter.adapt((Entity)e.getEntity());
        Entity ee = RandomSpawner.handleSpawnEvent(rsp);
        if (ee != null) {
            e.setCancelled(true);
        } else if (e.getSpawnReason() != CreatureSpawnEvent.SpawnReason.CUSTOM) {
            MythicEntityType met = VanillaManager.getMythicEntityType((Entity)e.getEntity());
            Optional<MythicMob> maybeType = MythicMobs.inst().getMobManager().getVanillaType(met);
            if (maybeType.isPresent()) {
                MythicMob mm = maybeType.get();
                int level = 1 + WorldScaling.getLevelBonus(spawn.getLocation());
                ActiveMob am = MythicMobs.inst().getMobManager().registerActiveMob(spawn, mm, level);
                mm.getMythicEntity().applyOptions((Entity)e.getEntity());
                mm.applyMobOptions(am, level);
                mm.applyMobVolatileOptions(am);
                mm.applySpawnModifiers(am);
            }
        }
        if (e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            LivingEntity l;
            if (Configuration.UseCompatibilityMode) {
                l = e.getEntity();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (!MythicMobs.inst().getMobManager().isActiveMob(spawn.getUniqueId())) {
                            MythicMobs.debug(3, "Compatibility mode enabled and found custom mob spawn! Checking for MythicMob '" + l.getCustomName() + "'...");
                            MythicMob mm = MythicMobs.inst().getMobManager().getMythicMobByDisplayCompat(spawn);
                            if (mm != null) {
                                MythicMobs.inst().getMobManager().SetupMythicMobCompat(l, mm);
                            } else {
                                MythicMobs.inst().getMobManager().getVoidList().add(l.getUniqueId());
                            }
                        }
                    }
                }, 10L);
            } else {
                l = e.getEntity();
                TaskManager.get().runLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!MythicMobs.inst().getMobManager().isActiveMob(l.getUniqueId())) {
                            MythicMobs.inst().getMobManager().getVoidList().add(l.getUniqueId());
                        }
                    }
                }, 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMobTame(EntityTameEvent event) {
        LivingEntity e = event.getEntity();
        if (MythicMobs.inst().getMobManager().isActiveMob(e.getUniqueId())) {
            final ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)e);
            TaskManager.get().runLater(new Runnable(){

                @Override
                public void run() {
                    am.getType().applyMobOptions(am, am.getLevel());
                    am.getType().applyMobVolatileOptions(am);
                }
            }, 5);
        }
    }
}

