/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit.Events;

import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.QueuedMobSkill;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void ChunkLoadEvent(ChunkLoadEvent e) {
        if (e.getChunk() == null) {
            return;
        }
        ChunkLoader cl = new ChunkLoader(e.getChunk());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)cl, 40L);
    }

    private class ChunkLoader
    implements Runnable {
        private Chunk c;

        public ChunkLoader(Chunk c) {
            this.c = c;
        }

        @Override
        public void run() {
            if (this.c == null) {
                return;
            }
            Entity[] el = this.c.getEntities();
            if (el.length == 0) {
                return;
            }
            for (Entity ee : el) {
                ActiveMob am;
                if (!(ee instanceof LivingEntity)) continue;
                LivingEntity l = (LivingEntity)ee;
                if (MythicMobs.inst().getMobManager().isActiveMob(ee.getUniqueId())) {
                    if (l.getRemoveWhenFarAway()) {
                        ee.remove();
                        return;
                    }
                    am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)ee));
                    if (am.getType().getDespawns()) {
                        MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                        ee.remove();
                        continue;
                    }
                    am.getType().applyMobVolatileOptions(am);
                    continue;
                }
                am = MythicMobs.inst().getMobManager().registerActiveMob(BukkitAdapter.adapt((Entity)l));
                if (am == null) continue;
                new QueuedMobSkill(SkillTrigger.SPAWN, am, null);
            }
        }
    }
}

