/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.elseland.xikage.MythicMobs.Adapters.AbstractWorld;
import net.elseland.xikage.MythicMobs.Adapters.WorldManager;
import org.bukkit.Chunk;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class BukkitWorldManager
implements WorldManager,
Listener {
    private Set<String> loadedChunks = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        String chunk = this.getChunkString(world, x, z);
        return this.loadedChunks.contains(chunk);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(ChunkLoadEvent event) {
        String chunk = this.getChunkString(event.getChunk());
        this.loadedChunks.add(chunk);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkUnload(ChunkUnloadEvent event) {
        String chunk = this.getChunkString(event.getChunk());
        this.loadedChunks.remove(chunk);
    }

    public String getChunkString(AbstractWorld world, int x, int z) {
        return world.getName() + "." + x + "." + z;
    }

    public String getChunkString(Chunk chunk) {
        return chunk.getWorld().getName() + "." + chunk.getX() + "." + chunk.getZ();
    }
}

