/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.Adapters.Bukkit;

import java.util.ArrayList;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.AbstractSkillAdapter;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.IO.Load.Configuration;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.Mechanics.ShootMechanic;
import net.elseland.xikage.MythicMobs.Skills.SkillCaster;
import net.elseland.xikage.MythicMobs.Util.MythicUtil;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Button;
import org.bukkit.material.Lever;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class BukkitSkillAdapter
implements AbstractSkillAdapter {
    @Override
    public void doDamage(SkillCaster am, AbstractEntity t, double damage, boolean ignorearmor, boolean preventKnockback, boolean preventImmunity) {
        LivingEntity target;
        block13: {
            am.setUsingDamageSkill(true);
            if (am instanceof ActiveMob) {
                ((ActiveMob)am).setLastDamageSkillAmount(damage);
            }
            LivingEntity source = (LivingEntity)BukkitAdapter.adapt(am.getEntity());
            target = (LivingEntity)BukkitAdapter.adapt(t);
            try {
                if (ignorearmor) {
                    EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(BukkitAdapter.adapt(am.getEntity()), (Entity)target, EntityDamageEvent.DamageCause.CUSTOM, damage);
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        MythicMobs.debug(3, "Damage event cancelled???");
                        am.setUsingDamageSkill(false);
                        return;
                    }
                    if (target.getHealth() - damage < 1.0) {
                        target.setHealth(0.1);
                        if (preventKnockback) {
                            target.damage(10.0);
                        } else {
                            target.damage(10.0, (Entity)source);
                        }
                    } else {
                        target.setHealth(target.getHealth() - damage);
                        target.playEffect(EntityEffect.HURT);
                    }
                } else if (preventKnockback) {
                    target.damage(damage);
                } else {
                    target.damage(damage, (Entity)source);
                }
            }
            catch (Exception ex) {
                am.setUsingDamageSkill(false);
                if (Configuration.debugLevel <= 0) break block13;
                ex.printStackTrace();
            }
        }
        if (preventImmunity) {
            target.setNoDamageTicks(0);
        }
        am.setUsingDamageSkill(false);
    }

    @Override
    public void strikeLightning(AbstractLocation source) {
        BukkitAdapter.adapt(source.getWorld()).strikeLightning(BukkitAdapter.adapt(source));
    }

    @Override
    public void strikeLightningEffect(AbstractLocation source) {
        BukkitAdapter.adapt(source.getWorld()).strikeLightningEffect(BukkitAdapter.adapt(source));
    }

    @Override
    public void shootFireball(SkillCaster am, AbstractEntity target, float velocity, float yield, boolean incendiary, int fireTicks, boolean small, boolean playsound) {
        Vector facing;
        Fireball fireball;
        Entity t = BukkitAdapter.adapt(target);
        Entity l = BukkitAdapter.adapt(am.getEntity());
        if (l instanceof Creature && ((Creature)l).getTarget() == target) {
            fireball = small ? (Fireball)((LivingEntity)l).launchProjectile(SmallFireball.class) : (Fireball)((LivingEntity)l).launchProjectile(Fireball.class);
        } else {
            facing = t.getLocation().toVector().subtract(l.getLocation().toVector()).normalize();
            Location loc = l.getLocation().clone();
            double yaw = Math.toDegrees(Math.atan2(-facing.getX(), facing.getZ()));
            double pitch = Math.toDegrees(-Math.asin(facing.getY()));
            loc.setYaw((float)yaw);
            loc.setPitch((float)pitch);
            loc.add(facing.multiply(2));
            fireball = small ? (Fireball)l.getLocation().getWorld().spawn(loc, SmallFireball.class) : (Fireball)l.getLocation().getWorld().spawn(loc, Fireball.class);
        }
        if (playsound) {
            l.getWorld().playEffect(l.getLocation(), Effect.GHAST_SHOOT, 0);
        }
        facing = BukkitAdapter.adapt(target.getLocation()).toVector().subtract(l.getLocation().toVector()).normalize().multiply(velocity);
        fireball.setVelocity(facing);
        fireball.setBounce(false);
        fireball.setIsIncendiary(incendiary);
        fireball.setFireTicks(fireTicks);
        fireball.setYield(yield);
        if (l instanceof LivingEntity) {
            fireball.setShooter((ProjectileSource)((LivingEntity)l));
        }
    }

    @Override
    public AbstractEntity shootProjectile(SkillCaster caster, AbstractLocation target, AbstractLocation origin, Class<? extends Projectile> projectileClass, float velocity, ShootMechanic.ProjectileData pd, boolean fromOrigin) {
        Projectile projectile;
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Location fTarget = BukkitAdapter.adapt(target);
        if (fromOrigin) {
            Location fOrigin = BukkitAdapter.adapt(origin);
            projectile = (Projectile)fTarget.getWorld().spawn(fOrigin, projectileClass);
            projectile.setVelocity(fTarget.toVector().subtract(fOrigin.toVector()).normalize().multiply(velocity));
        } else {
            projectile = l.launchProjectile(projectileClass);
            projectile.setVelocity(fTarget.toVector().subtract(l.getLocation().toVector()).normalize().multiply(velocity));
        }
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)l);
        projectile.setMetadata("MythicMobsProjectile", (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)pd));
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public AbstractEntity shootArcProjectile(SkillCaster caster, AbstractLocation target, AbstractLocation origin, Class<? extends Projectile> projectileClass, float velocity, ShootMechanic.ProjectileData pd, boolean fromOrigin) {
        Projectile projectile;
        Location from;
        int gravity = 20;
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Location to = BukkitAdapter.adapt(target);
        if (fromOrigin) {
            Location fOrigin;
            from = fOrigin = BukkitAdapter.adapt(origin);
            projectile = (Projectile)from.getWorld().spawn(fOrigin, projectileClass);
        } else {
            from = l.getLocation();
            projectile = l.launchProjectile(projectileClass);
        }
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)l);
        projectile.setMetadata("MythicMobsProjectile", (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)pd));
        Vector test = to.clone().subtract(from).toVector();
        Double elevation = test.getY();
        Double launchAngle = MythicUtil.calculateLaunchAngle(from, to, velocity, elevation, 20.0);
        Double distance = Math.sqrt(Math.pow(test.getX(), 2.0) + Math.pow(test.getZ(), 2.0));
        if (launchAngle == null) {
            launchAngle = Math.atan((40.0 * elevation + Math.pow(velocity, 2.0)) / (40.0 * elevation + 2.0 * Math.pow(velocity, 2.0)));
        }
        Double hangtime = MythicUtil.calculateHangtime(launchAngle, velocity, elevation, 20.0);
        test.setY(Math.tan(launchAngle) * distance);
        test = MythicUtil.normalizeVector(test);
        velocity = (float)((double)velocity + 1.188 * Math.pow(hangtime, 2.0) + (MythicMobs.r.nextDouble() - 0.8) / 2.0);
        test = test.multiply((double)velocity / 20.0);
        projectile.setVelocity(test);
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public AbstractEntity rainProjectile(SkillCaster caster, AbstractLocation source, Class<? extends Projectile> projectileClass, float velocity, ShootMechanic.ProjectileData pd) {
        LivingEntity l = (LivingEntity)caster.getEntity().getBukkitEntity();
        Location s = BukkitAdapter.adapt(source);
        Projectile projectile = (Projectile)l.getWorld().spawn(s, projectileClass);
        Vector v = s.clone().add(0.0, -1.0, 0.0).toVector().subtract(s.toVector()).normalize().multiply(velocity);
        projectile.setVelocity(v);
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)l);
        projectile.setMetadata("MythicMobsProjectile", (MetadataValue)new FixedMetadataValue((Plugin)MythicMobs.inst(), (Object)pd));
        return BukkitAdapter.adapt((Entity)projectile);
    }

    @Override
    public void throwSkill(AbstractLocation source, AbstractEntity target, float velocity, float velocityY) {
        Vector V = BukkitAdapter.adapt(target.getLocation()).toVector().subtract(BukkitAdapter.adapt(source).toVector()).normalize().multiply(velocity);
        if (velocity == 0.0f) {
            V.setY(velocityY);
        } else {
            V.setY((double)velocityY + V.getY());
        }
        target.getBukkitEntity().setVelocity(V);
    }

    @Override
    public void itemSprayEffect(AbstractLocation source, ItemStack item, int amount, int duration, double force, double yForce, double radius, double yOffset, boolean allowPickup) {
        Location l = BukkitAdapter.adapt(source);
        ItemStack is = item;
        is.setAmount(1);
        Location loc = l.clone().add(0.0, yOffset, 0.0);
        final Item[] items = new Item[amount];
        if (radius <= 0.0) {
            for (int i = 0; i < amount; ++i) {
                items[i] = loc.getWorld().dropItem(loc, is);
                items[i].setVelocity(new Vector((MythicMobs.r.nextDouble() - 0.5) * force, (MythicMobs.r.nextDouble() - 0.5) * yForce, (MythicMobs.r.nextDouble() - 0.5) * force));
                try {
                    if (allowPickup) continue;
                    items[i].setPickupDelay(Short.MAX_VALUE);
                    items[i].setTicksLived(5800);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < amount; ++i) {
                Location lx = loc.clone();
                lx.setX(lx.getX() - radius + MythicMobs.r.nextDouble() * (radius * 2.0));
                lx.setZ(lx.getZ() - radius + MythicMobs.r.nextDouble() * (radius * 2.0));
                items[i] = lx.getWorld().dropItem(lx, is);
                items[i].setVelocity(new Vector((MythicMobs.r.nextDouble() - 0.5) * force, (MythicMobs.r.nextDouble() - 0.5) * yForce, (MythicMobs.r.nextDouble() - 0.5) * force));
                try {
                    if (allowPickup) continue;
                    items[i].setPickupDelay(Short.MAX_VALUE);
                    items[i].setTicksLived(5800);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < items.length; ++i) {
                    items[i].remove();
                }
            }
        }, (long)duration);
    }

    @Override
    public void playSmokeEffect(AbstractLocation source, int direction) {
        BukkitAdapter.adapt(source).getWorld().playEffect(BukkitAdapter.adapt(source), Effect.SMOKE, direction);
    }

    @Override
    public void pushButton(SkillCaster am, int x, int y, int z) {
        Location l = new Location(BukkitAdapter.adapt(am.getEntity().getWorld()), (double)x, (double)y, (double)z);
        Block block = l.getWorld().getBlockAt(l);
        MythicMobs.debug(2, "Executing pushbutton skill @ " + x + "," + y + "," + z + " blockID=" + block.getTypeId());
        try {
            Button button = new Button(Material.STONE_BUTTON, block.getData());
            button.setPowered(true);
            BlockRedstoneEvent toggle = new BlockRedstoneEvent(block, 0, 1);
            Bukkit.getPluginManager().callEvent((Event)toggle);
            block.setTypeIdAndData(block.getTypeId(), button.getData(), true);
            ButtonUnpusher BU = new ButtonUnpusher(block);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)BU, 10L);
        }
        catch (Exception e) {
            MythicMobs.error("A pushbutton skill is improperly configured: block is not a button.");
            return;
        }
    }

    @Override
    public void toggleLever(SkillCaster am, int x, int y, int z, int duration) {
        Location l = new Location(BukkitAdapter.adapt(am.getEntity().getWorld()), (double)x, (double)y, (double)z);
        Block block = l.getWorld().getBlockAt(l);
        MythicMobs.debug(2, "Executing togglelever skill @ " + x + "," + y + "," + z + " blockID=" + block.getTypeId() + "duration=" + duration);
        try {
            Lever button = new Lever(Material.LEVER, block.getData());
            button.setPowered(true);
            BlockRedstoneEvent toggle = new BlockRedstoneEvent(block, 0, 1);
            Bukkit.getPluginManager().callEvent((Event)toggle);
            block.setTypeIdAndData(block.getTypeId(), button.getData(), true);
            LeverUnswitcher BU = new LeverUnswitcher(block);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, (Runnable)BU, (long)duration);
        }
        catch (Exception e) {
            MythicMobs.error("A ToggleLever skill is improperly configured: block is not a button.");
        }
    }

    @Override
    public void executeVolley(SkillCaster am, AbstractLocation t, int amount, float velocity, float spread, int fireTicks, int removeDelay) {
        if (!(am.getEntity().getBukkitEntity() instanceof ProjectileSource)) {
            return;
        }
        ProjectileSource source = (ProjectileSource)am.getEntity().getBukkitEntity();
        Location target = BukkitAdapter.adapt(t);
        Location spawn = BukkitAdapter.adapt(am.getLocation()).clone();
        spawn.setY(spawn.getY() + 3.0);
        Vector v = target == null ? spawn.getDirection() : target.toVector().subtract(spawn.toVector()).normalize();
        final ArrayList<Arrow> arrowList = new ArrayList<Arrow>();
        for (int i = 0; i < amount; ++i) {
            Arrow a = spawn.getWorld().spawnArrow(spawn, v, velocity, spread / 10.0f);
            a.setVelocity(a.getVelocity());
            if (am.getEntity() != null) {
                a.setShooter(source);
            }
            if (fireTicks > 0) {
                a.setFireTicks(fireTicks);
            }
            arrowList.add(a);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.plugin, new Runnable(){

            @Override
            public void run() {
                for (Arrow a : arrowList) {
                    a.remove();
                }
                arrowList.clear();
            }
        }, (long)removeDelay);
    }

    private static class LeverUnswitcher
    implements Runnable {
        private Block block;

        public LeverUnswitcher(Block block) {
            this.block = block;
        }

        @Override
        public void run() {
            try {
                if (!this.block.getChunk().isLoaded()) {
                    this.block.getChunk().load();
                }
                Lever button = new Lever(Material.LEVER, this.block.getData());
                button.setPowered(false);
                BlockRedstoneEvent toggle = new BlockRedstoneEvent(this.block, 0, 1);
                Bukkit.getPluginManager().callEvent((Event)toggle);
                this.block.setTypeIdAndData(this.block.getTypeId(), button.getData(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ButtonUnpusher
    implements Runnable {
        private Block block;

        public ButtonUnpusher(Block block) {
            this.block = block;
        }

        @Override
        public void run() {
            try {
                this.block.getChunk().load();
                Button button = new Button(Material.STONE_BUTTON, this.block.getData());
                button.setPowered(false);
                BlockRedstoneEvent toggle = new BlockRedstoneEvent(this.block, 0, 1);
                Bukkit.getPluginManager().callEvent((Event)toggle);
                this.block.setTypeIdAndData(this.block.getTypeId(), button.getData(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

