/*
 * Decompiled with CFR 0.152.
 */
package net.elseland.xikage.MythicMobs.API.Bukkit;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.elseland.xikage.MythicMobs.API.Exceptions.InvalidMobTypeException;
import net.elseland.xikage.MythicMobs.API.IMobsAPI;
import net.elseland.xikage.MythicMobs.Adapters.AbstractEntity;
import net.elseland.xikage.MythicMobs.Adapters.AbstractLocation;
import net.elseland.xikage.MythicMobs.Adapters.Bukkit.BukkitAdapter;
import net.elseland.xikage.MythicMobs.Mobs.ActiveMob;
import net.elseland.xikage.MythicMobs.Mobs.MythicMob;
import net.elseland.xikage.MythicMobs.MythicMobs;
import net.elseland.xikage.MythicMobs.Skills.Skill;
import net.elseland.xikage.MythicMobs.Skills.SkillMetadata;
import net.elseland.xikage.MythicMobs.Skills.SkillTrigger;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class BukkitMobsAPI
implements IMobsAPI {
    @Override
    public MythicMob getMythicMob(String type) {
        return MythicMobs.inst().getMobManager().getMythicMob(type);
    }

    @Override
    public Entity spawnMythicMob(MythicMob type, Location location) throws InvalidMobTypeException {
        return this.spawnMythicMob(type, location, 1);
    }

    @Override
    public Entity spawnMythicMob(MythicMob type, Location location, int level) throws InvalidMobTypeException {
        if (type == null) {
            throw new InvalidMobTypeException("Supplied mob type cannot be null.");
        }
        return type.spawn(BukkitAdapter.adapt(location), level).getEntity().getBukkitEntity();
    }

    @Override
    public Entity spawnMythicMob(String type, Location location) throws InvalidMobTypeException {
        return this.spawnMythicMob(type, location, 1);
    }

    @Override
    public Entity spawnMythicMob(String type, Location location, int level) throws InvalidMobTypeException {
        MythicMob mm = MythicMobs.inst().getMobManager().getMythicMob(type);
        if (mm == null) {
            throw new InvalidMobTypeException(type + " is not a valid Mythic Mob type.");
        }
        return mm.spawn(BukkitAdapter.adapt(location), level).getEntity().getBukkitEntity();
    }

    @Override
    public boolean isMythicMob(Entity l) {
        return MythicMobs.inst().getMobManager().isActiveMob(BukkitAdapter.adapt(l));
    }

    @Override
    public boolean isMythicMob(UUID u) {
        return MythicMobs.inst().getMobManager().isActiveMob(u);
    }

    @Override
    public ActiveMob getMythicMobInstance(Entity e) {
        return MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e));
    }

    @Override
    public boolean castSkill(Entity e, String skillName) {
        return this.castSkill(e, skillName, e.getLocation(), 1.0f);
    }

    @Override
    public boolean castSkill(Entity e, String skillName, float power) {
        return this.castSkill(e, skillName, e.getLocation(), power);
    }

    @Override
    public boolean castSkill(Entity e, String skillName, Location origin) {
        return true;
    }

    @Override
    public boolean castSkill(Entity e, String skillName, Location origin, float power) {
        return this.castSkill(e, skillName, null, origin, null, null, power);
    }

    @Override
    public boolean castSkill(Entity e, String skillName, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power) {
        return this.castSkill(e, skillName, null, origin, eTargets, lTargets, power);
    }

    @Override
    public boolean castSkill(Entity e, String skillName, Entity trigger, Location origin, Collection<Entity> eTargets, Collection<Location> lTargets, float power) {
        SkillMetadata data;
        if (!MythicMobs.inst().getMobManager().isActiveMob(e.getUniqueId())) {
            return false;
        }
        Optional<Skill> maybeSkill = MythicMobs.inst().getSkillManager().getSkill(skillName);
        if (!maybeSkill.isPresent()) {
            return false;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(e);
        Skill skill = maybeSkill.get();
        HashSet<AbstractEntity> feTargets = new HashSet<AbstractEntity>();
        HashSet<AbstractLocation> flTargets = new HashSet<AbstractLocation>();
        if (eTargets != null) {
            for (Entity en : eTargets) {
                feTargets.add(BukkitAdapter.adapt(en));
            }
        }
        if (lTargets != null) {
            for (Location l : lTargets) {
                flTargets.add(BukkitAdapter.adapt(l));
            }
        }
        if (skill.usable(data = new SkillMetadata(SkillTrigger.API, am, BukkitAdapter.adapt(trigger), BukkitAdapter.adapt(origin), feTargets, flTargets, power), SkillTrigger.API)) {
            skill.execute(data);
        }
        return true;
    }
}

