/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.SlimefunStartup;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class BlockMenuPreset
extends ChestMenu {
    public static Map<String, BlockMenuPreset> presets = new HashMap<String, BlockMenuPreset>();
    private String title;
    private Set<Integer> occupied = new HashSet<Integer>();
    private String id;
    private int size = -1;
    private boolean universal;
    private ItemManipulationEvent event;

    public BlockMenuPreset(String id, String title) {
        super(title);
        this.id = id;
        this.title = title;
        this.init();
        this.universal = false;
        presets.put(id, this);
    }

    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public BlockMenuPreset(String id, String title, boolean universal) {
        super(title);
        this.id = id;
        this.title = title;
        this.init();
        this.universal = universal;
        presets.put(id, this);
    }

    public abstract void init();

    public abstract void newInstance(BlockMenu var1, Block var2);

    public abstract boolean canOpen(Block var1, Player var2);

    public abstract int[] getSlotsAccessedByItemTransport(ItemTransportFlow var1);

    public int[] getSlotsAccessedByItemTransport(BlockMenu menu, ItemTransportFlow flow, ItemStack item) {
        return this.getSlotsAccessedByItemTransport(flow);
    }

    public int[] getSlotsAccessedByItemTransport(UniversalBlockMenu menu, ItemTransportFlow flow, ItemStack item) {
        return this.getSlotsAccessedByItemTransport(flow);
    }

    public ChestMenu addItem(int slot, ItemStack item) {
        this.occupied.add(slot);
        return super.addItem(slot, item);
    }

    public ChestMenu setSize(int size) {
        this.size = size;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<Integer> getPresetSlots() {
        return this.occupied;
    }

    public Set<Integer> getInventorySlots() {
        HashSet<Integer> empty = new HashSet<Integer>();
        if (this.size > -1) {
            int i = 0;
            while (i < this.size) {
                if (!this.occupied.contains(i)) {
                    empty.add(i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.toInventory().getSize()) {
                if (!this.occupied.contains(i)) {
                    empty.add(i);
                }
                ++i;
            }
        }
        return empty;
    }

    public static BlockMenuPreset getPreset(String id) {
        return presets.get(id);
    }

    public static boolean isInventory(String id) {
        return presets.containsKey(id);
    }

    public static boolean isUniversalInventory(String id) {
        return presets.containsKey(id) && presets.get(id).isUniversal();
    }

    public boolean isUniversal() {
        return this.universal;
    }

    public void clone(BlockMenu menu) {
        int slot2;
        menu.setPlayerInventoryClickable(true);
        for (int slot2 : this.occupied) {
            menu.addItem(slot2, this.getItemInSlot(slot2));
        }
        if (this.size > -1) {
            menu.addItem(this.size - 1, null);
        }
        this.newInstance(menu, menu.getLocation());
        slot2 = 0;
        while (slot2 < 54) {
            if (this.getMenuClickHandler(slot2) != null) {
                menu.addMenuClickHandler(slot2, this.getMenuClickHandler(slot2));
            }
            ++slot2;
        }
        menu.addMenuOpeningHandler(this.getMenuOpeningHandler());
        menu.addMenuCloseHandler(this.getMenuCloseHandler());
        menu.registerEvent(this.event);
    }

    public void clone(UniversalBlockMenu menu) {
        int slot2;
        menu.setPlayerInventoryClickable(true);
        for (int slot2 : this.occupied) {
            menu.addItem(slot2, this.getItemInSlot(slot2));
        }
        if (this.size > -1) {
            menu.addItem(this.size - 1, null);
        }
        slot2 = 0;
        while (slot2 < 54) {
            if (this.getMenuClickHandler(slot2) != null) {
                menu.addMenuClickHandler(slot2, this.getMenuClickHandler(slot2));
            }
            ++slot2;
        }
        menu.addMenuOpeningHandler(this.getMenuOpeningHandler());
        menu.addMenuCloseHandler(this.getMenuCloseHandler());
        menu.registerEvent(this.event);
    }

    public String getID() {
        return this.id;
    }

    public void newInstance(final BlockMenu menu, final Location l) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunStartup.instance, new Runnable(){

            @Override
            public void run() {
                BlockMenuPreset.this.newInstance(menu, l.getBlock());
            }
        });
    }
}

